/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import net.fexcraft.mod.fvtm.data.FvtmPlayer;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.uni.Appendable;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;

public class Passenger
implements Appendable<UniEntity> {
    public int vehicle = -1;
    public int seat = -1;
    public final EntityW entity;

    public Passenger(UniEntity ent) {
        this.entity = ent == null ? null : ent.entity;
    }

    public Appendable<UniEntity> create(UniEntity ent) {
        return new Passenger(ent);
    }

    public String id() {
        return "fvtm:passenger";
    }

    public SeatInstance getSeatOn() {
        if (this.entity.getVehicleDirect() instanceof VehicleInstance.Holder) {
            return ((VehicleInstance.Holder)this.entity.getVehicleDirect()).getVehicleInstance().getSeatOf(this.entity);
        }
        return null;
    }

    public VehicleInstance getVehicle() {
        if (this.entity.getVehicleDirect() instanceof VehicleInstance.Holder) {
            return ((VehicleInstance.Holder)this.entity.getVehicleDirect()).getVehicleInstance();
        }
        return null;
    }

    public void set(int veh, int seatid) {
        VehicleInstance vi;
        if (this.entity.isOnClient() && this.entity.isRiding() && seatid > -1) {
            vi = this.getVehicle();
            for (SeatInstance seat : vi.seats) {
                if (seat.passenger_direct() != this.entity) continue;
                seat.passenger(null);
            }
        }
        this.vehicle = veh;
        this.seat = seatid;
        if (this.entity.isOnClient()) {
            if (this.vehicle < 0) {
                return;
            }
            if (this.entity.getVehicleDirect() == null) {
                this.entity.mount(veh);
            }
            vi = this.getVehicle();
            vi.seats.get(seatid).passenger(this.entity);
        } else {
            this.sendPassUpdate(this.entity.getId(), this.vehicle, this.seat);
            if (this.entity.isPlayer()) {
                FvtmPlayer fp = (FvtmPlayer)UniEntity.getApp((Object)this.entity.direct(), FvtmPlayer.class);
                if (fp == null || fp.notified) {
                    return;
                }
                try {
                    this.entity.send("fvtm.seat.controls_info");
                    this.entity.sendLink("https://fexcraft.net/wiki/mod/fvtm/controls");
                    fp.notified = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void sendPassUpdate(int ent, int veh, int seat) {
        TagCW com = TagCW.create();
        com.set("ent", ent);
        com.set("veh", veh);
        com.set("seat", seat);
        Packets.sendInRange(Packets.PKT_TAG, this.entity, "upd_pass", com);
    }

    public void reqPassUpdate() {
        TagCW com = TagCW.create();
        com.set("ent", this.entity.getId());
        Packets.send(Packets.PKT_TAG, "upd_pass", com);
    }

    public void onPacket(EntityW pass, TagCW packet) {
        if (this.entity instanceof VehicleInstance.Holder) {
            ((VehicleInstance.Holder)this.entity).onPacket(pass, packet);
        }
    }
}

