/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.Fuel;
import net.fexcraft.mod.fvtm.data.FuelFiller;
import net.fexcraft.mod.fvtm.ui.FuelFillerCon;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class FuelFillerUI
extends UserInterface {
    private FuelFillerCon con;
    private int fuelidx;

    public FuelFillerUI(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        this.con = (FuelFillerCon)container;
    }

    public void init() {
        this.fuelidx = FvtmRegistry.FUELS.indexOf(this.con.filler.selected);
        this.updateSelectedText(true);
    }

    public void predraw(float t, int x, int y) {
        ((UIText)this.texts.get("stored")).value("ui.fvtm.fuel_filler.stored");
        ((UIText)this.texts.get("stored")).translate(new Object[]{this.con.filler.tank.amount()});
        ((UIText)this.texts.get("converted")).value("ui.fvtm.fuel_filler.converted");
        ((UIText)this.texts.get("converted")).translate(new Object[]{Float.valueOf(this.con.filler.converted)});
    }

    public void drawbackground(float t, int x, int y) {
        int a = (int)((float)this.con.filler.tank.amount() / (float)FuelFiller.tanksize * 100.0f);
        if (a > 0) {
            this.drawer.draw((float)(this.gLeft + 10), (float)(this.gTop + 49), 0, 219, a, 18);
        }
        if ((a = (int)(this.con.filler.converted / (float)FuelFiller.tanksize * 100.0f)) > 0) {
            this.drawer.draw((float)(this.gLeft + 10), (float)(this.gTop + 83), 0, 238, a, 18);
        }
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "prev": {
                if (--this.fuelidx < 0) {
                    this.fuelidx = FvtmRegistry.FUELS.size() - 1;
                }
                this.updateSelectedText(false);
                return true;
            }
            case "next": {
                if (++this.fuelidx >= FvtmRegistry.FUELS.size()) {
                    this.fuelidx = 0;
                }
                this.updateSelectedText(false);
                return true;
            }
            case "confirm": {
                TagCW com = TagCW.create();
                com.set("sel", ((Fuel)FvtmRegistry.FUELS.get(this.fuelidx)).getIDS());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
        }
        return false;
    }

    protected void updateSelectedText(boolean packet) {
        ((UIText)this.texts.get("selected")).value(((Fuel)FvtmRegistry.FUELS.get(this.fuelidx)).getName());
        if (packet) {
            ((UIText)this.texts.get("info")).value("ui.fvtm.fuel_filler.warning");
            ((UIText)this.texts.get("info")).translate();
        } else {
            ((UIText)this.texts.get("info")).value("ui.fvtm.fuel_filler.current");
            ((UIText)this.texts.get("info")).translate(new Object[]{this.con.filler.selected.getName()});
        }
    }
}

