/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.content.ClothModel;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.inv.ClothMaterial;

public class Cloth
extends Content<Cloth>
implements ItemTextureable,
WithItem {
    protected short max_health;
    protected String ctab;
    protected String modelid;
    protected String eq_slot;
    protected ClothMaterial material;
    protected ClothModel model;
    protected ModelData modeldata;
    protected IDL texture;
    protected IDL itemloc;

    @Override
    public Cloth parse(JsonMap map) {
        String mat;
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Clothing");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.max_health = (short)map.getInteger("MaxItemDamage", 0);
        this.eq_slot = map.getString("EquipmentSlot", "head");
        this.material = map.has("ClothMaterial") ? ClothMaterial.get((String)((mat = map.get("ClothMaterial").string_value().toLowerCase()).contains(":") ? mat : this.getAddon().getID().id() + ":" + mat)) : ClothMaterial.get((IDL)FvtmRegistry.NONE_CLOTH_MAT);
        this.texture = IDLManager.getIDLNamed((String)((String)map.get("Texture", (Object)FvtmResources.NULL_TEXTURE.colon())));
        if (EnvInfo.CLIENT || EnvInfo.is121()) {
            this.modelid = map.getString("Model", null);
            this.modeldata = new ModelData(map);
        }
        this.ctab = map.getString("CreativeTab", "default");
        this.itemloc = ContentConfigUtil.getItemTexture(this.id, this.getContentType(), map);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.CLOTH;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    public int getMaxDamage() {
        return this.max_health;
    }

    @Override
    public String getItemContainer() {
        return null;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    public String getEqSlot() {
        return this.eq_slot;
    }

    public ClothMaterial getMaterial() {
        return this.material;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    public ClothModel getClothModel() {
        return this.model;
    }

    @Override
    public void loadModel() {
        this.model = (ClothModel)FvtmResources.getModel(this.modelid, this.modeldata, ClothModel.class);
    }

    public IDL getTexture() {
        return this.texture;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemloc;
    }
}

