/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import java.util.List;
import java.util.TreeMap;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.world.EntityW;

public class Seat {
    public V3D pos;
    public V3D dis;
    public boolean driver;
    public boolean sitting;
    public String name;
    public float minyaw;
    public float maxyaw;
    public float defyaw;
    public float minpitch;
    public float maxpitch;
    public float defpitch;
    public String swivel_point;
    public boolean relative;
    public TreeMap<String, Boolean> filter = null;
    public Float scale;

    public Seat(String seatname, JsonMap map) {
        this.pos = ContentConfigUtil.getVector(map.getArray("pos"));
        this.driver = map.getBoolean("driver", false);
        this.name = seatname;
        this.minyaw = map.getFloat("min_yaw", -90.0f);
        this.maxyaw = map.getFloat("max_yaw", 90.0f);
        this.minpitch = map.getFloat("min_pitch", -80.0f);
        this.maxpitch = map.getFloat("max_pitch", 80.0f);
        this.sitting = map.getBoolean("sitting", true);
        this.swivel_point = map.getString("swivel_point", "vehicle");
        this.relative = map.getBoolean("relative", false);
        this.defyaw = map.getFloat("def_yaw", 0.0f);
        this.defpitch = map.getFloat("def_pitch", 0.0f);
        if (map.has("filter")) {
            this.filter = new TreeMap();
            JsonArray array = map.get("filter").asArray();
            for (JsonValue elm : (List)array.value) {
                boolean bool;
                String str = elm.string_value();
                boolean bl = bool = !str.startsWith("!");
                if (!bool) {
                    str = str.substring(1);
                }
                this.filter.put(str, bool);
            }
        }
        if (map.has("scale")) {
            this.scale = Float.valueOf(map.get("scale").float_value());
        }
        this.dis = map.has("dismount") ? ContentConfigUtil.getVector(map.getArray("dismount")) : this.pos.copy();
    }

    public Seat(String name, V3D pos, boolean driver, String point) {
        this.driver = driver;
        this.name = name;
        this.minyaw = -90.0f;
        this.maxyaw = 90.0f;
        this.minpitch = -80.0f;
        this.maxpitch = 80.0f;
        this.sitting = true;
        this.swivel_point = point;
    }

    public Seat(String name, V3D pos, boolean driver, boolean sitting, String point) {
        this(name, pos, driver, point);
        this.sitting = sitting;
    }

    public Seat(String name, V3D pos, boolean driver, boolean sitting, String point, boolean relative) {
        this(name, pos, driver, sitting, point);
        this.relative = relative;
    }

    public Seat(String name, V3D pos, boolean driver, boolean sitting, String point, boolean relative, float dy, float dp) {
        this(name, pos, driver, sitting, point, relative);
        this.defpitch = 0.0f;
        this.defyaw = 0.0f;
    }

    public Seat scale(Float scale) {
        this.scale = scale;
        return this;
    }

    public float scale() {
        return this.scale == null ? 1.0f : this.scale.floatValue();
    }

    public boolean isDriver() {
        return this.driver;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.format("Seat@[(%s, %s, %s), %s, %s-driver, %s-%sy, %s-%sp, %s-sit, %s-scl]", this.pos.x, this.pos.y, this.pos.z, this.name, this.driver, Float.valueOf(this.minyaw), Float.valueOf(this.maxyaw), Float.valueOf(this.minpitch), Float.valueOf(this.maxpitch), this.sitting, this.scale);
    }

    public Seat copy(V3D partpos) {
        if (partpos == null || !this.relative) {
            return this;
        }
        return new Seat(this.name, this.pos.add(partpos), this.driver, this.sitting, this.swivel_point, this.relative, this.defyaw, this.defpitch);
    }

    public boolean allow(EntityW ent) {
        if (this.filter == null) {
            return this.driver ? ent.isPlayer() : true;
        }
        Boolean bool = null;
        if (ent.isPlayer() && (bool = this.filter.get("players")) != null) {
            return bool;
        }
        bool = this.filter.get(ent.getRegName());
        if (bool != null) {
            return bool;
        }
        if (ent.isAnimal() && (bool = this.filter.get("animals")) != null) {
            return bool;
        }
        if (ent.isHostile() && (bool = this.filter.get("hostile")) != null) {
            return bool;
        }
        return false;
    }
}

