/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.attribute;

import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.mod.fvtm.data.attribute.AttrValueType;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;

public class AttrVector
extends Attribute<Vec3f> {
    public AttrVector(String id, JsonMap map) {
        this(id, AttrVector.tovec(map.has("value") ? map.getArray("value") : null));
        this.value = ((Vec3f)this.initial).copy();
    }

    private static Vec3f tovec(JsonArray arr) {
        if (arr == null) {
            return new Vec3f();
        }
        return new Vec3f(arr.get(0).float_value(), arr.get(1).float_value(), arr.get(2).float_value());
    }

    public AttrVector(String aid, Vec3f val) {
        super(aid, AttrValueType.VECTOR, val);
    }

    @Override
    public Vec3f validate(Object val) {
        Vec3f vec = null;
        if (val == null) {
            vec = new Vec3f();
        } else if (val instanceof Vec3f) {
            vec = ((Vec3f)val).copy();
        } else if (val instanceof Number) {
            vec.x = ((Number)val).floatValue();
            vec.y = ((Number)val).floatValue();
            vec.z = ((Number)val).floatValue();
        } else {
            vec = this.parse(val.toString());
        }
        if (vec.x > this.max) {
            vec.x = this.max;
        }
        if (vec.y > this.max) {
            vec.y = this.max;
        }
        if (vec.z > this.max) {
            vec.z = this.max;
        }
        if (vec.x < this.min) {
            vec.x = this.min;
        }
        if (vec.y < this.min) {
            vec.y = this.min;
        }
        if (vec.z < this.min) {
            vec.z = this.min;
        }
        return vec;
    }

    @Override
    public Vec3f parse(String val) {
        Vec3f vec = null;
        if (val.contains(",")) {
            vec = new Vec3f();
            String[] split = val.split(",");
            vec.x = Float.parseFloat(split[0]);
            vec.y = Float.parseFloat(split[1]);
            vec.z = Float.parseFloat(split[2]);
        } else {
            vec.y = vec.z = Float.parseFloat(val);
            vec.x = vec.z;
        }
        return vec;
    }

    @Override
    public void increase(float by) {
        ((Vec3f)this.value).x += by;
    }

    @Override
    public void decrease(float by) {
        ((Vec3f)this.value).x -= by;
    }

    @Override
    public String type() {
        return "vector3";
    }

    @Override
    public void saveValue(TagCW com) {
        TagLW tag = TagLW.create();
        tag.add(((Vec3f)this.value).x);
        tag.add(((Vec3f)this.value).y);
        tag.add(((Vec3f)this.value).z);
        com.set(this.id, tag);
    }

    @Override
    public void loadValue(TagCW com) {
        if (!com.has(this.id)) {
            return;
        }
        TagLW tag = com.getList(this.id);
        ((Vec3f)this.value).x = tag.getFloat(0);
        ((Vec3f)this.value).y = tag.getFloat(1);
        ((Vec3f)this.value).z = tag.getFloat(2);
    }

    @Override
    public Attribute<Vec3f> newInstance() {
        return new AttrVector(this.id, ((Vec3f)this.initial).copy());
    }

    @Override
    public int asInteger() {
        return (int)((Vec3f)this.value).x;
    }

    @Override
    public long asLong() {
        return (long)((Vec3f)this.value).x;
    }

    @Override
    public float asFloat() {
        return ((Vec3f)this.value).x;
    }

    @Override
    public String asString() {
        return ((Vec3f)this.value).toString();
    }

    @Override
    public boolean asBoolean() {
        return ((Vec3f)this.value).x > 0.0f;
    }
}

