/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.inv;

import java.util.ArrayList;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.inv.InvType;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.UIKey;
import net.fexcraft.mod.uni.world.EntityW;

public abstract class FvtmInv {
    public ArrayList<String> access;
    public final InvType type;
    public boolean external;
    public String point;
    public float scale;
    public V3D pos;

    protected FvtmInv(InvType type) {
        this.type = type;
    }

    public void init0(JsonMap map) {
        this.access = map.has("access") ? map.getArray("access").toStringList() : new ArrayList();
        this.pos = map.has("pos") ? ContentConfigUtil.getVector(map.getArray("pos")) : new V3D();
        this.external = this.access.contains("external");
        this.scale = map.getFloat("scale", 1.0f);
    }

    public abstract <Inv extends FvtmInv> Inv init(JsonMap var1);

    public abstract TagCW save(TagCW var1, String var2);

    public abstract void load(TagCW var1, String var2);

    public abstract <Inv extends FvtmInv> Inv copy();

    public abstract void clearAt(EntityW var1);

    protected void copy(FvtmInv inv) {
        inv.access = this.access;
        inv.external = this.external;
        inv.scale = this.scale;
        inv.pos = this.pos;
    }

    public UIKey getUIKey(ContentType ctype) {
        switch (ctype) {
            case VEHICLE: {
                switch (this.type) {
                    case STACK: {
                        return UIKeys.VEHICLE_INVENTORY_STACK;
                    }
                    case ITEM: {
                        return UIKeys.VEHICLE_INVENTORY_ITEM;
                    }
                    case FLUID: {
                        return UIKeys.VEHICLE_INVENTORY_FLUID;
                    }
                    case ENERGY: {
                        return null;
                    }
                    case CONTAINER: {
                        return null;
                    }
                    case VARIABLE: {
                        return null;
                    }
                }
            }
        }
        return null;
    }
}

