/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.DecorationData;
import net.fexcraft.mod.fvtm.item.DecorationItem;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.packet.Packet_TagListener;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class DecorationEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public ArrayList<DecorationData> decos = new ArrayList();
    protected boolean locked;

    public DecorationEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    protected void m_8097_() {
    }

    public void m_7378_(CompoundTag tag) {
        this.decos.clear();
        if (tag.m_128441_("decorations")) {
            ListTag list = (ListTag)tag.m_128423_("decorations");
            for (int i = 0; i < list.size(); ++i) {
                this.decos.add(FvtmResources.getDecorationData(TagCW.wrap((Object)list.get(i))));
            }
        }
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.decos.size() == 0) {
            return;
        }
        ListTag list = new ListTag();
        for (DecorationData deco : this.decos) {
            list.add((Object)((Tag)deco.write(TagCW.create()).local()));
        }
        tag.m_128365_("decorations", (Tag)list);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        try {
            buffer.writeBoolean(this.locked);
            buffer.writeInt(this.decos.size());
            for (DecorationData deco : this.decos) {
                buffer.m_130079_((CompoundTag)deco.write(TagCW.create()).local());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        try {
            this.locked = buffer.readBoolean();
            this.decos.clear();
            int amount = buffer.readInt();
            for (int i = 0; i < amount; ++i) {
                this.decos.add(FvtmResources.getDecorationData(TagCW.wrap((Object)buffer.m_130260_())));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6087_() {
        return true;
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (this.m_213877_() || this.m_9236_().f_46443_ || hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_41720_() instanceof MaterialItem && ((MaterialItem)stack.m_41720_()).getContent().isVehicleKey()) {
            this.locked = !this.locked;
            player.m_213846_((Component)Component.m_237113_((String)"Toggled Deco Lock status."));
            return InteractionResult.SUCCESS;
        }
        if (this.locked) {
            player.m_213846_((Component)Component.m_237113_((String)"Deco is locked."));
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41619_() || stack.m_41720_() instanceof DecorationItem) {
            DecorationData data;
            if (stack.m_41720_() instanceof DecorationItem && (data = ((DecorationItem)stack.m_41720_()).getData(UniStack.getStack((Object)stack))) != null) {
                this.decos.add(data);
                this.updateClient();
            }
            UniEntity.getEntity((Object)player).openUI(UIKeys.DECORATION_EDITOR.key, new V3I(this.m_19879_(), 0, 0));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6469_(DamageSource source, float am) {
        if (this.m_9236_().f_46443_ || this.m_213877_()) {
            return false;
        }
        if (source.m_7640_() instanceof Player) {
            if (this.locked) {
                source.m_7640_().m_213846_((Component)Component.m_237113_((String)"Deco is locked."));
                return true;
            }
            for (DecorationData deco : this.decos) {
                ItemEntity entity = new ItemEntity(EntityType.f_20461_, this.m_9236_());
                entity.m_146884_(this.m_20182_().m_82520_(0.0, 0.25, 0.0));
                entity.m_32045_((ItemStack)deco.getNewStack().local());
                this.m_9236_().m_7967_((Entity)entity);
            }
            this.m_6074_();
            return true;
        }
        return false;
    }

    public boolean m_5829_() {
        return true;
    }

    public void updateClient() {
        TagCW com = TagCW.create();
        this.m_7380_((CompoundTag)com.local());
        com.set("entid", this.m_19879_());
        Packets.sendToAll(Packet_TagListener.class, "deco", TagCW.wrap((Object)com));
    }
}

