/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.event;

import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.event.ClientEvents;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.sys.uni.KeyPress;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.world.EntityW;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fvtm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class InputEvents {
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (ClientEvents.minecraft.f_91074_ == null || ClientEvents.minecraft.f_91073_ == null) {
            return;
        }
        switch (event.phase) {
            case START: {
                if (!(ClientEvents.minecraft.f_91074_.m_20202_() instanceof RootVehicle)) break;
                InputEvents.handleKeyboardInput();
            }
        }
    }

    private static void handleKeyboardInput() {
        Passenger pass = (Passenger)UniEntity.getApp((Object)ClientEvents.minecraft.f_91074_, Passenger.class);
        EntityW player = pass.entity;
        SeatInstance seat = pass.getSeatOn();
        if (seat == null) {
            return;
        }
        boolean state = ClientEvents.accelerate.m_90857_();
        if (state != seat.root.getKeyPressState(KeyPress.ACCELERATE)) {
            seat.onKeyPress(KeyPress.ACCELERATE, player, state);
        }
        if ((state = ClientEvents.decelerate.m_90857_()) != seat.root.getKeyPressState(KeyPress.DECELERATE)) {
            seat.onKeyPress(KeyPress.DECELERATE, player, state);
        }
        if (ClientEvents.turn_left.m_90857_()) {
            seat.onKeyPress(KeyPress.TURN_LEFT, player);
        }
        if (ClientEvents.turn_right.m_90857_()) {
            seat.onKeyPress(KeyPress.TURN_RIGHT, player);
        }
        if (ClientEvents.arrow_up.m_90857_()) {
            seat.onKeyPress(seat.root.type.isAirVehicle() ? KeyPress.ACCELERATE : KeyPress.GEAR_UP, player);
        }
        if (ClientEvents.arrow_down.m_90857_()) {
            seat.onKeyPress(seat.root.type.isAirVehicle() ? KeyPress.DECELERATE : KeyPress.GEAR_DOWN, player);
        }
        if (ClientEvents.arrow_left.m_90857_()) {
            seat.onKeyPress(KeyPress.ROLL_LEFT, player);
        }
        if (ClientEvents.arrow_right.m_90857_()) {
            seat.onKeyPress(KeyPress.ROLL_RIGHT, player);
        }
        if (ClientEvents.pbrake.m_90857_()) {
            seat.onKeyPress(KeyPress.PBRAKE, player);
        }
        if ((state = ClientEvents.brake.m_90857_()) != seat.root.getKeyPressState(KeyPress.BRAKE)) {
            seat.onKeyPress(KeyPress.BRAKE, player, state);
        }
        if (ClientEvents.engine_toggle.m_90857_()) {
            seat.onKeyPress(KeyPress.ENGINE, player);
        }
        if (ClientEvents.minecraft.f_91066_.f_92090_.m_90857_()) {
            seat.onKeyPress(KeyPress.DISMOUNT, player);
        }
        if (ClientEvents.inventory_open.m_90857_()) {
            seat.onKeyPress(KeyPress.INVENTORY, player);
        }
        if (ClientEvents.control.m_90857_()) {
            seat.onKeyPress(KeyPress.CONTROL, player);
        }
        if (ClientEvents.script_ui.m_90857_()) {
            seat.onKeyPress(KeyPress.SCRIPTS, player);
        }
        if (ClientEvents.lights_toggle.m_90857_()) {
            seat.onKeyPress(KeyPress.LIGHTS, player);
        }
        if (ClientEvents.trailer_toggle.m_90857_()) {
            seat.onKeyPress(KeyPress.COUPLER_REAR, player);
        }
        if (ClientEvents.wagon_toggle.m_90857_()) {
            seat.onKeyPress(KeyPress.COUPLER_FRONT, player);
        }
        if (ClientEvents.reset.m_90857_()) {
            seat.onKeyPress(KeyPress.RESET, player);
        }
    }

    @SubscribeEvent
    public static void clickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        if (event.getHand() == InteractionHand.MAIN_HAND) {
            InteractionHandler.handle(KeyPress.MOUSE_RIGHT, UniStack.getStack((Object)event.getItemStack()));
        }
    }

    @SubscribeEvent
    public static void clickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
        if (event.getHand() == InteractionHand.MAIN_HAND) {
            InteractionHandler.handle(KeyPress.MOUSE_MAIN, UniStack.getStack((Object)event.getItemStack()));
        }
    }

    @SubscribeEvent
    public static void clickItem(PlayerInteractEvent.RightClickItem event) {
        if (!event.getLevel().f_46443_) {
            return;
        }
        if (event.getHand() == InteractionHand.MAIN_HAND && InteractionHandler.handle(KeyPress.MOUSE_RIGHT, UniStack.getStack((Object)event.getItemStack()))) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.PASS);
        }
    }

    @SubscribeEvent
    public static void clickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getLevel().f_46443_) {
            return;
        }
        if (event.getHand() == InteractionHand.MAIN_HAND && InteractionHandler.handle(KeyPress.MOUSE_RIGHT, UniStack.getStack((Object)event.getItemStack()))) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.PASS);
        }
    }

    @SubscribeEvent
    public static void clickBlock(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getHand() == InteractionHand.MAIN_HAND && InteractionHandler.handle(KeyPress.MOUSE_MAIN, UniStack.getStack((Object)event.getItemStack()))) {
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.PASS);
        }
    }
}

