/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.function.part;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.fexcraft.app.json.FJson;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.utils.Formatter;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.sys.condition.CondMode;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WorldW;

public class EngineFunction
extends PartFunction {
    private float engine_speed;
    private int idle_con;
    private int con;
    private TreeMap<String, Float> cons = new TreeMap();
    private boolean ison;
    private String[] fuelgroup;
    private int min_rpm;
    private int max_rpm;
    private float[][] torque_chart;
    private float highest_torque;

    public EngineFunction() {
    }

    public EngineFunction(float es, boolean io, int ic, int c, TreeMap<String, Float> cs, String[] fg) {
        this.engine_speed = es;
        this.ison = io;
        this.idle_con = ic;
        this.con = c;
        this.cons = cs;
        this.fuelgroup = fg;
    }

    @Override
    public String getId() {
        return "fvtm:engine";
    }

    @Override
    public PartFunction init(Part part, FJson json) {
        String[] stringArray;
        JsonMap map = json.asMap();
        this.engine_speed = map.getFloat("engine_speed", 0.245f);
        this.idle_con = map.getInteger("idle_consumption", 1);
        this.con = map.getInteger("active_consumption", 1);
        if (map.get("fuel_group").isArray()) {
            stringArray = map.getArray("fuel_group").toStringArray();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = map.getString("fuel_group", "diesel");
        }
        this.fuelgroup = stringArray;
        if (map.has("consumptions") && map.get("consumptions").isMap()) {
            map.getMap("consumptions").entries().forEach(entry -> this.cons.put((String)entry.getKey(), Float.valueOf(((JsonValue)entry.getValue()).float_value())));
        }
        this.min_rpm = map.getInteger("min_rpm", 1000);
        this.max_rpm = map.getInteger("max_rpm", 6000);
        JsonMap tor = map.getMap("torque_chart");
        this.torque_chart = new float[tor.size()][2];
        TreeMap<Integer, Float> tree = new TreeMap<Integer, Float>();
        for (Map.Entry entry2 : tor.entries()) {
            tree.put(Integer.parseInt((String)entry2.getKey()), Float.valueOf(((JsonValue)entry2.getValue()).float_value()));
        }
        int index = 0;
        for (Map.Entry entry3 : tree.entrySet()) {
            this.torque_chart[index][0] = ((Integer)entry3.getKey()).intValue();
            this.torque_chart[index++][1] = ((Float)entry3.getValue()).floatValue();
            if (!(((Float)entry3.getValue()).floatValue() > this.highest_torque)) continue;
            this.highest_torque = ((Float)entry3.getValue()).floatValue();
        }
        if (this.torque_chart.length < 2) {
            this.torque_chart = new float[2][2];
            this.torque_chart[0] = new float[]{1000.0f, 300.0f};
            this.torque_chart[1] = new float[]{5000.0f, 500.0f};
        }
        return this;
    }

    @Override
    public PartFunction load(TagCW compound) {
        this.ison = compound.getBoolean("IsOn");
        return this;
    }

    @Override
    public TagCW save(TagCW compound) {
        compound.set("IsOn", this.ison);
        return compound;
    }

    public float getSphEngineSpeed() {
        return this.engine_speed;
    }

    public boolean toggle() {
        this.ison = !this.ison;
        return this.ison;
    }

    @Override
    public PartFunction copy(Part part) {
        EngineFunction func = new EngineFunction(this.engine_speed, this.ison, this.idle_con, this.con, this.cons, this.fuelgroup);
        func.min_rpm = this.min_rpm;
        func.max_rpm = this.max_rpm;
        func.torque_chart = this.torque_chart;
        func.highest_torque = this.highest_torque;
        return func;
    }

    public boolean setState(boolean bool) {
        this.ison = bool;
        return this.ison;
    }

    public boolean isOn() {
        return this.ison;
    }

    public String[] getFuelGroup() {
        return this.fuelgroup;
    }

    @Override
    public void addInformation(StackWrapper stack, WorldW world, PartData data, List<String> tooltip, boolean ext) {
        for (String str : this.fuelgroup) {
            tooltip.add(Formatter.format((String)("&9Engine Fuel: &7" + str)));
        }
        FvtmLogger.marker((Object)stack.getID());
        tooltip.add(Formatter.format((String)("&9Range: &7" + this.min_rpm + "-" + this.max_rpm + " rpm")));
        tooltip.add(Formatter.format((String)("&9Torque: &7" + this.torque_chart[0][1] + "-" + this.highest_torque)));
    }

    public float getFuelConsumption(String fuel_branch) {
        return this.cons.containsKey(fuel_branch) ? this.cons.get(fuel_branch).floatValue() : (float)this.con;
    }

    public int getIdleFuelConsumption() {
        return this.idle_con;
    }

    public int minRPM() {
        return this.min_rpm;
    }

    public int maxRPM() {
        return this.max_rpm;
    }

    public float[][] getTorqueChart() {
        return this.torque_chart;
    }

    public float getTorque(int rpm) {
        if (rpm <= this.min_rpm) {
            return this.torque_chart[0][1];
        }
        if (rpm >= this.max_rpm) {
            return this.torque_chart[this.torque_chart.length - 1][1];
        }
        float[] curr = this.torque_chart[0];
        for (int i = 1; i < this.torque_chart.length; ++i) {
            float[] last = curr;
            curr = this.torque_chart[i];
            if ((float)rpm >= last[0] && (float)rpm < curr[0]) {
                float diff = curr[0] - last[0];
                float rrpm = (float)rpm - last[0];
                diff = rrpm / diff;
                return last[1] + diff * (curr[1] - last[1]);
            }
            if (i != this.torque_chart.length - 1) continue;
            return curr[1];
        }
        return 0.0f;
    }

    @Override
    public boolean onCondition(String[] targets, CondMode mode, String condi) {
        if (mode.equals("on")) {
            return this.ison;
        }
        if (mode.equals("off")) {
            return !this.ison;
        }
        this.ison = Boolean.parseBoolean(condi);
        return this.ison;
    }
}

