/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartInstallHandler;
import net.fexcraft.mod.fvtm.data.part.PartSlot;
import net.fexcraft.mod.fvtm.data.part.PartSlots;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.function.part.PartSlotsFunction;
import net.fexcraft.mod.fvtm.function.part.WheelPositionsFunction;
import net.fexcraft.mod.fvtm.util.Rot;
import net.fexcraft.mod.uni.world.MessageSender;

public class DefaultPartInstallHandler
extends PartInstallHandler {
    @Override
    public boolean validInstall(MessageSender sender, PartData part, String cat, VehicleData data, boolean swap) {
        String catin = this.getslotcat(cat);
        if (data.getParts().containsKey(catin) && !swap) {
            sender.send("handler.install.fvtm.default.category_occupied");
            return false;
        }
        DPIHData idata = (DPIHData)((Part)part.getType()).getInstallHandlerData();
        if (!this.compatible(idata, (Vehicle)data.getType())) {
            sender.send("handler.install.fvtm.default.part_incompatible_vehicle");
            return false;
        }
        if (this.incompatible(idata, data)) {
            sender.send("handler.install.fvtm.default.vehicle_contains_incompatible");
            return false;
        }
        if (!this.required(idata, data)) {
            sender.send("handler.install.fvtm.default.vehicle_missing_required_parts");
            return false;
        }
        if (!this.swivelpresent(data, cat)) {
            sender.send("handler.install.fvtm.default.vehicle_swivelpoint_missing");
        }
        sender.send("handler.install.fvtm.default.check_passed");
        return true;
    }

    private boolean swivelpresent(VehicleData data, String cat) {
        String[] slotin = cat.split(":");
        PartSlots slots = data.getPartSlotsProvider(slotin[0]);
        return data.getRotationPoints().containsKey(((PartSlot)slots.get((Object)slotin[1])).swivel);
    }

    private String getslotcat(String cat) {
        String[] slotin = cat.split(":");
        return slotin[1].contains("*") ? slotin[1].replace("*", slotin[0]) : slotin[1];
    }

    private boolean compatible(DPIHData id, Vehicle veh) {
        if (id.compatible.isEmpty() || id.compatible.contains(veh.getIDS())) {
            return true;
        }
        for (String cat : veh.getCategories()) {
            if (!id.compatible.contains(cat)) continue;
            return true;
        }
        return false;
    }

    private boolean incompatible(DPIHData idata, VehicleData data) {
        if (!idata.incompatible.containsKey(((Vehicle)data.getType()).getIDS())) {
            return false;
        }
        ArrayList<String> list = idata.incompatible.get(((Vehicle)data.getType()).getIDS());
        for (String str : list) {
            if (str.contains(":") && data.hasPartWithId(str)) {
                return true;
            }
            if (!data.getParts().containsKey(str)) continue;
            return true;
        }
        return false;
    }

    private boolean required(DPIHData idata, VehicleData data) {
        if (!idata.required.containsKey(((Vehicle)data.getType()).getIDS())) {
            return true;
        }
        ArrayList<String> list = idata.required.get(((Vehicle)data.getType()).getIDS());
        for (String str : list) {
            if (data.getParts().containsKey(str)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean processInstall(MessageSender sender, PartData part, String cat, VehicleData data) {
        data.getParts().put(this.getslotcat(cat), part);
        DPIHData idata = (DPIHData)((Part)part.getType()).getInstallHandlerData();
        DefaultPartInstallHandler.setPosRotAndSwivelPoint(idata, cat, part, data);
        sender.send("handler.install.fvtm.default.success");
        return true;
    }

    public static void setPosRotAndSwivelPoint(DPIHData idata, String cat, PartData part, VehicleData data) {
        String[] slotin = cat.split(":");
        PartSlots slots = data.getPartSlotsProvider(slotin[0]);
        V3D result = ((PartSlot)slots.get((Object)slotin[1])).pos.copy();
        Rot rosult = ((PartSlot)slots.get((Object)slotin[1])).rotation;
        if (!slotin[0].equals("vehicle")) {
            PartData mount = data.getPart(slotin[0]);
            result = result.add(mount.getInstalledPos());
            if (mount.getSwivelPointInstalledOn() != null && !mount.getSwivelPointInstalledOn().equals("vehicle")) {
                part.setInstalledOnSwivelPoint(mount.getSwivelPointInstalledOn());
            }
            if (slots.copy_rot) {
                rosult = rosult.add(mount.getInstalledRot());
            }
        }
        if (!((PartSlot)slots.get((Object)slotin[1])).swivel.equals("vehicle") && data.getRotationPoints().containsKey(((PartSlot)slots.get((Object)slotin[1])).swivel)) {
            part.setInstalledOnSwivelPoint(((PartSlot)slots.get((Object)slotin[1])).swivel);
        }
        part.setInstalled(slotin[0], result, rosult);
    }

    @Override
    public boolean validUninstall(MessageSender sender, PartData part, String in_cat, VehicleData from, boolean swap) {
        DPIHData idata = (DPIHData)((Part)part.getType()).getInstallHandlerData();
        if (!idata.removable && !swap) {
            sender.send("handler.deinstall.fvtm.default.part_not_removable");
            return false;
        }
        if (!DefaultPartInstallHandler.checkWheelSlotsInUse(sender, in_cat, part, from)) {
            return false;
        }
        if (!DefaultPartInstallHandler.checkPartSlotsInUse(sender, in_cat, part, from)) {
            return false;
        }
        sender.send("handler.deinstall.fvtm.default.check_passed");
        return true;
    }

    public static boolean checkWheelSlotsInUse(MessageSender sender, String cat, PartData part, VehicleData from) {
        if (part.hasFunction("fvtm:wheel_positions")) {
            WheelPositionsFunction func = (WheelPositionsFunction)part.getFunction("fvtm:wheel_positions");
            ArrayList<String> pid = func.getPosIds(cat);
            for (String key : from.getParts().keySet()) {
                if (!pid.contains(key)) continue;
                sender.send("handler.deinstall.fvtm.default.remove_linked_wheels");
                return false;
            }
        }
        return true;
    }

    public static boolean checkPartSlotsInUse(MessageSender sender, String cat, PartData part, VehicleData from) {
        if (!part.hasFunction("fvtm:part_slots")) {
            return true;
        }
        PartSlotsFunction func = part.getFunction(PartSlotsFunction.class, "fvtm:part_slots");
        for (Map.Entry slot : func.getPartSlotss().entrySet()) {
            if (!from.hasPart((String)slot.getKey()) || !from.getPart((String)slot.getKey()).getSource().equals(cat)) continue;
            sender.send("handler.deinstall.fvtm.default.remove_sub_parts");
            return false;
        }
        return true;
    }

    @Override
    public boolean processUninstall(MessageSender sender, PartData part, String cat, VehicleData data) {
        part.setInstalled(null, V3D.NULL, Rot.NULL);
        part.setInstalledOnSwivelPoint(null);
        data.getParts().remove(cat);
        sender.send("handler.deinstall.fvtm.default.success");
        return true;
    }

    public ArrayList<String> getValidCategories(PartData part, VehicleData vehicle) {
        DPIHData idata = (DPIHData)((Part)part.getType()).getInstallHandlerData();
        ArrayList<String> found = new ArrayList<String>();
        for (Map.Entry<String, PartSlots> data : vehicle.getPartSlotProviders().entrySet()) {
            for (Map.Entry slot : data.getValue().entrySet()) {
                String type = ((PartSlot)slot.getValue()).type;
                for (String str : ((Part)part.getType()).getCategories()) {
                    if (!str.equals(type)) continue;
                    found.add(data.getKey() + ":" + (String)slot.getKey());
                }
            }
        }
        return found;
    }

    @Override
    public Object parseData(JsonMap map) {
        return new DPIHData(map);
    }

    public static class DPIHData {
        public ArrayList<String> compatible;
        public boolean removable = true;
        public boolean swappable;
        public boolean construct;
        public HashMap<String, ArrayList<String>> incompatible = new LinkedHashMap<String, ArrayList<String>>();
        public HashMap<String, ArrayList<String>> required = new LinkedHashMap<String, ArrayList<String>>();

        public DPIHData(JsonMap map) {
            this.removable = map.getBoolean("Removable", true);
            this.swappable = map.getBoolean("Swappable", false);
            this.construct = map.getBoolean("ConstOnly", false);
            ArrayList arrayList = this.compatible = map.has("Compatible") ? map.getArray("Compatible").toStringList() : new ArrayList();
            if (map.has("Incompatible")) {
                for (Map.Entry entry : map.get("Incompatible").asMap().entries()) {
                    this.incompatible.put((String)entry.getKey(), ((JsonValue)entry.getValue()).asArray().toStringList());
                }
            }
            if (map.has("Required")) {
                for (Map.Entry entry : map.get("Required").asMap().entries()) {
                    this.required.put((String)entry.getKey(), ((JsonValue)entry.getValue()).asArray().toStringList());
                }
            }
        }
    }
}

