/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.Fuel;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.uni.inv.UniStack;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class MaterialItem
extends Item
implements ContentItem<Material> {
    private Material material;
    private UniStack unistack = null;

    public MaterialItem(Material material) {
        super(new Item.Properties().m_41487_(material.isFuelContainer() ? 1 : material.getMaxStack()).m_41503_(material.getMaxHealth()).m_41499_(material.getMaxHealth()));
        this.material = material;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(GenericUtils.format("&9Name: &7" + this.material.getName()));
        for (String s : this.material.getDescription()) {
            tooltip.add(GenericUtils.format(I18n.m_118938_((String)s, (Object[])new Object[0])));
        }
        if (this.material.getOreDictId() != null) {
            tooltip.add(GenericUtils.format("&9OreDict: &7" + this.material.getOreDictId()));
        }
        if (this.material.isVehicleKey()) {
            tooltip.add(GenericUtils.format("&9LockCode: &7" + this.getLockCode(stack)));
        }
        this.unistack = UniStack.get((Object)stack);
        if (this.unistack != null && this.material.isFuelContainer()) {
            tooltip.add(GenericUtils.format("&9Container: &7" + (this.material.isUniversalFuelContainer() ? "universal" : (this.material.getFuelType() == null ? this.material.getFuelGroup() : this.material.getFuelType().getName()))));
            tooltip.add(GenericUtils.format("&9Fuel Stored: &7" + Fuel.getStoredName(this.unistack.stack)));
            tooltip.add(GenericUtils.format("&9Fuel Amount: &7" + Fuel.getStoredAmount(this.unistack.stack) + "mB"));
        }
    }

    public String getLockCode(ItemStack stack) {
        if (!this.material.isVehicleKey()) {
            return null;
        }
        if (stack.m_41783_() == null) {
            stack.m_41751_(new CompoundTag());
        }
        if (!stack.m_41783_().m_128441_("LockCode")) {
            stack.m_41783_().m_128359_("LockCode", UUID.randomUUID().toString().replace("-", "").substring(0, 7));
        }
        return stack.m_41783_().m_128461_("LockCode");
    }

    @Override
    public Material getContent() {
        return this.material;
    }

    @Override
    public ContentType getType() {
        return ContentType.MATERIAL;
    }
}

