/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class RailGaugeItem
extends Item
implements ContentItem<RailGauge>,
JunctionGridItem {
    private RailGauge gauge;

    public RailGaugeItem(RailGauge railgauge) {
        super(new Item.Properties());
        this.gauge = railgauge;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        for (String desc : this.gauge.getDescription()) {
            tooltip.add((Component)Component.m_237115_((String)desc));
        }
        tooltip.add((Component)Component.m_237110_((String)"item.fvtm.railgauge.width", (Object[])new Object[]{Float.valueOf(this.gauge.getWidth())}));
        if (this.gauge.getCompatible().size() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"item.fvtm.railgauge.compatible"));
            for (String str : this.gauge.getCompatible()) {
                tooltip.add(GenericUtils.format("- " + str));
            }
        }
        if (this.gauge.getMaterials().size() > 0) {
            tooltip.add((Component)Component.m_237115_((String)"item.fvtm.railgauge.materials"));
            for (RailGauge.UseMat mat : this.gauge.getMaterials()) {
                tooltip.add(GenericUtils.format("- " + (mat.tag ? "#" : "") + mat.id + " x" + mat.amount));
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_ || Config.DISABLE_RAILS) {
            return InteractionResult.PASS;
        }
        WorldW world = WrapperHolder.getWorld((Object)context.m_43725_());
        RailSystem railsys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, world);
        if (railsys == null) {
            context.m_43723_().m_213846_(GenericUtils.format("RailSystem not found on this Level."));
            return InteractionResult.FAIL;
        }
        QV3D vector = new QV3D(context.m_43720_().f_82479_, context.m_43720_().f_82480_, context.m_43720_().f_82481_);
        RailPlacingUtil.place(railsys, UniEntity.getEntity((Object)context.m_43723_()), this.gauge, vector);
        return InteractionResult.SUCCESS;
    }

    @Override
    public RailGauge getContent() {
        return this.gauge;
    }

    @Override
    public ContentType getType() {
        return ContentType.RAILGAUGE;
    }
}

