/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.program;

import java.util.HashMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.function.part.GetWheelPos;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.model.ProgramUtils;
import net.fexcraft.mod.fvtm.model.RenderOrder;
import net.fexcraft.mod.fvtm.model.program.DefaultPrograms;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.Renderer20;
import net.fexcraft.mod.fvtm.sys.uni.WheelTireData;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.math.NumberUtils;

public class DefaultPrograms20
extends DefaultPrograms {
    private static HashMap<String, Font> FONTS = new HashMap();

    public static void init() {
        DefaultPrograms.init();
        GLOW = new Program(){
            private RenderType old;

            @Override
            public String id() {
                return "fvtm:glow_internal";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                this.old = Renderer20.rentype();
                FvtmRenderTypes.setGlow(data.texture.getCurrentTexture());
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                FvtmRenderTypes.setDef(this.old);
            }

            @Override
            public RenderOrder order() {
                return RenderOrder.BLENDED;
            }
        };
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:rgb_primary";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                if (data.color != null) {
                    Renderer20.setColor(data.color.getPrimaryColor());
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                Renderer20.resetColor();
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:rgb_secondary";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                if (data.color != null) {
                    Renderer20.setColor(data.color.getSecondaryColor());
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                Renderer20.resetColor();
            }
        });
        ModelGroup.PROGRAMS.add(new RGBCustom(new float[]{1.0f, 1.0f, 1.0f}));
        ModelGroup.PROGRAMS.add(new RGBChannel("custom"));
        ModelGroup.PROGRAMS.add(new Program(){

            @Override
            public String id() {
                return "fvtm:hide";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                list.visible = false;
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                list.visible = true;
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){
            private WheelSlot slot;
            private WheelTireData wtd;

            @Override
            public String id() {
                return "fvtm:wheel_auto_all";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                Renderer20.pushPose();
                this.slot = data.part.getFunction(GetWheelPos.class, "fvtm:wheel", "fvtm:tire").getWheelPos(data.vehicle);
                if (this.slot != null && this.slot.steering) {
                    Renderer20.rotateDeg(-data.vehicle.getAttribute("steering_angle").asFloat(), Renderer20.AY);
                }
                if (data.vehent != null) {
                    this.wtd = data.vehent.wheeldata.get(data.part_category);
                    if (this.wtd != null) {
                        Renderer20.rotateDeg(-this.wtd.rotation, Renderer20.AX);
                    }
                }
                if (this.slot != null && this.slot.mirror) {
                    Renderer20.rotateRad(3.14159f, Renderer20.AY);
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                Renderer20.popPose();
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){
            private WheelSlot slot;

            @Override
            public String id() {
                return "fvtm:wheel_auto_steering";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                Renderer20.pushPose();
                this.slot = data.part.getFunction(GetWheelPos.class, "fvtm:wheel", "fvtm:tire").getWheelPos(data.vehicle);
                if (this.slot != null && this.slot.mirror) {
                    Renderer20.rotateRad(3.14159f, Renderer20.AY);
                }
                if (this.slot != null && this.slot.steering) {
                    Renderer20.rotateDeg(data.vehicle.getAttribute("steering_angle").asFloat(), Renderer20.AY);
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                Renderer20.popPose();
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){
            private WheelSlot slot;
            private WheelTireData wtd;

            @Override
            public String id() {
                return "fvtm:wheel_auto_all_opposite";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                Renderer20.pushPose();
                this.slot = data.part.getFunction(GetWheelPos.class, "fvtm:wheel", "fvtm:tire").getWheelPos(data.vehicle);
                if (this.slot != null && this.slot.steering) {
                    Renderer20.rotateDeg(-data.vehicle.getAttribute("steering_angle").asFloat(), Renderer20.AY);
                }
                if (data.vehent != null) {
                    this.wtd = data.vehent.wheeldata.get(data.part_category);
                    if (this.wtd != null) {
                        Renderer20.rotateDeg(-this.wtd.rotation, Renderer20.AX);
                    }
                }
                if (this.slot != null && this.slot.mirror) {
                    Renderer20.rotateRad(3.14159f, Renderer20.AY);
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                Renderer20.popPose();
            }
        });
        ModelGroup.PROGRAMS.add(new Program(){
            private WheelSlot slot;

            @Override
            public String id() {
                return "fvtm:wheel_auto_steering_opposite";
            }

            @Override
            public void pre(ModelGroup list, ModelRenderData data) {
                Renderer20.pushPose();
                this.slot = data.part.getFunction(GetWheelPos.class, "fvtm:wheel", "fvtm:tire").getWheelPos(data.vehicle);
                if (this.slot != null && this.slot.mirror) {
                    Renderer20.rotateRad(3.14159f, Renderer20.AY);
                }
                if (this.slot != null && this.slot.steering) {
                    Renderer20.rotateDeg(-data.vehicle.getAttribute("steering_angle").asFloat(), Renderer20.AY);
                }
            }

            @Override
            public void post(ModelGroup list, ModelRenderData data) {
                Renderer20.popPose();
            }
        });
        ModelGroup.PROGRAMS.add(new SteeringWheel(0, 0.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheel(2, 1.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheel(0, 1.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheel(1, 1.0f));
        ModelGroup.PROGRAMS.add(new SteeringWheel(2, 1.0f, false));
        ModelGroup.PROGRAMS.add(new SteeringWheel(0, 1.0f, false));
        ModelGroup.PROGRAMS.add(new SteeringWheel(1, 1.0f, false));
        ModelGroup.PROGRAMS.add(new AttributeRotator("", false, 0.0f, 0.0f, 0.0f, 0, Float.valueOf(0.0f)));
        ModelGroup.PROGRAMS.add(new AttributeTranslator("", false, 0.0f, 0.0f, 0.0f, 0));
        ModelGroup.PROGRAMS.add(new AttributeVisible("", false));
        ModelGroup.PROGRAMS.add(new TextureBinder("minecraft:textures/blocks/stone.png"));
        ModelGroup.PROGRAMS.add(new SignText());
        DefaultPrograms.LightBeam.LBR = new DefaultPrograms.LightBeam.LBRender(){

            @Override
            public void pre(DefaultPrograms.LightBeam beam, ModelGroup list, ModelRenderData data) {
                FvtmRenderTypes.setLB(data.texture.getCurrentTexture());
                Renderer20.pose.m_85836_();
                if (beam.swivel == null || beam.swivel.equals("vehicle")) {
                    Renderer20.RENDERER.translate(beam.pos);
                } else {
                    SwivelPoint point = data.vehicle.getRotationPoint(beam.swivel);
                    V3D pos = point.getRelativeVector(beam.pos);
                    Renderer20.pose.m_85837_(pos.x, pos.y, pos.z);
                }
                Renderer20.setColor(RGB.WHITE, 0.5f);
            }

            @Override
            public void post(DefaultPrograms.LightBeam beam, ModelGroup list, ModelRenderData data) {
                Renderer20.pose.m_85849_();
            }
        };
        ModelGroup.PROGRAMS.add(new TextRenderer());
    }

    private static Font getFont(String key) {
        if (key == null) {
            return Minecraft.m_91087_().f_91062_;
        }
        if (!FONTS.containsKey(key)) {
            FONTS.put(key, new Font(res -> Minecraft.m_91087_().f_91045_.f_94999_.getOrDefault(ResourceLocation.m_135820_((String)key), Minecraft.m_91087_().f_91045_.f_94998_), true));
        }
        return FONTS.get(key);
    }

    public static class RGBCustom
    implements Program {
        private Vec3f color = new Vec3f();

        public RGBCustom(float[] col) {
            this.color.x = col[0];
            this.color.y = col[1];
            this.color.z = col[2];
        }

        @Override
        public String id() {
            return "fvtm:rgb_custom";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            Renderer20.setColor(this.color);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            Renderer20.resetColor();
        }

        @Override
        public Program parse(String[] args) {
            return new RGBCustom(new RGB(args[0]).toFloatArray());
        }
    }

    public static class RGBChannel
    implements Program {
        private String channel;

        public RGBChannel(String colorchannel) {
            this.channel = colorchannel;
        }

        @Override
        public String id() {
            return "fvtm:rgb_channel";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            Renderer20.setColor(data.color.getColorChannel(this.channel));
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            Renderer20.resetColor();
        }

        @Override
        public Program parse(String[] args) {
            return new RGBChannel(args[0]);
        }
    }

    public static class SteeringWheel
    implements Program {
        private byte axis;
        private float ratio;
        private float rotated;
        private boolean apply;
        private String id;

        public SteeringWheel(int axis, float ratio) {
            this(axis, ratio, true);
        }

        public SteeringWheel(int axis, float ratio, boolean override) {
            this.axis = (byte)axis;
            this.ratio = ratio;
            this.id = axis == 0 && ratio == 0.0f ? "fvtm:steering_base" : "fvtm:steering_" + (axis == 0 ? "x" : (axis == 1 ? "y" : "z")) + (override ? "" : "_no_apply");
            this.apply = override;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            this.rotated = -data.vehicle.getAttribute("steering_angle").asFloat() * this.ratio;
            list.rotate(this.rotated, this.axis, this.apply);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.rotate(this.rotated, this.axis, this.apply);
        }

        @Override
        public Program parse(String[] args) {
            return new SteeringWheel(Integer.parseInt(args[0]), Float.parseFloat(args[1]));
        }
    }

    public static class AttributeRotator
    extends DefaultPrograms.AttributeBased {
        private float min;
        private float max;
        private float step = 1.0f;
        private Float current;
        private int axis;
        private boolean boolstatebased;
        private boolean override;
        private float defrot;

        public AttributeRotator(String attribute, boolean boolstatebased, float mn, float mx, float step, int axis, Float defrot) {
            super(attribute);
            this.boolstatebased = boolstatebased;
            this.override = true;
            this.min = mn;
            this.max = mx;
            this.step = step;
            this.axis = axis;
            float f = this.defrot = defrot == null ? 0.0f : defrot.floatValue();
            if (this.min == this.max || this.min == 0.0f && this.max == 0.0f) {
                this.min = -180.0f;
                this.max = 180.0f;
            }
        }

        public AttributeRotator(String attribute, boolean boolstatebased, float min, float max, float step, int axis, Float defrot, boolean notadditive) {
            this(attribute, boolstatebased, min, max, step, axis, defrot);
            this.override = notadditive;
        }

        @Override
        public String id() {
            return "fvtm:attribute_rotator";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            this.attr = data.vehicle.getAttribute(this.attribute);
            if (this.attr == null) {
                return;
            }
            this.current = data.cache.get(this, ProgramUtils.FLOAT_SUPP);
            if (this.current == null) {
                this.current = Float.valueOf(0.0f);
            }
            this.current = Float.valueOf(this.boolstatebased ? (this.attr.asBoolean() ? this.current.floatValue() + this.step : this.current.floatValue() - this.step) : this.attr.asFloat() * this.step);
            if (this.current.floatValue() > this.max) {
                this.current = Float.valueOf(this.max);
            }
            if (this.current.floatValue() < this.min) {
                this.current = Float.valueOf(this.min);
            }
            list.rotate(this.current.floatValue() + this.defrot, this.axis, this.override);
            data.cache.set(this, this.current);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.cache == null || this.attr == null) {
                return;
            }
            list.rotate(this.override ? this.defrot : -(this.current.floatValue() + this.defrot), this.axis, this.override);
            this.current = Float.valueOf(0.0f);
        }

        @Override
        public Program parse(String[] args) {
            String attr = args[0];
            boolean boolstate = Boolean.parseBoolean(args[1]);
            float min = Float.parseFloat(args[2]);
            float max = Float.parseFloat(args[3]);
            float step = Float.parseFloat(args[4]);
            int axis = Integer.parseInt(args[5]);
            Float defrot = args.length > 6 && NumberUtils.isCreatable((String)args[6]) ? Float.valueOf(Float.parseFloat(args[6])) : null;
            return new AttributeRotator(attr, boolstate, min, max, step, axis, defrot, args.length >= 7 && Boolean.parseBoolean(args[7]));
        }
    }

    public static class AttributeTranslator
    extends DefaultPrograms.AttributeBased {
        private boolean bool;
        private float min;
        private float max;
        private float step;
        private Float current;
        private int axis;

        public AttributeTranslator(String attribute, boolean boolstatebased, float min, float max, float step, int axis) {
            super(attribute);
            this.bool = boolstatebased;
            this.axis = axis;
            this.step = step;
            this.min = min;
            this.max = max;
        }

        @Override
        public String id() {
            return "fvtm:attribute_translator";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.cache == null) {
                return;
            }
            this.attr = data.vehicle.getAttribute(this.attribute);
            if (this.attr == null) {
                return;
            }
            this.current = data.cache.get(this, ProgramUtils.FLOAT_SUPP);
            if (this.current == null) {
                this.current = Float.valueOf(0.0f);
            }
            this.current = Float.valueOf(this.bool ? (this.attr.asBoolean() ? this.current.floatValue() + this.step : this.current.floatValue() - this.step) : this.attr.asFloat());
            if (this.current.floatValue() > this.max) {
                this.current = Float.valueOf(this.max);
            }
            if (this.current.floatValue() < this.min) {
                this.current = Float.valueOf(this.min);
            }
            Renderer20.pose.m_252880_(this.axis == 0 ? this.current.floatValue() * 0.0625f : 0.0f, this.axis == 1 ? this.current.floatValue() * 0.0625f : 0.0f, this.axis == 2 ? this.current.floatValue() * 0.0625f : 0.0f);
            data.cache.set(this, this.current);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (data.cache == null || this.attr == null) {
                return;
            }
            Renderer20.pose.m_252880_(this.axis == 0 ? this.current.floatValue() * -0.0625f : 0.0f, this.axis == 1 ? this.current.floatValue() * -0.0625f : 0.0f, this.axis == 2 ? this.current.floatValue() * -0.0625f : 0.0f);
        }

        @Override
        public Program parse(String[] args) {
            String attr = args[0];
            boolean boolstate = Boolean.parseBoolean(args[1]);
            float min = Float.parseFloat(args[2]);
            float max = Float.parseFloat(args[3]);
            float step = Float.parseFloat(args[4]);
            int axis = Integer.parseInt(args[5]);
            return new AttributeTranslator(attr, boolstate, min, max, step, axis);
        }
    }

    public static class AttributeVisible
    implements Program {
        private Attribute<?> attr;
        private String attribute;
        private boolean equals;

        public AttributeVisible(String attribute, boolean equals) {
            this.attribute = attribute;
            this.equals = equals;
        }

        @Override
        public String id() {
            return "fvtm:attribute_visible";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.vehicle.getAttributeBoolean(this.attribute, !this.equals) != this.equals) {
                list.visible = false;
            }
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            list.visible = true;
        }

        @Override
        public Program parse(String[] args) {
            return new AttributeVisible(args[0], args.length > 1 ? Boolean.parseBoolean(args[1]) : false);
        }
    }

    public static class TextureBinder
    implements Program {
        private IDL idl;
        private RenderType rentype;

        public TextureBinder(String rs) {
            this.idl = IDLManager.getIDLCached((String)rs);
        }

        public TextureBinder(IDL rs) {
            this.idl = rs;
        }

        @Override
        public String id() {
            return "fvtm:bind_texture";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            this.rentype = Renderer20.rentype();
            FvtmRenderTypes.setCutout(this.idl);
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            FvtmRenderTypes.setDef(this.rentype);
        }

        @Override
        public Program parse(String[] args) {
            return new TextureBinder(args[0]);
        }
    }

    public static class SignText
    implements Program {
        private static HashMap<String, SignText> TEXTS = new HashMap();
        private Font font;
        private String key;

        public SignText() {
        }

        public SignText(String font) {
            this.key = font;
        }

        @Override
        public String id() {
            return "fvtm:sign_text";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            if (data.sign == null || data.sign.text == null || data.sign.text.length() == 0) {
                return;
            }
            Renderer20.RENDERER.push();
            Renderer20.RENDERER.scale((double)-0.025f, (double)-0.025f, (double)0.025f);
            Renderer20.RENDERER.rotate(90.0f, 0, 1, 0);
            if (this.font == null) {
                this.font = DefaultPrograms20.getFont(this.key);
                if (this.font == null) {
                    return;
                }
            }
            this.font.m_271703_(data.sign.text, data.sign.centered ? (float)(-this.font.m_92895_(data.sign.text) / 2) : 0.0f, 0.0f, data.sign.getColorChannel((String)"text").packed - 0x1000000, false, Renderer20.pose.m_85850_().m_252922_(), Renderer20.buffer(), Font.DisplayMode.NORMAL, Renderer20.overlay, Renderer20.light);
            Renderer20.resetColor();
            Renderer20.RENDERER.pop();
        }

        @Override
        public boolean post() {
            return false;
        }

        @Override
        public Program parse(String[] args) {
            if (args.length > 0) {
                String key = args[0];
                if (!TEXTS.containsKey(key)) {
                    TEXTS.put(key, new SignText(key));
                }
                return TEXTS.get(key);
            }
            return this;
        }
    }

    public static class TextRenderer
    extends DefaultPrograms.TextRendererBase {
        protected Font font;

        @Override
        public DefaultPrograms.TextRendererBase create() {
            return new TextRenderer();
        }

        @Override
        public void post(ModelGroup list, ModelRenderData data) {
            if (this.attrid != null) {
                attr = data.vehicle.getAttribute(this.attrid);
                if (attr == null) {
                    return;
                }
                this.text = attr.asString();
            }
            if (this.text.isEmpty()) {
                return;
            }
            if (this.font == null) {
                this.font = DefaultPrograms20.getFont(this.fontkey);
                if (this.font == null) {
                    return;
                }
            }
            Renderer20.RENDERER.push();
            Renderer20.RENDERER.translate(this.pos);
            Renderer20.RENDERER.scale((double)(-downscale), (double)(-downscale), (double)(-downscale));
            if (this.scale != 1.0f) {
                Renderer20.RENDERER.scale((double)this.scale, (double)this.scale, (double)this.scale);
            }
            Renderer20.RENDERER.rotate(-90.0f, 0, 1, 0);
            if (this.rot.y != 0.0) {
                Renderer20.RENDERER.rotate(this.rot.y, 0, 1, 0);
            }
            if (this.rot.z != 0.0) {
                Renderer20.RENDERER.rotate(this.rot.z, 0, 0, 1);
            }
            if (this.rot.x != 0.0) {
                Renderer20.RENDERER.rotate(this.rot.x, 1, 0, 0);
            }
            this.font.m_271703_(this.width > 0 ? this.font.m_92834_(this.text, this.width) : this.text, this.centered ? (float)(-this.font.m_92895_(this.text)) * 0.5f : 0.0f, 0.0f, this.color - 0x1000000, false, Renderer20.pose.m_85850_().m_252922_(), Renderer20.buffer(), this.glow ? Font.DisplayMode.SEE_THROUGH : Font.DisplayMode.NORMAL, Renderer20.overlay, Renderer20.light);
            Renderer20.RENDERER.pop();
        }
    }
}

