/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ToolboxType;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.item.WireDecoItem;
import net.fexcraft.mod.fvtm.item.WireItem;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.Renderer20;
import net.fexcraft.mod.fvtm.render.UniWireRenderer;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.sys.wire.RelayHolder;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="fvtm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class WireRenderer {
    private static WireSystem wiredata;
    private static ItemStack held;
    private static boolean holding_wire;
    private static boolean holding_slack;
    private static boolean holding_relaydeco;
    private static boolean holding_deco;

    @SubscribeEvent
    public static void renderWires(RenderLevelStageEvent event) {
        if (Config.DISABLE_WIRES) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        wiredata = SystemManager.get(SystemManager.Systems.WIRE, WrapperHolder.getWorld((Object)event.getCamera().m_90592_().m_9236_()), WireSystem.class);
        if (wiredata == null || wiredata.getRegions() == null) {
            return;
        }
        held = Minecraft.m_91087_().f_91074_.m_21205_();
        holding_wire = DebugUtils.ACTIVE || held.m_41720_() instanceof WireItem || held.m_41720_() instanceof ToolboxItem && ToolboxType.WIRE_REMOVAL.eq(ToolboxItem.getToolboxType(held));
        boolean bl = holding_slack = DebugUtils.ACTIVE || held.m_41720_() instanceof ToolboxItem && ToolboxType.WIRE_SLACK.eq(ToolboxItem.getToolboxType(held));
        if (held.m_41720_() instanceof WireDecoItem) {
            WireDecoItem item = (WireDecoItem)held.m_41720_();
            holding_relaydeco = item.getContent().getType().equals("relay");
            holding_deco = !holding_relaydeco;
        } else {
            holding_deco = false;
            holding_relaydeco = false;
        }
        Camera camera = event.getCamera();
        double cx = camera.m_90583_().f_82479_;
        double cy = camera.m_90583_().f_82480_;
        double cz = camera.m_90583_().f_82481_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        PoseStack pose = event.getPoseStack();
        FvtmRenderTypes.setCutout(FvtmResources.WHITE_TEXTURE);
        Renderer20.set(pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0);
        pose.m_85836_();
        pose.m_85837_(-cx, -cy, -cz);
        for (SystemRegion reg : wiredata.getRegions().values()) {
            for (RelayHolder holder : reg.getObjects().values()) {
                for (WireRelay relay : holder.relays.values()) {
                    Renderer20.light = LevelRenderer.m_109541_((BlockAndTintGetter)camera.m_90592_().m_9236_(), (BlockPos)pos.m_122169_(relay.pos.x, relay.pos.y + 0.1, relay.pos.z));
                    if (DebugUtils.ACTIVE || holding_wire) {
                        DebugUtils.renderBB(relay.pos, holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f, DebugUtils.COL_CYN);
                    }
                    if ((DebugUtils.ACTIVE || holding_slack) && relay.wires.size() > 0) {
                        for (Wire wire : relay.wires) {
                            if (wire.copy) continue;
                            DebugUtils.renderBB(wire.getVectorPosition((double)wire.length * 0.5, false), holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f, DebugUtils.COL_ORG);
                        }
                    }
                    if (relay.wires.size() > 0) {
                        if (holding_slack || holding_deco) {
                            for (Wire wire : relay.wires) {
                                if (wire.copy) continue;
                                DebugUtils.renderBB(wire.getVectorPosition((double)wire.length * 0.5, false), holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f, DebugUtils.COL_ORG);
                            }
                        }
                        if (holding_relaydeco) {
                            for (Wire wire : relay.wires) {
                                DebugUtils.renderBB(wire.getVectorPosition(holder.hasRef() ? (double)(holder.ref().getSize(relay.getKey()) * 2.0f) : 0.25, false), holder.hasRef() ? holder.ref().getSize(relay.getKey()) * 2.0f : 0.25f, DebugUtils.COL_CYN);
                            }
                        }
                    }
                    UniWireRenderer.renderRelay(relay, 0.0, 0.0, 0.0);
                }
            }
        }
        pose.m_85849_();
    }
}

