/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.util.Collections;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.sys.rail.Compound;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.util.MiniBB;

public class Coupler {
    public final RailEntity root;
    public RailEntity entity;
    public boolean autocoupler;
    public final boolean frontal;
    public MiniBB mbb = new MiniBB();

    public Coupler(RailEntity root, boolean bool) {
        this.root = root;
        this.frontal = bool;
    }

    public boolean isFront() {
        return this.entity == null ? false : this.entity.front.entity == this.root;
    }

    public boolean isRear() {
        return this.entity == null ? false : this.entity.rear.entity == this.root;
    }

    public void decouple() {
        if (this.entity == null) {
            return;
        }
        if (this.root.com.size() <= 2 || this.entity.com.size() <= 2) {
            this.root.com = new Compound.Singular(this.root);
            this.entity.com = new Compound.Singular(this.entity);
        } else if (this.root.com.isHead(this.root)) {
            this.root.com.entities.remove(0);
            this.root.com = new Compound.Singular(this.root);
        } else if (this.root.com.isEnd(this.root)) {
            this.root.com.entities.remove(this.root.com.size() - 1);
            this.root.com = new Compound.Singular(this.root);
        } else {
            int notlesser;
            int lesser;
            int idx1;
            int idx0 = this.root.com.getIndex(this.root);
            if (idx0 < (idx1 = this.root.com.getIndex(this.entity))) {
                lesser = idx0;
                notlesser = idx1;
            } else {
                lesser = idx1;
                notlesser = idx0;
            }
            Compound old = this.root.com;
            if (lesser == 0) {
                new Compound.Singular(this.root);
            } else {
                new Compound.Multiple(old, 0, lesser + 1);
            }
            if (old.entities.size() - 1 == notlesser) {
                new Compound.Singular(old.entities.get(notlesser));
            } else {
                new Compound.Multiple(old, notlesser, old.entities.size());
            }
            old.dispose();
        }
        if (this.isFront()) {
            this.entity.front.entity = null;
            this.entity = null;
        }
        if (this.isRear()) {
            this.entity.rear.entity = null;
            this.entity = null;
        }
    }

    public void couple(RailEntity ent, boolean front) {
        if (this.root.com != null && ent.com != null && this.root.com.equals(ent.com)) {
            return;
        }
        this.entity = ent;
        (front ? ent.front : ent.rear).entity = this.root;
        if (!this.root.region.getSystem().isRemote()) {
            this.root.updateClient("couplers");
            ent.updateClient("couplers");
        }
        if (this.root.com.isSingular() && this.entity.com.isSingular()) {
            this.root.com.dispose();
            this.entity.com.dispose();
            this.root.com = this.entity.com = new Compound.Multiple(this.root, this.entity);
            FvtmLogger.debug((Object)"REC: created new");
            this.notifyDriver("Coupled at " + (this.frontal ? "front." : "rear."));
        } else if (!this.root.com.isSingular() && !this.entity.com.isSingular()) {
            if (this.root.com.isEnd(this.root)) {
                if (!this.entity.com.isHead(this.entity)) {
                    Collections.reverse(this.entity.com.entities);
                }
                this.entity.com.dispose();
                this.root.com.entities.addAll(this.entity.com.entities);
                this.root.com.entities.forEach(e -> {
                    e.com = this.root.com;
                });
                this.notifyDriver("Coupled a compound to end.");
            } else {
                if (this.entity.com.isHead(this.entity)) {
                    Collections.reverse(this.entity.com.entities);
                }
                this.entity.com.dispose();
                this.root.com.entities.addAll(0, this.entity.com.entities);
                this.root.com.entities.forEach(e -> {
                    e.com = this.root.com;
                });
                this.notifyDriver("Coupled a compound to begin.");
            }
            FvtmLogger.debug((Object)"REC: fused");
        } else if (this.root.com.isSingular()) {
            if (this.entity.com.isHead(this.entity)) {
                this.entity.com.entities.add(0, this.root);
            } else {
                this.entity.com.entities.add(this.root);
            }
            this.root.com.dispose();
            this.root.com = this.entity.com;
            FvtmLogger.debug((Object)"REC: attached root");
            this.notifyDriver("Coupled to another compound.");
        } else if (this.entity.com.isSingular()) {
            if (this.root.com.isHead(this.root)) {
                this.root.com.entities.add(0, this.entity);
            } else {
                this.root.com.entities.add(this.entity);
            }
            this.entity.com.dispose();
            this.entity.com = this.root.com;
            FvtmLogger.debug((Object)"REC: attached entity");
            this.notifyDriver("RollingStock coupled to compound.");
        }
    }

    private void notifyDriver(String string) {
        for (RailEntity ent : this.root.com.entities) {
            if (ent.vehicle.entity == null) continue;
            for (SeatInstance seat : ent.vehicle.seats) {
                if (!seat.seat.driver || seat.passenger() == null) continue;
                seat.passenger().send("&e&7" + string);
            }
        }
    }

    public boolean hasEntity() {
        return this.entity != null;
    }

    public boolean inRange() {
        if (this.isFront()) {
            return this.entity.front.mbb.contains(this.mbb.center);
        }
        if (this.isRear()) {
            return this.entity.rear.mbb.contains(this.mbb.center);
        }
        return false;
    }

    public Coupler getOpposite() {
        return this.frontal ? this.root.rear : this.root.front;
    }

    public Coupler getCounterpart() {
        return this.isFront() ? this.entity.front : (this.isRear() ? this.entity.rear : null);
    }

    public boolean isFrontal() {
        return this.frontal;
    }
}

