/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.util.ArrayList;
import java.util.UUID;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.sys.rail.Compound;
import net.fexcraft.mod.fvtm.sys.rail.Coupler;
import net.fexcraft.mod.fvtm.sys.rail.EntryDirection;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailRegion;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.rail.TrackUnit;
import net.fexcraft.mod.fvtm.sys.uni.PathKey;
import net.fexcraft.mod.fvtm.sys.uni.RegionKey;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.MiniBB;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.fvtm.util.SaveUtils;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;

public class RailEntity
implements Comparable<RailEntity> {
    public Track current;
    public Track last;
    public VehicleInstance vehicle;
    public long uid;
    public RailRegion region;
    public double passed;
    public V3D pos = new V3D();
    public V3D prev = new V3D();
    public V3D cfront = new V3D();
    public V3D crear = new V3D();
    public V3D bfront = new V3D();
    public V3D brear = new V3D();
    private UUID placer = FvtmLogger.NULL_UUID;
    public Coupler front = new Coupler(this, true);
    public Coupler rear = new Coupler(this, false);
    public double frbogiedis;
    public double rrbogiedis;
    public double frconndis;
    public double rrconndis;
    public double length;
    public double moverq;
    public TrackUnit[] unitson = new TrackUnit[4];
    private MiniBB ccalc = new MiniBB();
    private boolean hascoupled;
    protected Compound com;
    protected WaitingAt wait_at;
    public ArrayList<String> lines = new ArrayList();
    private byte ticks;
    private ArrayList<RailEntity> railentlist = new ArrayList();

    public RailEntity(RailSystem data, VehicleInstance veh, Track track, UUID placer) {
        this.setveh(veh);
        this.current = track;
        this.region = (RailRegion)data.getRegions().getC(track.start.pos, true);
        if (placer != null) {
            this.placer = placer;
        }
        this.uid = data.getNewEntityId();
        data.updateEntityEntry(this.uid, this.region.key);
        this.frbogiedis = -veh.data.getWheelPositions().get((Object)"bogie_front").z;
        this.rrbogiedis = veh.data.getWheelPositions().get((Object)"bogie_rear").z;
        this.frconndis = -veh.data.getConnectorFor((String)"front").z;
        this.rrconndis = veh.data.getConnectorFor((String)"rear").z;
        this.com = new Compound.Singular(this);
        this.bfront = this.move(this.rrconndis + this.frbogiedis, TrainPoint.BOGIE_FRONT);
        this.brear = this.move(this.rrconndis - this.rrbogiedis, TrainPoint.BOGIE_REAR);
        this.pos = this.bfront.middle(this.brear);
        this.moverq += (double)0.02f;
        this.cfront = this.move(this.rrconndis + this.frconndis, TrainPoint.COUPLER_FRONT);
        this.crear = this.move(0.0, TrainPoint.COUPLER_REAR);
        this.front.mbb.update(this.cfront, ((Vehicle)veh.data.getType()).getCouplerRange() / 2.0f);
        this.rear.mbb.update(this.crear, ((Vehicle)veh.data.getType()).getCouplerRange() / 2.0f);
        this.region.spawnEntity(this.start());
    }

    public void setveh(VehicleInstance veh) {
        this.vehicle = veh;
        this.vehicle.railent = this;
        this.vehicle.iref().update();
    }

    public RailEntity(RailRegion railregion, Compound compound) {
        this.region = railregion;
        this.com = compound;
        this.setveh(new VehicleInstance(null, null));
    }

    public RailEntity(RailRegion railregion, long uid) {
        this.region = railregion;
        this.uid = uid;
        this.com = Compound.getNewClientCompound(this);
        this.setveh(new VehicleInstance(null, null));
    }

    public long getUID() {
        return this.uid;
    }

    public RailRegion getRegion() {
        return this.region;
    }

    public void onUpdate() {
        if (this.region.getSystem().isRemote()) {
            this.updatePosition();
            return;
        }
        if (this.current == null || this.vehicle == null || this.vehicle.data == null) {
            this.remove();
            return;
        }
        this.checkIfShouldStop();
        if (this.wait_at != null) {
            this.wait_at.junction.pollSignal(this, this.wait_at.dir);
            if (this.wait_at.junction.getSignalState(this.wait_at.dir)) {
                this.wait_at = null;
            }
        }
        if (!((Vehicle)this.vehicle.data.getType()).isWagon() && this.notPaused() && this.vehicle.throttle > (double)0.001f && this.vehicle.engine != null && (this.needsNoFuel() || this.vehicle.consumeFuel())) {
            double eng = this.vehicle.throttle * (double)this.vehicle.engine.getSphEngineSpeed();
            if (this.com.isMultiple()) {
                this.com.accumulator = (float)((double)this.com.accumulator + eng);
            } else {
                this.moverq = this.com.forward ? eng : -eng;
            }
        }
        double am = this.moverq;
        boolean move = this.com.isSingular();
        if (this.com.isMultiple()) {
            if (this.com.forward && this.com.isHead(this)) {
                am = this.front.hasEntity() ? (double)(-this.com.accumulator) : (double)this.com.accumulator;
                this.com.accumulator = 0.0f;
                move = true;
            } else if (!this.com.forward && this.com.isEnd(this)) {
                am = this.rear.hasEntity() ? (double)this.com.accumulator : (double)(-this.com.accumulator);
                this.com.accumulator = 0.0f;
                move = true;
            }
        }
        if (am > 0.001 || am < -0.001) {
            TRO tro = this.getTrack(this.current, this.passed + am, false);
            am = this.checkForPushCoupling(tro, am);
            if (move) {
                tro = this.checkPathWithSignals(new TROE(this.current, this.passed + (am > 0.0 ? this.frconndis - this.frbogiedis : -this.rrconndis - this.frbogiedis), am));
                if (this.com.last_stop != null && tro.track != this.com.last_stop && (tro.passed > this.com.last_stop_passed || tro.passed < this.com.last_stop_passed)) {
                    this.com.last_stop = null;
                    this.com.last_stop_passed = tro.passed;
                }
                am = ((TROE)tro).moved;
            }
            this.moveOnTrack(am);
            if (!this.hascoupled && this.isCoupled() && this.com.isMultiple() && move) {
                this.moveCompound(am);
            }
            this.hascoupled = false;
            this.moverq = 0.0;
        }
        if (this.com.isHead(this) && (this.ticks = (byte)(this.ticks + 1)) > 10) {
            this.updateOrientationAttr();
            this.ticks = 0;
        }
        this.region.getSystem().updateEntityEntry(this.uid, this.region.key);
        if (this.vehicle.entity != null) {
            this.vehicle.onUpdate();
            if (this.vehicle.entity.pushTicks() % Config.VEHICLE_SYNC_RATE == 0) {
                this.vehicle.sendUpdatePacket();
            }
        }
    }

    private void moveOnTrack(double am) {
        TRO tro = this.getTrack(this.current, this.passed + am, true);
        this.last = this.current;
        this.current = tro.track;
        this.passed = tro.passed;
        if (!this.last.equals(this.current)) {
            this.updateClient("track");
        }
        this.updateClient("passed");
        if (!this.region.key.isInRegion(this.current.start)) {
            this.updateRegion(this.current.start);
        }
        this.updatePosition();
    }

    private boolean needsNoFuel() {
        if (!Config.VEHICLES_NEED_FUEL || !this.vehicle.data.getAttribute("use-fuel").asBoolean()) {
            return true;
        }
        EntityW driver = this.vehicle.driver();
        if (driver != null) {
            return driver.isCreative();
        }
        return false;
    }

    public void checkIfShouldStop() {
        if (this.vehicle.entity == null) {
            return;
        }
        boolean decrease = false;
        EntityW con = this.vehicle.driver();
        if (!this.isActive() && con != null && !con.isCreative() && this.vehicle.data.getAttribute("fuel_stored").asInteger() <= 0) {
            decrease = true;
        }
        if (decrease) {
            this.vehicle.throttle *= (double)0.98f;
        }
    }

    private boolean isCoupled() {
        return this.front.hasEntity() || this.rear.hasEntity();
    }

    public final void moveCompound(double amount) {
        Coupler coupler = this.front.hasEntity() ? this.rear : this.front;
        boolean rev = false;
        while (coupler.getOpposite().hasEntity()) {
            if ((coupler = coupler.getOpposite()).isFrontal() ? coupler.isFront() : coupler.isRear()) {
                boolean bl = rev = !rev;
            }
            if ((coupler = coupler.getCounterpart()) == null || coupler.root == null) break;
            coupler.root.moveOnTrack(rev ? -amount : amount);
        }
    }

    private double checkForPushCoupling(TRO tro, double am) {
        if (this.front.hasEntity() && this.rear.hasEntity()) {
            return am;
        }
        ArrayList<RailEntity> ents = this.getEntitiesOnTrackAndNext(tro.track);
        Coupler[] couplers = new Coupler[]{this.front, this.rear};
        for (int i = 0; i < 2; ++i) {
            if (couplers[i].hasEntity()) continue;
            V3D coucen = i == 0 ? this.cfront : this.crear;
            for (RailEntity ent : ents) {
                double coupos;
                double entpos;
                if (ent == this || ent == this.front.entity || ent == this.rear.entity || ent.com.uid == this.com.uid) continue;
                this.ccalc.update(ent.cfront, ent.crear, 0.125f);
                if (!this.ccalc.contains(coucen)) continue;
                if (ent.rear.mbb.contains(coucen)) {
                    entpos = ent.pos.dis(this.pos);
                    if (entpos < (coupos = ent.crear.dis(this.pos))) continue;
                    this.hascoupled = true;
                    couplers[i].couple(ent, false);
                    am = coucen.dis(ent.crear);
                    if (ent.brear.dis(coucen) < ent.crear.dis(coucen)) {
                        am = -am;
                    }
                    FvtmLogger.debug((Object)("coupling " + (i == 0 ? "front" : "rear") + " to rear"));
                }
                if (!ent.front.mbb.contains(coucen) || (entpos = ent.pos.dis(this.pos)) < (coupos = ent.cfront.dis(this.pos))) continue;
                this.hascoupled = true;
                couplers[i].couple(ent, true);
                am = coucen.dis(ent.cfront);
                if (ent.bfront.dis(coucen) < ent.cfront.dis(coucen)) {
                    am = -am;
                }
                FvtmLogger.debug((Object)("coupling " + (i == 0 ? "front" : "rear") + " to front"));
            }
        }
        return am;
    }

    public void updatePosition() {
        this.bfront = this.move(this.passed, TrainPoint.BOGIE_FRONT);
        this.brear = this.move(this.passed - this.frbogiedis - this.rrbogiedis, TrainPoint.BOGIE_REAR);
        this.cfront = this.move(this.passed + (this.frconndis - this.frbogiedis), TrainPoint.COUPLER_FRONT);
        this.crear = this.move(this.passed - this.frbogiedis - this.rrconndis, TrainPoint.COUPLER_REAR);
        this.prev.copy(this.pos);
        this.pos = this.bfront.middle(this.brear);
        this.front.mbb.update(this.cfront, ((Vehicle)this.vehicle.data.getType()).getCouplerRange());
        this.rear.mbb.update(this.crear, ((Vehicle)this.vehicle.data.getType()).getCouplerRange());
    }

    private ArrayList<RailEntity> getEntitiesOnTrackAndNext(Track track) {
        Track track0;
        this.railentlist.clear();
        this.railentlist.addAll(track.unit.getEntities());
        Junction junction = (Junction)this.region.get(track.start.pos);
        if (junction != null && (track0 = junction.getNext(null, track.getId(), false, false)) != null) {
            this.railentlist.addAll(track0.unit.getEntities());
        }
        if ((junction = (Junction)this.region.get(track.end.pos)) != null && (track0 = junction.getNext(null, track.getOppositeId(), false, false)) != null) {
            this.railentlist.addAll(track0.unit.getEntities());
        }
        return this.railentlist;
    }

    protected void updateClient(String string) {
        if (this.vehicle.entity == null) {
            return;
        }
        TagCW compound = TagCW.create();
        switch (string) {
            case "track": {
                compound.set("sub", "track");
                this.current.getId().write(compound);
                break;
            }
            case "passed": {
                compound.set("sub", "passed");
                compound.set("passed", this.passed);
            }
        }
        this.vehicle.sendUpdate("rail_ent", compound);
    }

    public void onPacket(EntityW pass, TagCW com) {
        if (this.vehicle.entity == null) {
            return;
        }
        switch (com.getString("sub")) {
            case "track": {
                this.current = this.region.getTrack(new PathKey(com));
                break;
            }
            case "passed": {
                this.passed = com.getDouble("passed");
            }
        }
    }

    public void updateRegion(QV3D start) {
        this.region.getEntities().remove(this.uid);
        this.region = (RailRegion)this.region.getSystem().getRegions().getC(RegionKey.getRegionXZ(start), true);
        this.region.getEntities().put(this.uid, this);
    }

    public V3D move(double passed, TrainPoint point) {
        TRO tro = this.getTrack(this.current, passed, point.updatesJunction(passed > 0.0));
        if (this.unitson[point.index] == null) {
            this.unitson[point.index] = tro.track.unit;
            this.unitson[point.index].update(this, true);
        } else {
            this.unitson[point.index].update(this, false);
            this.unitson[point.index] = tro.track.unit;
            this.unitson[point.index].update(this, true);
        }
        return tro.track.getVectorPosition(tro.passed, false);
    }

    public V3D moveOnly(float passed) {
        TRO tro = this.getTrack(this.current, passed, true);
        return tro.track.getVectorPosition(tro.passed, false);
    }

    private TRO getTrack(Track track, double pass, boolean apply) {
        Track newtrack;
        Junction junc;
        while (pass > track.length) {
            junc = (Junction)this.region.get(track.end.pos);
            if (junc == null) {
                this.com.stop(track, track.length);
                return new TRO(track, track.length);
            }
            newtrack = junc.getNext(this, track.getOppositeId(), apply, false);
            if (newtrack != null) {
                pass -= track.length;
                track = newtrack;
                continue;
            }
            return new TRO(track, track.length);
        }
        while (pass < 0.0) {
            junc = (Junction)this.region.get(track.start.pos);
            if (junc == null) {
                this.com.stop(track, 0.0);
                return new TRO(track, 0.0);
            }
            newtrack = junc.getNext(this, track.getId(), apply, false);
            if (newtrack != null) {
                pass += newtrack.length;
                track = newtrack.createOppositeCopy();
                continue;
            }
            return new TRO(track, 0.0);
        }
        return new TRO(track, pass);
    }

    private TROE checkPathWithSignals(TROE tro) {
        Track newtrack;
        EntryDirection dir;
        Junction junc;
        if (tro.passed + tro.moveby > tro.track.length) {
            tro.moved += tro.track.length - tro.passed;
            junc = (Junction)this.region.get(tro.track.end.pos);
            if (junc == null) {
                this.com.stop(tro.track, tro.track.length);
                tro.passed = tro.track.length;
                return tro;
            }
            if (junc.hasSignal(tro.track.getOppositeId()) && this.isActiveEnd()) {
                dir = junc.eqTrack(tro.track.getOppositeId(), 0) ? EntryDirection.FORWARD : EntryDirection.BACKWARD;
                junc.pollSignal(this, dir);
                if (!junc.getSignalState(dir) && this.notPaused()) {
                    this.wait_at = new WaitingAt(junc, dir);
                    tro.passed = tro.track.length;
                    return tro;
                }
            }
            if ((newtrack = junc.getNext(this, tro.track.getOppositeId(), true, true)) != null) {
                tro.moveby -= tro.track.length - tro.passed;
                tro.passed = 0.0;
                tro.track = newtrack;
                if (tro.moveby > 0.0) {
                    return this.checkPathWithSignals(tro);
                }
            } else {
                this.com.stop(tro.track, tro.track.length);
                tro.passed = tro.track.length;
                return tro;
            }
        }
        if (tro.passed + tro.moveby < 0.0) {
            tro.moved -= tro.passed;
            junc = (Junction)this.region.get(tro.track.start.pos);
            if (junc == null) {
                this.com.stop(tro.track, 0.0);
                tro.passed = 0.0;
                return tro;
            }
            if (junc.hasSignal(tro.track.getId()) && this.isActiveEnd()) {
                dir = junc.eqTrack(tro.track.getId(), 0) ? EntryDirection.FORWARD : EntryDirection.BACKWARD;
                junc.pollSignal(this, dir);
                if (!junc.getSignalState(dir) && this.notPaused()) {
                    this.wait_at = new WaitingAt(junc, dir);
                    tro.passed = 0.0;
                    return tro;
                }
            }
            if ((newtrack = junc.getNext(this, tro.track.getId(), true, true)) != null) {
                tro.moveby += tro.passed;
                tro.passed = newtrack.length;
                tro.track = newtrack.createOppositeCopy();
                if (tro.moveby < 0.0) {
                    return this.checkPathWithSignals(tro);
                }
            } else {
                this.com.stop(tro.track, 0.0);
                tro.passed = 0.0;
                return tro;
            }
        }
        tro.passed += tro.moveby;
        tro.moved += tro.moveby;
        return tro;
    }

    public void checkIfShouldHaveEntity() {
        if (this.vehicle.entity != null) {
            if (this.vehicle.seats != null) {
                for (SeatInstance seat : this.vehicle.seats) {
                    if (seat.passenger() == null) continue;
                    return;
                }
            }
            if (this.isInPlayerRange()) {
                return;
            }
            this.vehicle.entity.remove();
            this.vehicle.entity = null;
        } else {
            if (!this.isInPlayerRange()) {
                return;
            }
            this.region.getSystem().getFvtmServerWorld().spawnRailEntity(this);
        }
    }

    private boolean isInPlayerRange() {
        for (EntityW pl : this.region.getSystem().getServerWorld().getPlayers()) {
            if (!(this.pos.dis(pl.getPos()) < 256.0)) continue;
            return true;
        }
        return false;
    }

    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        compound.set("uid", this.uid);
        compound.set("region", this.region.key.toArray());
        if (this.current != null) {
            this.current.getId().write(compound);
        }
        compound.set("pos", SaveUtils.saveV3D(this.pos));
        compound.set("prev", SaveUtils.saveV3D(this.prev));
        compound.set("cfront", SaveUtils.saveV3D(this.cfront));
        compound.set("bfront", SaveUtils.saveV3D(this.bfront));
        compound.set("crear", SaveUtils.saveV3D(this.crear));
        compound.set("brear", SaveUtils.saveV3D(this.brear));
        compound.set("forward", this.com.getOrient(this));
        compound.set("passed", this.passed);
        compound.set("Placer0", this.placer.getMostSignificantBits());
        compound.set("Placer1", this.placer.getLeastSignificantBits());
        if (this.front.entity != null) {
            compound.set("front_coupled", this.front.entity.uid);
            compound.set("front_coupler", this.front.isFront());
        }
        compound.set("front_auto", this.front.autocoupler);
        if (this.rear.entity != null) {
            compound.set("rear_coupled", this.rear.entity.uid);
            compound.set("rear_coupler", this.rear.isFront());
        }
        compound.set("rear_auto", this.rear.autocoupler);
        if (this.wait_at != null) {
            compound.set("WaitSig", this.wait_at.junction.getPos().pos);
            compound.set("WaitSigDir", this.wait_at.dir.ordinal());
        }
        compound.set("Compound", this.com.getUID());
        compound.set("Singular", this.com.isSingular());
        compound.set("throttle", this.vehicle.throttle);
        return this.vehicle.data.write(compound);
    }

    public RailEntity read(TagCW compound) {
        this.uid = compound.getLong("uid");
        if (this.region == null) {
            FvtmLogger.debug((Object)"region is NULL");
        }
        this.current = this.region.getTrack(new PathKey(compound));
        if (this.current == null) {
            FvtmLogger.log((Object)("track not found! " + new PathKey(compound).toString()));
        }
        if (this.current == null) {
            this.remove();
            return this;
        }
        this.pos = SaveUtils.loadV3D(compound.getList("pos"));
        this.prev = SaveUtils.loadV3D(compound.getList("prev"));
        this.cfront = SaveUtils.loadV3D(compound.getList("cfront"));
        this.bfront = SaveUtils.loadV3D(compound.getList("bfront"));
        this.crear = SaveUtils.loadV3D(compound.getList("crear"));
        this.brear = SaveUtils.loadV3D(compound.getList("brear"));
        this.passed = compound.getFloat("passed");
        this.vehicle.throttle = compound.getFloat("throttle");
        this.front.autocoupler = compound.getBoolean("front_auto");
        this.rear.autocoupler = compound.getBoolean("rear_auto");
        if (compound.has("WaitSig")) {
            try {
                this.wait_at = new WaitingAt(((RailSystem)this.region.system).getJunction(compound.getV3I("WaitSig")), EntryDirection.values()[compound.getInteger("WaitSigDir")]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.placer = new UUID(compound.getLong("Placer0"), compound.getLong("Placer1"));
        if (this.vehicle.data == null) {
            this.vehicle.init(FvtmResources.getVehicleData(compound), null);
        } else {
            this.vehicle.data.read(compound);
        }
        if (this.vehicle.data == null) {
            this.remove();
            return null;
        }
        this.frbogiedis = -this.vehicle.data.getWheelPositions().get((Object)"bogie_front").z;
        this.rrbogiedis = this.vehicle.data.getWheelPositions().get((Object)"bogie_rear").z;
        this.frconndis = -this.vehicle.data.getConnectorFor((String)"front").z;
        this.rrconndis = this.vehicle.data.getConnectorFor((String)"rear").z;
        this.updatePosition();
        return this;
    }

    public void loadCouple(boolean frontcoupler, long uid, boolean asfront) {
        RailEntity ent = this.region.getSystem().getEntity(uid, true);
        if (ent == null) {
            return;
        }
        Coupler coupler = frontcoupler ? this.front : this.rear;
        coupler.entity = ent;
        coupler = asfront ? ent.front : ent.rear;
        coupler.entity = this;
    }

    public void alignEntity(boolean initial) {
        if (this.vehicle.entity == null) {
            return;
        }
        this.vehicle.entity.setPos(this.pos);
    }

    public void remove() {
        FvtmLogger.debug((Object)("Removing TrackEntity " + this.uid + "!"));
        this.front.decouple();
        this.rear.decouple();
        this.region.getSystem().delEntity(this);
        if (this.vehicle.entity != null && !this.vehicle.entity.isRemoved()) {
            this.vehicle.entity.remove();
        }
        for (TrackUnit section : this.unitson) {
            if (section == null) continue;
            section.getEntities().remove(this);
        }
    }

    public UUID getPlacer() {
        return this.placer;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RailEntity)) {
            return false;
        }
        return ((RailEntity)obj).getUID() == this.getUID();
    }

    @Override
    public int compareTo(RailEntity obj) {
        return Long.compare(obj.getUID(), this.getUID());
    }

    public void tryCoupling(EntityW player, boolean thefront) {
        V3D vec;
        Coupler coupler = thefront ? this.front : this.rear;
        V3D v3D = vec = thefront ? this.cfront : this.crear;
        if (coupler.hasEntity()) {
            coupler.decouple();
            player.send((thefront ? "Front" : "Rear") + " disconnected.");
        } else {
            ArrayList<RailEntity> ents = this.getEntitiesOnTrackAndNext(this.current);
            RailEntity found = null;
            for (RailEntity ent : ents) {
                FvtmLogger.debug((Object)ent.vehicle.data.getName());
                if (ent.uid == this.uid) continue;
                if (ent.rear.mbb.contains(vec)) {
                    found = ent;
                    coupler.couple(ent, false);
                    break;
                }
                if (!ent.front.mbb.contains(vec)) continue;
                found = ent;
                coupler.couple(ent, true);
                break;
            }
            if (found != null) {
                player.send((thefront ? "Front" : "Rear") + " connected.");
                player.send("&7&o" + found.vehicle.data.getName());
            } else if (coupler.hasEntity()) {
                coupler.decouple();
                player.send((thefront ? "Front" : "Rear") + " disconnected.");
            } else {
                player.send("Nothing found to connect to.");
            }
        }
    }

    public MiniBB[] getCouplerMBBs() {
        return new MiniBB[]{this.front.mbb, this.rear.mbb};
    }

    public void setThrottle(double am) {
        for (RailEntity ent : this.com.entities) {
            if (((Vehicle)ent.vehicle.data.getType()).isWagon()) continue;
            ent.vehicle.throttle = am;
        }
    }

    public void setForward(EntityW player, boolean bool) {
        this.com.forward = bool;
        this.com.accumulator = 0.0f;
        if (player != null) {
            player.bar("fvtm.rail.direction_" + (bool ? "forward" : "reverse"));
        }
        for (RailEntity ent : this.com.entities) {
            ent.vehicle.data.getAttribute("forward").set(this.com.getOrient(ent));
            ent.wait_at = null;
            ent.moverq = 0.0;
            ent.sendForwardUpdate();
        }
    }

    private void sendForwardUpdate() {
        if (this.vehicle.entity == null || this.region.getSystem().isRemote()) {
            return;
        }
        this.vehicle.updateAttr("forward");
    }

    private void updateOrientationAttr() {
        for (RailEntity ent : this.com.entities) {
            if (this.com.getOrient(ent)) continue;
            ent.sendForwardUpdate();
        }
    }

    public void setActive(boolean bool) {
        this.vehicle.data.getAttribute("active").set(bool);
        if (this.vehicle.entity != null && !this.region.getSystem().isRemote()) {
            this.vehicle.updateAttr("active");
        }
    }

    public boolean isHeadingForward() {
        return this.com.getOrient(this);
    }

    public boolean isActive() {
        return this.vehicle.data.getAttribute("active").asBoolean();
    }

    public String toString() {
        return "RE['" + this.uid + "', '" + this.vehicle.data.getName() + "', '" + this.pos.toString() + "']";
    }

    public boolean isPaused() {
        return this.com.forward ? this.com.getHead().wait_at != null : this.com.getEnd().wait_at != null;
    }

    public boolean notPaused() {
        return this.com.forward ? this.com.getHead().wait_at == null : this.com.getEnd().wait_at == null;
    }

    public boolean isActiveEnd() {
        if (this.com.isSingular()) {
            return true;
        }
        return this.com.forward ? this.com.isHead(this) : this.com.isEnd(this);
    }

    public Compound getCompound() {
        return this.com;
    }

    public RailEntity start() {
        return this;
    }

    public void flip() {
        if (!this.com.isSingular()) {
            return;
        }
        if (this.last != null) {
            this.last = this.last.createOppositeCopy();
        }
        this.current = this.current.createOppositeCopy();
        this.passed = this.current.oppositePassed(this.passed);
        this.updatePosition();
    }

    public static enum TrainPoint {
        COUPLER_FRONT(0),
        BOGIE_FRONT(1),
        BOGIE_REAR(2),
        COUPLER_REAR(3);

        int index;

        private TrainPoint(int idx) {
            this.index = idx;
        }

        public boolean updatesJunction(boolean forward) {
            return true;
        }
    }

    public static class WaitingAt {
        public Junction junction;
        public EntryDirection dir;

        public WaitingAt(Junction junc, EntryDirection entry) {
            this.junction = junc;
            this.dir = entry;
        }
    }

    public static class TRO {
        public Track track;
        public double passed;

        public TRO(Track track, double passed) {
            this.track = track;
            this.passed = passed;
        }
    }

    public static class TROE
    extends TRO {
        public double moveby;
        public double moved = 0.0;

        public TROE(Track track, double passed, double moved) {
            super(track, passed);
            this.moveby = moved;
        }
    }
}

