/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.sys.uni.DetachedSystem;
import net.fexcraft.mod.fvtm.sys.uni.RegionKey;
import net.fexcraft.mod.fvtm.sys.uni.SysObj;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;

public class SystemRegMap<R extends DetachedSystem<R, V>, V extends SysObj>
extends ConcurrentHashMap<RegionKey, SystemRegion<R, V>> {
    private Function<RegionKey, SystemRegion<R, V>> function;
    private R system;

    public SystemRegMap(R sys, Function<RegionKey, SystemRegion<R, V>> func) {
        this.system = sys;
        this.function = func;
    }

    public SystemRegion<R, V> get(int x, int z) {
        for (SystemRegion reg : this.values()) {
            if (x != reg.key.x || z != reg.key.z) continue;
            return reg;
        }
        return null;
    }

    public SystemRegion<R, V> get(int[] xz) {
        for (SystemRegion reg : this.values()) {
            if (xz[0] != reg.key.x || xz[1] != reg.key.z) continue;
            return reg;
        }
        return null;
    }

    public SystemRegion<R, V> get(V3I pos, boolean load) {
        SystemRegion<R, V> region = this.get(RegionKey.getRegionXZ(pos));
        if (region != null || !load) {
            return region;
        }
        region = this.function.apply(new RegionKey(RegionKey.getRegionXZ(pos)));
        this.put(region.key, region);
        region.load().sendSync(pos);
        return region;
    }

    public <C extends SystemRegion<R, V>> C getC(V3I pos, boolean load) {
        return (C)this.get(pos, load);
    }

    public SystemRegion<R, V> get(int[] xz, boolean load) {
        SystemRegion<R, V> region = this.get(xz);
        if (region != null || !load) {
            return region;
        }
        region = this.function.apply(new RegionKey(xz[0], xz[1]));
        this.put(region.key, region);
        return region.load();
    }

    public <C extends SystemRegion<R, V>> C getC(int[] xz, boolean load) {
        return (C)this.get(xz, load);
    }

    public SystemRegion<R, V> get(RegionKey xz, boolean load) {
        SystemRegion<R, V> region = this.get(xz.x, xz.z);
        if (region != null || !load) {
            return region;
        }
        region = this.function.apply(xz);
        this.put(region.key, region);
        return region.load();
    }

    public <C extends SystemRegion<R, V>> C getC(RegionKey xz, boolean load) {
        return (C)this.get(xz, load);
    }
}

