/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fcl.UniFCL;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.SignData;
import net.fexcraft.mod.fvtm.sys.sign.SignInstance;
import net.fexcraft.mod.fvtm.sys.sign.SignSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.ui.SignEditor;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;

public class SignContainer
extends ContainerInterface {
    protected SignSystem system;
    protected SignInstance inst;
    protected ArrayList<SignData> signs = new ArrayList();

    public SignContainer(JsonMap map, UniEntity player, V3I pos) {
        super(map, player, pos);
        try {
            this.system = (SignSystem)SystemManager.get(SystemManager.Systems.SIGN, player.entity.getWorld());
            this.inst = (SignInstance)this.system.get(pos);
            this.signs.addAll(this.inst.components);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void packet(TagCW com, boolean client) {
        String task;
        FvtmLogger.debug((Object)com);
        switch (task = com.getString("task")) {
            case "rem": {
                SignData sign = this.signs.remove(com.getInteger("idx"));
                if (sign != null) {
                    this.inst.components.remove(sign);
                }
                this.mirror(com, client);
                return;
            }
            case "copy": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                if (sign != null) {
                    SignData data = new SignData((Sign)sign.getType()).read(sign.write(TagCW.create()));
                    this.inst.components.add(data);
                    this.signs.add(data);
                }
                this.mirror(com, client);
                return;
            }
            case "pos": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                switch (com.getInteger("axis")) {
                    case 0: {
                        sign.offset.x = com.getFloat("value");
                        break;
                    }
                    case 1: {
                        sign.offset.y = com.getFloat("value");
                        break;
                    }
                    case 2: {
                        sign.offset.z = com.getFloat("value");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (client) break;
                SEND_TO_CLIENT.accept(com, this.player);
                break;
            }
            case "rot": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                switch (com.getInteger("axis")) {
                    case 0: {
                        sign.rotx = com.getFloat("value");
                        break;
                    }
                    case 1: {
                        sign.roty = com.getFloat("value");
                        break;
                    }
                    case 2: {
                        sign.rotz = com.getFloat("value");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (client) break;
                SEND_TO_CLIENT.accept(com, this.player);
                break;
            }
            case "scale": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                switch (com.getInteger("axis")) {
                    case 0: {
                        sign.sclx = com.getFloat("value");
                        break;
                    }
                    case 1: {
                        sign.scly = com.getFloat("value");
                        break;
                    }
                    case 2: {
                        sign.sclz = com.getFloat("value");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (client) break;
                SEND_TO_CLIENT.accept(com, this.player);
                break;
            }
            case "tex": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                int sel = com.getInteger("sel");
                if (sel < 0 || sel >= ((Sign)sign.getType()).getDefaultTextures().size()) break;
                sign.getTexture().setSelectedTexture(sel, null, false);
                this.mirror(com, client);
                break;
            }
            case "texc": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                String tex = com.getString("loc");
                boolean ext = com.getBoolean("ext");
                if (ext && !UniFCL.URL_TEXTURES && !tex.startsWith("server:")) {
                    this.player.entity.send("ui.fvtm.toolbox.texture.no_url");
                    this.player.entity.send("ui.fvtm.toolbox.texture.server");
                    break;
                }
                sign.getTexture().setSelectedTexture(-1, tex, ext);
                this.mirror(com, client);
                break;
            }
            case "color": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                sign.getColorChannel((String)com.getString((String)"channel")).packed = com.getInteger("rgb");
                this.mirror(com, client);
                break;
            }
            case "text_center": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                if (!((Sign)sign.getType()).isText()) {
                    return;
                }
                sign.centered = !sign.centered;
                this.mirror(com, client);
                break;
            }
            case "text": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                if (!((Sign)sign.getType()).isText()) {
                    return;
                }
                sign.form = sign.text = com.getString("text");
                this.mirror(com, client);
                break;
            }
            case "side": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                if (!((Sign)sign.getType()).isBase()) {
                    return;
                }
                int i = com.getInteger("side");
                sign.sides[i] = !sign.sides[i];
                this.mirror(com, client);
                break;
            }
            case "width": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                if (!((Sign)sign.getType()).isBase()) {
                    return;
                }
                sign.width = com.getFloat("val");
                this.mirror(com, client);
                break;
            }
            case "height": {
                SignData sign = this.signs.get(com.getInteger("idx"));
                if (!((Sign)sign.getType()).isBase()) {
                    return;
                }
                sign.height = com.getFloat("val");
                this.mirror(com, client);
                break;
            }
            case "rem_all": {
                this.inst.components.clear();
                this.inst.updateClient();
                this.signs.clear();
                this.mirror(com, client);
                break;
            }
            case "import": {
                try {
                    String cb = com.getString("cb");
                    if (!cb.startsWith("[")) {
                        return;
                    }
                    this.inst.components.clear();
                    JsonArray array = JsonHandler.parse((String)cb, (boolean)false).asArray();
                    for (JsonValue val : (List)array.value) {
                        try {
                            JsonMap map = val.asMap();
                            Sign type = FvtmRegistry.SIGNS.get(map.get("type").string_value());
                            SignData sign = new SignData(type).parse(map);
                            this.inst.components.add(sign);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    this.inst.updateClient();
                    this.player.entity.openUI(UIKeys.SIGN_EDITOR, this.pos);
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void mirror(TagCW com, boolean client) {
        if (!client) {
            SEND_TO_CLIENT.accept(com, this.player);
        } else {
            ((SignEditor)this.ui).select(0);
        }
    }

    public void onClosed() {
        super.onClosed();
        if (this.inst != null && !this.player.entity.isOnClient()) {
            this.inst.updateClient();
        }
    }
}

