/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.rail;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.sys.event.EventAction;
import net.fexcraft.mod.fvtm.sys.event.EventActions;
import net.fexcraft.mod.fvtm.sys.event.EventListener;
import net.fexcraft.mod.fvtm.sys.event.EventType;
import net.fexcraft.mod.fvtm.ui.rail.RailJuncEventsCon;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class RailJuncEvents
extends UserInterface {
    private static List<EventType> types = new ArrayList<EventType>();
    private static int type;
    private static int sel;
    private RailJuncEventsCon menu;

    public RailJuncEvents(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
        this.menu = (RailJuncEventsCon)con;
    }

    public void init() {
        types.clear();
        types.add(EventType.JUNC_PASS);
        if (this.menu.junc.hasSignals()) {
            types.add(EventType.JUNC_SIGNAL);
        } else if (this.menu.junc.type.isSwitch() || this.menu.junc.type.isDouble()) {
            types.add(EventType.JUNC_SWITCH);
        }
        this.updateListener();
    }

    public void predraw(float ticks, int mx, int my) {
    }

    public void drawbackground(float ticks, int mx, int my) {
    }

    public void postdraw(float ticks, int mx, int my) {
    }

    public boolean onAction(UIButton button, String id, int x, int y, int mb) {
        switch (id) {
            case "t_prev": {
                if (--type < 0) {
                    type = types.size() - 1;
                    sel = 0;
                }
                this.updateListener();
                break;
            }
            case "t_next": {
                if (++type >= types.size()) {
                    type = 0;
                    sel = 0;
                }
                this.updateListener();
                break;
            }
            case "add": 
            case "rem": {
                TagCW com = TagCW.create();
                com.set("task", id);
                com.set("type", RailJuncEvents.types.get((int)RailJuncEvents.type).key);
                com.set("sel", sel);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "paste": {
                try {
                    JsonMap map = JsonHandler.parse((String)this.root.getClipboard(), (boolean)true).asMap();
                    EventType type = EventType.parse(map.get("type").string_value());
                    if (!types.contains(type)) break;
                    ((UIField)this.fields.get("cond")).text(map.get("cond").string_value());
                    ((UIField)this.fields.get("act")).text(map.get("action").string_value());
                    ((UIField)this.fields.get("arg")).text(map.getString("args", ""));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.container.player.entity.send("error: see log");
                }
                break;
            }
            case "copye": {
                try {
                    JsonMap map = new JsonMap();
                    map.add("type", RailJuncEvents.types.get((int)RailJuncEvents.type).key);
                    map.add("cond", ((UIField)this.fields.get("cond")).text());
                    map.add("action", ((UIField)this.fields.get("act")).text());
                    map.add("args", ((UIField)this.fields.get("arg")).text());
                    this.root.setClipboard(map.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.container.player.entity.send("error: see log");
                }
                break;
            }
            case "e_prev": {
                --sel;
                this.updateListener();
                break;
            }
            case "e_next": {
                ++sel;
                this.updateListener();
                break;
            }
            case "a_prev": 
            case "a_next": {
                int idx;
                EventType et = types.get(type);
                List<EventAction> list = et == EventType.JUNC_PASS ? EventActions.JUNC_PASS_ACTIONS : (et == EventType.JUNC_SIGNAL ? EventActions.JUNC_SIGNAL_ACTIONS : EventActions.JUNC_SWITCH_ACTIONS);
                EventAction act = EventAction.parse(((UIField)this.fields.get("act")).text());
                int n = idx = act == EventAction.NONE ? -1 : list.indexOf(act);
                if (idx < 0) {
                    ((UIField)this.fields.get("act")).text(list.get((int)0).key);
                    break;
                }
                if ((idx += id.equals("a_prev") ? -1 : 1) < 0) {
                    idx = list.size() - 1;
                }
                if (idx >= list.size()) {
                    idx = 0;
                }
                ((UIField)this.fields.get("act")).text(list.get((int)idx).key);
                break;
            }
            case "clear_cond": {
                ((UIField)this.fields.get("cond")).text("true");
                break;
            }
            case "clear_act": {
                ((UIField)this.fields.get("act")).text("logger");
                break;
            }
            case "clear_arg": {
                ((UIField)this.fields.get("arg")).text("");
                break;
            }
            case "reset": {
                ((UIField)this.fields.get("arg")).text("{event}/{junction}");
                break;
            }
            case "save": {
                TagCW com = TagCW.create();
                com.set("task", id);
                com.set("type", RailJuncEvents.types.get((int)RailJuncEvents.type).key);
                com.set("sel", sel);
                com.set("cond", ((UIField)this.fields.get("cond")).text());
                com.set("act", ((UIField)this.fields.get("act")).text());
                com.set("arg", ((UIField)this.fields.get("arg")).text());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
        }
        return false;
    }

    protected void updateListener() {
        if (type >= types.size()) {
            type = types.size() - 1;
        }
        EventType et = types.get(type);
        int am = 0;
        if (this.menu.junc.holder.listeners.containsKey(et)) {
            am = this.menu.junc.holder.listeners.get(et).size();
            if (sel >= am) {
                sel = am - 1;
            }
            if (sel < 0) {
                sel = 0;
            }
        } else {
            sel = 0;
        }
        ((UIText)this.texts.get("title")).transval("ui.fvtm.rail_junction_events." + et.key, new Object[]{et.key});
        ((UIText)this.texts.get("entry")).transval("ui.fvtm.rail_junction_events.selected", new Object[]{sel + 1, am});
        if (am > 0) {
            EventListener lis = this.menu.junc.holder.listeners.get(et).get(sel);
            ((UIField)this.fields.get("cond")).text(lis.cond.toString());
            ((UIField)this.fields.get("act")).text(lis.action.key);
            ((UIField)this.fields.get("arg")).text(lis.argString());
        } else {
            ((UIField)this.fields.get("cond")).text("");
            ((UIField)this.fields.get("act")).text("");
            ((UIField)this.fields.get("arg")).text("");
        }
    }

    public void getTooltip(int mx, int my, List<String> list) {
    }
}

