/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.road;

import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.ui.road.RoadToolCon;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UISlot;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class RoadToolUI
extends UserInterface {
    protected RoadToolCon rtc;

    public RoadToolUI(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
        this.rtc = (RoadToolCon)con;
    }

    public void predraw(float ticks, int mx, int my) {
        if (this.rtc.custom_road) {
            ((UIText)this.texts.get("road_fill")).value("ui.fvtm.road_tool.road_fill_custom");
            ((UIText)this.texts.get("road_fill")).translate();
        } else if (this.rtc.inventory.empty(0)) {
            ((UIText)this.texts.get("road_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("road_fill")).translate();
        } else {
            ((UIText)this.texts.get("road_fill")).value(this.rtc.inventory.get(0).getName());
        }
        ((UIText)this.texts.get("road_width")).value("ui.fvtm.road_tool.road_fill_width");
        ((UIText)this.texts.get("road_width")).translate(new Object[]{this.rtc.rt_width});
        ((UIText)this.texts.get("slab_width")).value("ui.fvtm.road_tool.slab_fill_width");
        ((UIText)this.texts.get("slab_width")).translate(new Object[]{this.rtc.rt_width});
        if (this.rtc.custom_slab) {
            ((UIText)this.texts.get("slab_fill")).value("ui.fvtm.road_tool.slab_fill_custom");
            ((UIText)this.texts.get("slab_fill")).translate();
        } else if (this.rtc.inventory.empty(6)) {
            ((UIText)this.texts.get("slab_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("slab_fill")).translate();
        } else {
            ((UIText)this.texts.get("slab_fill")).value(this.rtc.inventory.get(6).getName());
        }
        if (this.rtc.inventory.empty(1)) {
            ((UIText)this.texts.get("ground_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("ground_fill")).translate();
        } else {
            ((UIText)this.texts.get("ground_fill")).value(this.rtc.inventory.get(1).getName());
        }
        ((UIText)this.texts.get("ground_status")).value("ui.fvtm.road_tool.ground_fill_" + (this.rtc.bot_on ? "enabled" : "disabled"));
        ((UIText)this.texts.get("ground_status")).translate();
        if (this.rtc.inventory.empty(2)) {
            ((UIText)this.texts.get("left_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("left_fill")).translate();
        } else {
            ((UIText)this.texts.get("left_fill")).value(this.rtc.inventory.get(2).getName());
        }
        if (this.rtc.lheight > 0) {
            ((UIText)this.texts.get("left_size")).value("ui.fvtm.road_tool.left_fill_size");
            ((UIText)this.texts.get("left_size")).translate(new Object[]{this.rtc.lheight});
        } else {
            ((UIText)this.texts.get("left_size")).value("ui.fvtm.road_tool.left_fill_disabled");
            ((UIText)this.texts.get("left_size")).translate();
        }
        if (this.rtc.inventory.empty(3)) {
            ((UIText)this.texts.get("right_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("right_fill")).translate();
        } else {
            ((UIText)this.texts.get("right_fill")).value(this.rtc.inventory.get(3).getName());
        }
        if (this.rtc.rheight > 0) {
            ((UIText)this.texts.get("right_size")).value("ui.fvtm.road_tool.right_fill_size");
            ((UIText)this.texts.get("right_size")).translate(new Object[]{this.rtc.rheight});
        } else {
            ((UIText)this.texts.get("right_size")).value("ui.fvtm.road_tool.right_fill_disabled");
            ((UIText)this.texts.get("right_size")).translate();
        }
        if (this.rtc.custom_top) {
            ((UIText)this.texts.get("top_fill")).value("ui.fvtm.road_tool.top_fill_custom");
            ((UIText)this.texts.get("top_fill")).translate();
        } else if (this.rtc.inventory.empty(4)) {
            ((UIText)this.texts.get("top_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("top_fill")).translate();
        } else {
            ((UIText)this.texts.get("top_fill")).value(this.rtc.inventory.get(4).getName());
        }
        ((UIText)this.texts.get("top_status")).value("ui.fvtm.road_tool.top_fill_" + (this.rtc.top_on ? "enabled" : "disabled"));
        ((UIText)this.texts.get("top_status")).translate();
        if (this.rtc.custom_lines) {
            ((UIText)this.texts.get("lines_fill")).value("ui.fvtm.road_tool.lines_fill_custom");
            ((UIText)this.texts.get("lines_fill")).translate();
        } else if (this.rtc.inventory.empty(5)) {
            ((UIText)this.texts.get("lines_fill")).value("ui.fvtm.road_tool.no_fill_block");
            ((UIText)this.texts.get("lines_fill")).translate();
        } else {
            ((UIText)this.texts.get("lines_fill")).value(this.rtc.inventory.get(5).getName());
        }
        ((UIText)this.texts.get("lines_status")).value("ui.fvtm.road_tool.lines_fill_" + (this.rtc.lin_on ? "enabled" : "disabled"));
        ((UIText)this.texts.get("lines_status")).translate();
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "add_width0": 
            case "add_width1": {
                if (++this.rtc.rt_width > 64) {
                    this.rtc.rt_width = 64;
                }
                ContainerInterface.sendToServer(com -> com.set("cargo", "add_width"));
                return true;
            }
            case "sub_width0": 
            case "sub_width1": {
                if (--this.rtc.rt_width < 1) {
                    this.rtc.rt_width = 1;
                }
                ContainerInterface.sendToServer(com -> com.set("cargo", "sub_width"));
                return true;
            }
            case "enable_ground": {
                ContainerInterface.sendToServer(com -> {
                    com.set("cargo", "ground");
                    this.rtc.bot_on = true;
                    com.set("ground", true);
                });
                return true;
            }
            case "disable_ground": {
                ContainerInterface.sendToServer(com -> {
                    com.set("cargo", "ground");
                    this.rtc.bot_on = false;
                    com.set("ground", false);
                });
                return true;
            }
            case "add_left": {
                if (++this.rtc.lheight > 64) {
                    this.rtc.lheight = 64;
                }
                ContainerInterface.sendToServer(com -> com.set("cargo", "add_left"));
                return true;
            }
            case "sub_left": {
                if (--this.rtc.lheight < 0) {
                    this.rtc.lheight = 0;
                }
                ContainerInterface.sendToServer(com -> com.set("cargo", "sub_left"));
                return true;
            }
            case "add_right": {
                if (++this.rtc.rheight > 64) {
                    this.rtc.rheight = 64;
                }
                ContainerInterface.sendToServer(com -> com.set("cargo", "add_right"));
                return true;
            }
            case "sub_right": {
                if (--this.rtc.rheight < 0) {
                    this.rtc.rheight = 0;
                }
                ContainerInterface.sendToServer(com -> com.set("cargo", "sub_right"));
                return true;
            }
            case "enable_top": {
                ContainerInterface.sendToServer(com -> {
                    com.set("cargo", "top");
                    this.rtc.top_on = true;
                    com.set("top", true);
                });
                return true;
            }
            case "disable_top": {
                ContainerInterface.sendToServer(com -> {
                    com.set("cargo", "top");
                    this.rtc.top_on = false;
                    com.set("top", false);
                });
                return true;
            }
            case "enable_lines": {
                ContainerInterface.sendToServer(com -> {
                    com.set("cargo", "lines");
                    this.rtc.lin_on = true;
                    com.set("lines", true);
                });
                return true;
            }
            case "disable_lines": {
                ContainerInterface.sendToServer(com -> {
                    com.set("cargo", "lines");
                    this.rtc.lin_on = false;
                    com.set("lines", false);
                });
                return true;
            }
            case "edit_road": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "custom");
                compound.set("layer", 0);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "edit_slab": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "custom");
                compound.set("layer", 6);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "edit_top": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "custom");
                compound.set("layer", 4);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "edit_lines": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "custom");
                compound.set("layer", 5);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "rem_road": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "remove");
                compound.set("layer", 0);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "rem_slab": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "remove");
                compound.set("layer", 6);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "rem_top": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "remove");
                compound.set("layer", 4);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
            case "rem_lines": {
                TagCW compound = TagCW.create();
                compound.set("cargo", "remove");
                compound.set("layer", 5);
                ContainerInterface.SEND_TO_SERVER.accept(compound);
                return true;
            }
        }
        return false;
    }

    public void getTooltip(int mx, int my, List<String> list) {
        int i;
        if (this.rtc.inventory.empty(0) && ((UISlot)this.slots.get("road")).hovered(this.gLeft, this.gTop, mx, my)) {
            for (i = 0; i < 8; ++i) {
                list.add((String)ContainerInterface.TRANSLATOR.apply("ui.fvtm.road_tool.road_slot_info" + i));
            }
        }
        if (this.rtc.inventory.empty(6) && ((UISlot)this.slots.get("slab")).hovered(this.gLeft, this.gTop, mx, my)) {
            for (i = 0; i < 4; ++i) {
                list.add((String)ContainerInterface.TRANSLATOR.apply("ui.fvtm.road_tool.road_slab_info" + i));
            }
        }
    }
}

