/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data;

import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.Content;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.WithItem;
import net.fexcraft.mod.fvtm.util.ContentConfigUtil;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.inv.ItemWrapper;

public class Consumable
extends Content<Consumable>
implements WithItem,
ItemTextureable {
    protected byte max_stack;
    protected ItemWrapper item;
    protected String ore_dict;
    protected String container;
    protected String ctab;
    private int healamount;
    private int useduration;
    private float saturation;
    private boolean wolffood;
    private boolean drinkable;
    private boolean alwaysedible;
    protected IDL itemtexloc;

    @Override
    public Consumable parse(JsonMap map) {
        this.pack = ContentConfigUtil.getAddon(map);
        if (this.pack == null) {
            return null;
        }
        this.id = ContentConfigUtil.getID(this.pack, map);
        if (this.id == null) {
            return null;
        }
        this.name = map.getString("Name", "Unnamed Consumable");
        this.description = ContentConfigUtil.getStringList(map, "Description");
        this.max_stack = (byte)map.getInteger("MaxItemStackSize", 64);
        this.ore_dict = map.getString("OreDictionary", null);
        this.container = map.getString("ContainerItem", null);
        this.healamount = map.getInteger("HealAmount", 1);
        this.saturation = map.getFloat("Saturation", 0.6f);
        this.useduration = map.getInteger("UseDuration", 32);
        this.wolffood = map.getBoolean("WolfFood", false);
        this.drinkable = map.getBoolean("Drinkable", false);
        this.alwaysedible = map.getBoolean("AlwaysEdible", false);
        this.ctab = map.getString("CreativeTab", "default");
        this.itemtexloc = ContentConfigUtil.getItemTexture(this.id, this.getContentType(), map);
        return this;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.CONSUMABLE;
    }

    @Override
    public Class<?> getDataClass() {
        return null;
    }

    public int getMaxStack() {
        return this.max_stack;
    }

    public String getOreDictId() {
        return this.ore_dict;
    }

    public int getHealAmount() {
        return this.healamount;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public int getItemUseDuration() {
        return this.useduration;
    }

    public boolean isWolfFood() {
        return this.wolffood;
    }

    public boolean isDrinkable() {
        return this.drinkable;
    }

    public boolean isAlwaysEdible() {
        return this.alwaysedible;
    }

    @Override
    public String getCreativeTab() {
        return this.ctab;
    }

    @Override
    public String getItemContainer() {
        return this.container;
    }

    @Override
    public IDL getItemTexture() {
        return this.itemtexloc;
    }
}

