/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.attribute;

import net.fexcraft.lib.common.math.V3D;

public class AttrBox {
    public final String id;
    public V3D pos;
    public String swivel_point;
    public float size;
    public float increase = 1.0f;
    public float decrease = -1.0f;
    public float reset = 0.0f;

    public AttrBox(String id, String point, float[] data) {
        this.swivel_point = point == null ? "vehicle" : point;
        this.id = id;
        this.pos = new V3D((double)data[0], (double)data[1], (double)data[2]);
        this.size = data[3] * 0.5f;
        if (data.length > 4) {
            this.increase = data[4];
            this.decrease = data[5];
            this.reset = data[6];
        }
    }

    public AttrBox(String id, V3D pos, float size, float increase, float decrease, float reset, String swivel_point) {
        this.swivel_point = swivel_point;
        this.id = id;
        this.pos = pos.copy();
        this.size = size;
        this.increase = increase;
        this.decrease = decrease;
        this.reset = reset;
    }

    public void copy(AttrBox from) {
        this.swivel_point = from.swivel_point;
        this.pos = from.pos.copy();
        this.size = from.size;
        this.increase = from.increase;
        this.decrease = from.decrease;
        this.reset = from.reset;
    }

    public AttrBox copy() {
        return new AttrBox(this.id, this.pos, this.size, this.increase, this.decrease, this.reset, this.swivel_point);
    }

    public String toString() {
        return String.format("ABx{%s, %s, %s, %s, %s, %s, %s}", this.id, this.pos, Float.valueOf(this.size), Float.valueOf(this.increase), Float.valueOf(this.decrease), Float.valueOf(this.reset), this.swivel_point);
    }
}

