/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.vehicle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.ContentData;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.Seat;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.inv.FvtmInv;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.data.part.PartSlots;
import net.fexcraft.mod.fvtm.data.root.Colorable;
import net.fexcraft.mod.fvtm.data.root.Lockable;
import net.fexcraft.mod.fvtm.data.root.Sound;
import net.fexcraft.mod.fvtm.data.root.Soundable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.WheelSlot;
import net.fexcraft.mod.fvtm.function.part.ColorFunction;
import net.fexcraft.mod.fvtm.function.part.ConnectorFunction;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.function.part.InteractZoneFunction;
import net.fexcraft.mod.fvtm.function.part.InventoryFunction;
import net.fexcraft.mod.fvtm.function.part.PartSlotsFunction;
import net.fexcraft.mod.fvtm.function.part.SeatsFunction;
import net.fexcraft.mod.fvtm.function.part.WheelPositionsFunction;
import net.fexcraft.mod.fvtm.sys.event.EventHolder;
import net.fexcraft.mod.uni.EnvInfo;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.MessageSender;

public class VehicleData
extends ContentData<Vehicle, VehicleData>
implements Colorable,
Soundable,
Textureable.TextureUser {
    public HashMap<String, ArrayList<Map.Entry<String, PartData>>> sorted_parts = new HashMap();
    protected TreeMap<String, Attribute<?>> attributes = new TreeMap();
    protected TreeMap<String, PartData> parts = new TreeMap();
    protected TreeMap<String, RGB> channels = new TreeMap();
    protected TreeMap<String, WheelSlot> wheels = new TreeMap();
    protected TreeMap<String, V3D> wheelpos = new TreeMap();
    protected TreeMap<String, Sound> sounds = new TreeMap();
    protected TreeMap<String, SwivelPoint> rotpoints = new TreeMap();
    protected TreeMap<String, PartSlots> partproviders = new TreeMap();
    protected TreeMap<String, InteractZone> interact_zones = new TreeMap();
    protected ArrayList<String> vehinvkeys = new ArrayList();
    protected ArrayList<FvtmInv> vehinvs = new ArrayList();
    protected ArrayList<String> inventories = new ArrayList();
    protected ArrayList<Seat> seats = new ArrayList();
    protected TreeMap<String, V3D> conns = new TreeMap();
    protected SwivelPoint rootpoint;
    protected Textureable texture;
    protected Lockable lock;
    protected EventHolder holder;
    protected String displayname;

    public VehicleData(Vehicle type) {
        super(type);
        this.texture = new Textureable(type);
        this.holder = new EventHolder(type);
        this.holder.integrate(type.holder, null);
        this.rootpoint = new SwivelPoint("vehicle", (String)null);
        this.rotpoints.put("vehicle", this.rootpoint);
        for (SwivelPoint swivelPoint : type.getDefaultSwivelPoints().values()) {
            this.rotpoints.put(swivelPoint.id, swivelPoint.clone(null));
        }
        for (Attribute attribute : type.getDefaultAttributes().values()) {
            Attribute copy = attribute.createCopy(null);
            this.attributes.put(copy.id, copy);
        }
        for (Map.Entry entry : type.getWheelPositions().entrySet()) {
            this.wheels.put((String)entry.getKey(), ((WheelSlot)entry.getValue()).copy(null));
        }
        for (Map.Entry entry : type.getDefaultColorChannels().entrySet()) {
            this.channels.put((String)entry.getKey(), ((RGB)entry.getValue()).copy());
        }
        for (InteractZone interactZone : type.getDefaultInteractZones()) {
            this.interact_zones.put(interactZone.id, interactZone.copy());
        }
        this.partproviders.put("vehicle", type.getPartSlots());
        if (type.getInstalled() != null) {
            for (Map.Entry entry : type.getInstalled().entrySet()) {
                try {
                    Part part = FvtmRegistry.PARTS.get((IDL)entry.getValue());
                    if (part == null || this.installPart(FvtmLogger.NONE, new PartData(part), (String)entry.getKey(), false) == null) continue;
                    FvtmLogger.log(new Exception(), "vehicle (" + String.valueOf(type.getID()) + ") part pre-install returned non-null for " + ((IDL)entry.getValue()).colon() + " as " + (String)entry.getKey());
                }
                catch (Exception e) {
                    if (EnvInfo.DEV) continue;
                    FvtmLogger.log(e, "vehicledata (" + String.valueOf(type.getID()) + ") part pre-install of " + ((IDL)entry.getValue()).colon() + " as " + (String)entry.getKey());
                }
            }
        }
        for (Map.Entry entry : type.definvs.entrySet()) {
            this.vehinvkeys.add((String)entry.getKey());
            this.vehinvs.add((FvtmInv)((FvtmInv)entry.getValue()).copy());
        }
        this.rotpoints.values().forEach(point -> point.linkToParent(this));
        this.sounds.putAll(type.getSounds());
        this.conns.putAll(type.getDefaultConnectors());
        this.lock = new Lockable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public TagCW write(TagCW compound) {
        void var5_13;
        if (compound == null) {
            compound = TagCW.create();
        }
        compound.set("format", 4.0f);
        compound.set("Vehicle", ((Vehicle)this.type).getID().toString());
        TagCW cparts = TagCW.create();
        for (Map.Entry<String, PartData> entry : this.parts.entrySet()) {
            cparts.set(entry.getKey(), entry.getValue().write(null));
        }
        compound.set("Parts", cparts);
        TagCW cattrs = TagCW.create();
        for (Attribute<?> attribute : this.attributes.values()) {
            cattrs.set(attribute.id, attribute.save(TagCW.create()));
        }
        compound.set("Attributes", cattrs);
        this.texture.save(compound);
        for (String string : this.channels.keySet()) {
            compound.set("RGB_" + string, this.channels.get((Object)string).packed);
        }
        TagCW tagCW = TagCW.create();
        for (Map.Entry<String, V3D> entry : this.wheelpos.entrySet()) {
            TagLW list = TagLW.create();
            list.add(entry.getValue().x);
            list.add(entry.getValue().y);
            list.add(entry.getValue().z);
            tagCW.set(entry.getKey(), list);
        }
        compound.set("WheelPos", tagCW);
        boolean bl = false;
        while (var5_13 < this.vehinvs.size()) {
            this.vehinvs.get((int)var5_13).save(compound, "Inv_" + this.vehinvkeys.get((int)var5_13));
            ++var5_13;
        }
        if (!this.rotpoints.isEmpty()) {
            TagCW tagCW2 = TagCW.create();
            for (Map.Entry<String, SwivelPoint> point : this.rotpoints.entrySet()) {
                if (point.getKey().equals("vehicle")) continue;
                tagCW2.set(point.getKey(), point.getValue().write(TagCW.create()));
            }
            if (!tagCW2.empty()) {
                compound.set("SwivelPoints", tagCW2);
            }
        }
        this.lock.save(compound);
        if (this.displayname != null) {
            compound.set("DisplayName", this.displayname);
        }
        return compound;
    }

    @Override
    public VehicleData read(TagCW compound) {
        TagCW com;
        if (compound == null) {
            compound = TagCW.create();
        }
        if (compound.has("Parts")) {
            TagCW cparts = compound.getCompound("Parts");
            this.parts.clear();
            for (String key : cparts.keys()) {
                com = cparts.getCompound(key);
                PartData part = FvtmResources.getPartData(com);
                if (part == null) continue;
                this.parts.put(key, part);
            }
        }
        if (compound.has("Attributes")) {
            TagCW cattrs = compound.getCompound("Attributes");
            for (String key : cattrs.keys()) {
                com = cattrs.getCompound(key);
                Attribute<?> attr = this.getAttribute(key);
                if (attr == null) {
                    attr = Attribute.parse(key, com);
                    if (attr == null) continue;
                    this.attributes.put(key, attr);
                    continue;
                }
                attr.load(com);
            }
        }
        for (Attribute attribute : ((Vehicle)this.type).getDefaultAttributes().values()) {
            if (!this.attributes.containsKey(attribute.id)) {
                Attribute copy = attribute.createCopy(null);
                this.attributes.put(copy.id, copy);
            }
            Attribute<?> attri = this.attributes.get(attribute.id);
            attri.copyBoxesFrom(attribute);
            attri.perm = attribute.perm;
        }
        if (EnvInfo.CLIENT) {
            for (Attribute attribute : this.attributes.values()) {
                attribute.genDefaultIcons();
            }
        }
        this.texture.load(compound);
        for (String string : this.channels.keySet()) {
            if (!compound.has("RGB_" + string)) continue;
            this.channels.get((Object)string).packed = compound.getInteger("RGB_" + string);
        }
        this.refreshModificableDataByParts();
        if (compound.has("WheelPos")) {
            TagCW cwp = compound.getCompound("WheelPos");
            this.wheelpos.clear();
            for (String key : cwp.keys()) {
                this.wheelpos.put(key, cwp.getV3D(key));
            }
        }
        for (int i = 0; i < this.vehinvs.size(); ++i) {
            this.vehinvs.get(i).load(compound, "Inv_" + this.vehinvkeys.get(i));
        }
        if (compound.has("SwivelPoints")) {
            TagCW csp = compound.getCompound("SwivelPoints");
            for (String key : csp.keys()) {
                com = csp.getCompound(key);
                if (this.rotpoints.containsKey(key)) {
                    this.rotpoints.get(key).read(null, this, com);
                    continue;
                }
                this.rotpoints.put(key, new SwivelPoint(this, key, com));
            }
        }
        this.rotpoints.values().forEach(point -> point.linkToParent(this));
        this.lock.load(compound);
        if (compound.has("DisplayName")) {
            this.displayname = compound.getString("DisplayName");
        }
        return this;
    }

    private void refreshModificableDataByParts() {
        PartFunction.StaticFunction func;
        this.wheels.clear();
        ((Vehicle)this.type).getWheelPositions().entrySet().forEach(entry -> this.wheels.put((String)entry.getKey(), ((WheelSlot)entry.getValue()).copy(null)));
        for (Map.Entry<String, PartData> entry2 : this.parts.entrySet()) {
            if (!entry2.getValue().hasFunction("fvtm:wheel_positions")) continue;
            WheelPositionsFunction wheelPositionsFunction = (WheelPositionsFunction)entry2.getValue().getFunction("fvtm:wheel_positions");
            wheelPositionsFunction.getPositions().entrySet().forEach(entry -> {
                String key = ((String)entry.getKey()).replace("*", (CharSequence)part.getKey());
                this.wheels.put(key, ((WheelSlot)entry.getValue()).copy(((PartData)part.getValue()).getInstalledPos()));
            });
        }
        this.seats.clear();
        for (Seat seat : ((Vehicle)this.type).getDefaultSeats()) {
            this.seats.add(seat);
        }
        for (PartData partData : this.parts.values()) {
            if (!partData.hasFunction("fvtm:seats")) continue;
            for (Seat seat : partData.getFunction(SeatsFunction.class, "fvtm:seats").getSeats()) {
                this.seats.add(seat.relative ? seat.copy(partData.getInstalledPos()) : seat);
            }
        }
        TreeMap<String, RGB> chan = new TreeMap<String, RGB>((SortedMap<String, RGB>)this.channels);
        this.channels.clear();
        for (Map.Entry<String, RGB> entry3 : ((Vehicle)this.type).getDefaultColorChannels().entrySet()) {
            this.channels.put(entry3.getKey(), entry3.getValue().copy());
        }
        for (PartData partData : this.parts.values()) {
            if (!partData.hasFunction("fvtm:color")) continue;
            TreeMap<String, RGB> colors = partData.getFunction(ColorFunction.class, "fvtm:color").getColors();
            for (Map.Entry<String, RGB> entry4 : colors.entrySet()) {
                if (this.channels.containsKey(entry4.getKey())) continue;
                this.channels.put(entry4.getKey(), entry4.getValue().copy());
            }
        }
        for (Map.Entry<String, RGB> entry5 : chan.entrySet()) {
            if (!this.channels.containsKey(entry5.getKey())) continue;
            this.channels.get((Object)entry5.getKey()).packed = entry5.getValue().packed;
        }
        this.inventories.clear();
        this.parts.forEach((key, value) -> {
            if (value.hasFunction("fvtm:inventory")) {
                this.inventories.add((String)key);
            }
        });
        this.sounds.clear();
        this.sounds.putAll(((Vehicle)this.type).getSounds());
        for (PartData partData : this.parts.values()) {
            for (Map.Entry entry6 : ((Part)partData.getType()).getSounds().entrySet()) {
                if (this.sounds.containsKey(entry6.getKey()) && !((Sound)entry6.getValue()).override) continue;
                this.sounds.put((String)entry6.getKey(), (Sound)entry6.getValue());
            }
        }
        block10: for (Attribute<?> attribute : this.attributes.values()) {
            PartData part;
            if (attribute.origin == null || (part = this.getAttributeOrigin(attribute.origin)) == null) continue;
            for (Attribute<?> attribute2 : ((Part)part.getType()).getDefaultAttributes().values()) {
                if (!attribute2.id.equals(attribute.id)) continue;
                attribute.copyBoxesFrom(attribute2);
                continue block10;
            }
        }
        this.partproviders.clear();
        if (!((Vehicle)this.type).getPartSlots().isEmpty()) {
            this.partproviders.put("vehicle", ((Vehicle)this.type).getPartSlots());
        }
        for (Map.Entry<String, PartData> entry7 : this.getParts().entrySet()) {
            PartSlots ps;
            if (!entry7.getValue().hasFunction("fvtm:part_slots") || (ps = entry7.getValue().getFunction(PartSlotsFunction.class, "fvtm:part_slots").getPartSlotss()).isEmpty()) continue;
            this.partproviders.put(entry7.getKey(), ps);
        }
        this.sortparts();
        this.conns.clear();
        this.conns.putAll(((Vehicle)this.type).getDefaultConnectors());
        for (Map.Entry<String, PartData> entry8 : this.parts.entrySet()) {
            if (!entry8.getValue().hasFunction("fvtm:connector")) continue;
            func = (ConnectorFunction)entry8.getValue().getFunction("fvtm:connector");
            for (String string : ((ConnectorFunction)func).getTypes()) {
                if (this.conns.containsKey(string)) continue;
                this.conns.put(string, entry8.getValue().getInstalledPos().add(((ConnectorFunction)func).getOffset()));
            }
        }
        this.interact_zones.clear();
        for (InteractZone interactZone : ((Vehicle)this.type).getDefaultInteractZones()) {
            this.interact_zones.put(interactZone.id, interactZone.copy());
        }
        for (PartData partData : this.parts.values()) {
            if (!partData.hasFunction("fvtm:interact_zone")) continue;
            func = partData.getFunction(InteractZoneFunction.class, "fvtm:interact_zone");
            for (InteractZone interactZone : ((InteractZoneFunction)func).getZones()) {
                if (interactZone.set != null) {
                    if (!this.interact_zones.containsKey(interactZone.id)) continue;
                    this.interact_zones.get((Object)interactZone.id).range = interactZone.set.booleanValue() ? interactZone.range : (this.interact_zones.get((Object)interactZone.id).range += interactZone.range);
                    this.interact_zones.get(interactZone.id).validate();
                }
                if (this.interact_zones.containsKey(interactZone.id)) continue;
                this.interact_zones.put(interactZone.id, interactZone.copy());
            }
        }
    }

    public void sortparts() {
        this.sorted_parts.clear();
        for (String string : this.getRotationPoints().keySet()) {
            this.sorted_parts.put(string, new ArrayList());
        }
        for (Map.Entry entry : this.parts.entrySet()) {
            if (((PartData)entry.getValue()).isInstalledOnSwivelPoint()) {
                this.sorted_parts.get(((PartData)entry.getValue()).getSwivelPointInstalledOn()).add(entry);
                continue;
            }
            this.sorted_parts.get("vehicle").add(entry);
        }
    }

    @Override
    public VehicleData parse(JsonMap obj) {
        return this;
    }

    @Override
    public JsonMap toJson() {
        return new JsonMap();
    }

    public Attribute<?> getAttribute(String id) {
        return this.attributes.get(id);
    }

    public <VAL> Attribute<VAL> getAttributeCasted(String id) {
        return this.attributes.get(id);
    }

    public TreeMap<String, Attribute<?>> getAttributes() {
        return this.attributes;
    }

    public Boolean getAttributeBoolean(String id, boolean def) {
        Attribute<?> attr = this.getAttribute(id);
        return attr == null ? def : attr.asBoolean();
    }

    public float getAttributeFloat(String id, float def) {
        Attribute<?> attr = this.getAttribute(id);
        return attr == null ? def : attr.asFloat();
    }

    public int getAttributeInteger(String id, int def) {
        Attribute<?> attr = this.getAttribute(id);
        return attr == null ? def : attr.asInteger();
    }

    public String getAttributeString(String id, String def) {
        Attribute<?> attr = this.getAttribute(id);
        return attr == null ? def : attr.asString();
    }

    public Boolean getAttributeTristate(String id, Boolean def) {
        Attribute<?> attr = this.getAttribute(id);
        return attr == null ? def : attr.asTristate();
    }

    public void setAttribute(String id, Object val) {
        Attribute<?> attr = this.getAttribute(id);
        if (attr != null) {
            attr.set(val);
        }
    }

    public PartData installPart(MessageSender engineer, PartData data, String category, boolean swap) {
        if (!((Part)data.getType()).getInstallHandler().validInstall(engineer, data, category, this, swap)) {
            return data;
        }
        if (((Part)data.getType()).getInstallHandler().processInstall(engineer, data, category, this)) {
            this.insertSwivelPointsFromPart(data, category);
            this.insertAttributesFromPart(data, category);
            this.holder.integrate(((Part)data.getType()).getEvents(), category);
            if (!swap) {
                this.resetAttributes();
            }
            this.refreshModificableDataByParts();
            return null;
        }
        return data;
    }

    public boolean deinstallPart(MessageSender sender, String category, boolean swap) {
        PartData part = this.getPart(category);
        if (!((Part)part.getType()).getInstallHandler().validUninstall(sender, part, category, this, swap)) {
            return false;
        }
        if (((Part)part.getType()).getInstallHandler().processUninstall(sender, part, category, this)) {
            this.removeSwivelPointsFromPart(part, category);
            this.removeAttributesFromPart(part, category);
            this.holder.deintegrate(((Part)part.getType()).getEvents(), category);
            if (!swap) {
                this.resetAttributes();
            }
            this.refreshModificableDataByParts();
            return true;
        }
        return false;
    }

    private void insertSwivelPointsFromPart(PartData data, String category) {
        if (((Part)data.getType()).getDefaultSwivelPoints().isEmpty()) {
            return;
        }
        for (SwivelPoint point2 : ((Part)data.getType()).getDefaultSwivelPoints().values()) {
            if (this.rotpoints.containsKey(point2.id)) continue;
            this.rotpoints.put(point2.id, point2.clone(category + "|" + ((Part)data.getType()).getIDS()));
        }
        this.rotpoints.values().forEach(point -> point.linkToParent(this));
    }

    private void removeSwivelPointsFromPart(PartData data, String category) {
        String dataid = category + "|" + ((Part)data.getType()).getIDS();
        this.rotpoints.values().removeIf(filter -> filter.origin != null && filter.origin.equals(dataid));
        this.rotpoints.values().forEach(point -> point.linkToParent(this));
    }

    private void insertAttributesFromPart(PartData data, String catin) {
        String dataid = catin + "|" + ((Part)data.getType()).getIDS();
        for (Attribute<?> attr : ((Part)data.getType()).getDefaultAttributes().values()) {
            String[] valid = attr.target.split(",");
            boolean pass = false;
            boolean not = false;
            for (String val : valid) {
                if ((val = val.trim()).startsWith("!")) {
                    not = true;
                    val = val.substring(1);
                }
                if (val.equals("vehicle")) {
                    pass = !not;
                    break;
                }
                if (val.contentEquals(((Vehicle)this.getType()).getID().colon())) {
                    pass = !not;
                    break;
                }
                if (((Vehicle)this.getType()).getCategories().contains(val)) {
                    pass = !not;
                    break;
                }
                if (!val.startsWith("pack-") || !val.substring(5).equals(((Vehicle)this.getType()).getAddon().getID().colon())) continue;
                pass = !not;
                break;
            }
            if (!pass || this.getAttributes().containsKey(attr.id)) continue;
            this.getAttributes().put(attr.id, attr.createCopy(dataid));
        }
    }

    private void removeAttributesFromPart(PartData data, String category) {
        String datain = category + "|" + ((Part)data.getType()).getIDS();
        this.attributes.entrySet().removeIf(pre -> ((Attribute)pre.getValue()).origin != null && ((Attribute)pre.getValue()).origin.equals(datain));
    }

    public void resetAttributes() {
        for (Attribute<?> attr : this.attributes.values()) {
            attr.reset();
        }
    }

    public void clearAttributes() {
        if (!this.attributes.isEmpty()) {
            this.attributes.clear();
        }
        for (Attribute<?> attr : ((Vehicle)this.type).getDefaultAttributes().values()) {
            if (!attr.target.startsWith("self")) continue;
            Attribute<?> copy = attr.createCopy(null);
            this.attributes.put(copy.id, copy);
        }
    }

    public Map<String, PartData> getParts() {
        return this.parts;
    }

    public PartData getPart(String string) {
        return this.parts.get(string);
    }

    public boolean hasPart(String string) {
        return this.getPart(string) != null;
    }

    @Override
    public RGB getColorChannel(String channel) {
        return this.channels.get(channel);
    }

    @Override
    public void setColorChannel(String channel, RGB color) {
        this.channels.put(channel, color);
    }

    public TreeMap<String, RGB> getColorChannels() {
        return this.channels;
    }

    public StackWrapper newItemStack() {
        StackWrapper stack = ((Vehicle)this.type).getNewStack();
        stack.updateTag(this.write(TagCW.create()));
        return stack;
    }

    public TreeMap<String, WheelSlot> getWheelSlots() {
        return this.wheels;
    }

    public TreeMap<String, V3D> getWheelPositions() {
        return this.wheelpos;
    }

    public List<Seat> getSeats() {
        return this.seats;
    }

    public Seat getSeat(String id) {
        for (Seat seat : this.seats) {
            if (!seat.name.equals(id)) continue;
            return seat;
        }
        return null;
    }

    public Seat getSeat(int index) {
        return index < 0 ? null : (index >= this.seats.size() ? null : this.seats.get(index));
    }

    public Lockable getLock() {
        return this.lock;
    }

    public double getThrottle() {
        return this.getAttribute("throttle").asFloat();
    }

    public ArrayList<String> getInventories() {
        return this.inventories;
    }

    public String[] getFuelGroup() {
        if (!this.parts.containsKey("engine")) {
            return new String[]{"no engine"};
        }
        if (!this.parts.get("engine").hasFunction("fvtm:engine")) {
            return new String[]{"disfunctional engine"};
        }
        return this.parts.get("engine").getFunction(EngineFunction.class, "fvtm:engine").getFuelGroup();
    }

    public boolean getLightsState() {
        return this.getAttribute("lights").asBoolean();
    }

    public boolean getFogLightsState() {
        return this.getAttribute("lights_fog").asBoolean();
    }

    public boolean getLongLightsState() {
        return this.getAttribute("lights_long").asBoolean();
    }

    public boolean getSpecialLightsState() {
        return this.getAttribute("lights_other").asBoolean();
    }

    public boolean getTurnLightLeft() {
        return this.getAttribute("turn_lights").asTristate() == Boolean.FALSE;
    }

    public boolean getTurnLightRight() {
        return this.getAttribute("turn_lights").asTristate() == Boolean.TRUE;
    }

    public boolean getWarningLights() {
        return this.getAttribute("warning_lights").asBoolean();
    }

    public int getStoredFuel() {
        return this.getAttribute("fuel_stored").asInteger();
    }

    public int getFuelCapacity() {
        return this.getAttribute("fuel_capacity").asInteger();
    }

    public List<Attribute<?>> getAttributes(String group) {
        return this.attributes.values().stream().filter(pre -> pre.group != null && pre.group.equals(group)).collect(Collectors.toList());
    }

    @Override
    public Object getSoundEvent(String event) {
        Sound sound = this.getSound(event);
        return sound == null ? null : sound.event;
    }

    @Override
    public float getSoundVolume(String event) {
        Sound sound = this.getSound(event);
        return sound == null ? 1.0f : sound.volume;
    }

    @Override
    public float getSoundPitch(String event) {
        Sound sound = this.getSound(event);
        return sound == null ? 1.0f : sound.pitch;
    }

    @Override
    public Sound getSound(String event) {
        return this.sounds.get(event);
    }

    @Override
    public void playSound(EntityW at, String event) {
        Sound sound = this.getSound(event);
        if (sound == null) {
            return;
        }
        at.playSound(sound.event, sound.volume, sound.pitch);
    }

    public TreeMap<String, SwivelPoint> getRotationPoints() {
        return this.rotpoints;
    }

    public SwivelPoint getRotationPoint(String id) {
        if (id == null) {
            return this.rootpoint;
        }
        SwivelPoint point = this.rotpoints.get(id);
        if (point == null) {
            return this.rootpoint;
        }
        return point;
    }

    public SwivelPoint getRotationPointOfPart(String cat) {
        if (cat == null || !this.parts.containsKey(cat)) {
            return this.rootpoint;
        }
        cat = this.parts.get(cat).getSwivelPointInstalledOn();
        return this.getRotationPoint(cat);
    }

    public String getName() {
        return this.displayname == null ? ((Vehicle)this.type).getName() : this.displayname;
    }

    public void setDisplayName(String string) {
        this.displayname = string;
    }

    public String getDisplayName() {
        return this.displayname;
    }

    public <F extends PartFunction> F getFunctionInPart(String part, String function) {
        return this.parts.containsKey(part) ? (F)this.parts.get(part).getFunction(function) : null;
    }

    public VehicleData copy() {
        return new VehicleData((Vehicle)this.type).read(this.write(null));
    }

    public List<Attribute<?>> getAttributeGroup(String group) {
        return this.attributes.values().stream().filter(attr -> attr.group != null && attr.group.equals(group)).collect(Collectors.toList());
    }

    public TreeMap<String, PartSlots> getPartSlotProviders() {
        return this.partproviders;
    }

    public PartSlots getPartSlotsProvider(String psp_id) {
        return this.partproviders.get(psp_id);
    }

    public boolean hasPartSlot(String str) {
        for (PartSlots slots : this.partproviders.values()) {
            for (Map.Entry entry : slots.entrySet()) {
                if (!((String)entry.getKey()).equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    public int getAttributeIndex(Attribute<?> attribute) {
        return new ArrayList<String>(this.attributes.keySet()).indexOf(attribute.id);
    }

    public Attribute<?> getAttributeByIndex(int idx) {
        return new ArrayList(this.attributes.values()).get(idx);
    }

    @Override
    public Textureable getTexture() {
        return this.texture;
    }

    @Override
    public Textureable.TextureHolder getTexHolder() {
        return (Textureable.TextureHolder)((Object)this.type);
    }

    public boolean outoffuel() {
        return this.getAttribute("fuel_stored").asInteger() <= 0;
    }

    public boolean hasfuel() {
        return this.getAttribute("fuel_stored").asInteger() > 0;
    }

    public PartData getAttributeOrigin(Attribute<?> attr) {
        return this.getAttributeOrigin(attr.origin);
    }

    public PartData getAttributeOrigin(String origin) {
        if (origin == null) {
            return null;
        }
        return this.parts.get(origin.split("\\|")[0]);
    }

    public boolean hasCompatibleConnector(List<String> categories) {
        for (String str : categories) {
            if (!this.conns.containsKey(str)) continue;
            return true;
        }
        return false;
    }

    public V3D getConnectorFor(List<String> categories) {
        for (String str : categories) {
            if (!this.conns.containsKey(str)) continue;
            return this.conns.get(str);
        }
        return V3D.NULL;
    }

    public V3D getConnectorFor(String cat) {
        if (this.conns.containsKey(cat)) {
            return this.conns.get(cat);
        }
        return V3D.NULL;
    }

    public TreeMap<String, V3D> getConnectors() {
        return this.conns;
    }

    public TreeMap<String, InteractZone> getInteractZones() {
        return this.interact_zones;
    }

    public int getPartIndex(PartData part) {
        int idx = 0;
        for (PartData data : this.parts.values()) {
            if (data.equals(part)) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public PartData getIndexPart(int idx) {
        int lidx = 0;
        for (PartData data : this.parts.values()) {
            if (lidx == idx) {
                return data;
            }
            ++lidx;
        }
        return null;
    }

    public EventHolder getEventHolder() {
        return this.holder;
    }

    public ArrayList<String> getVehInvKeys() {
        return this.vehinvkeys;
    }

    public ArrayList<FvtmInv> getVehInventories() {
        return this.vehinvs;
    }

    public FvtmInv getInvByIdx(int idx) {
        if (idx < this.vehinvkeys.size()) {
            return this.vehinvs.get(idx);
        }
        InventoryFunction func = (InventoryFunction)this.getFunctionInPart(this.inventories.get(idx -= this.vehinvkeys.size()), "fvtm:inventory");
        return func.inventory();
    }

    public boolean hasPartWithId(String str) {
        for (PartData value : this.parts.values()) {
            if (!((Part)value.getType()).getIDS().equals(str)) continue;
            return true;
        }
        return false;
    }
}

