/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.vehicle;

import java.util.ArrayList;
import net.fexcraft.mod.fvtm.data.attribute.AttrBoolean;
import net.fexcraft.mod.fvtm.data.attribute.AttrFloat;
import net.fexcraft.mod.fvtm.data.attribute.AttrInteger;
import net.fexcraft.mod.fvtm.data.attribute.AttrString;
import net.fexcraft.mod.fvtm.data.attribute.AttrTristate;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;

public enum VehicleType {
    LAND("Landvehicle"),
    WATER("Watercraft"),
    RAIL("Railvehicle"),
    AIR("Aircraft"),
    HELI("Helicraft"),
    SPACE("Spacecraft");

    private String name;

    private VehicleType(String name) {
        this.name = name;
    }

    public boolean isLandVehicle() {
        return this == LAND;
    }

    public boolean isWaterVehicle() {
        return this == WATER;
    }

    public boolean isRailVehicle() {
        return this == RAIL;
    }

    public boolean isAirVehicle() {
        return this == AIR || this == HELI;
    }

    public boolean isHeli() {
        return this == HELI;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<Attribute<?>> getDefaultAttributesForType(boolean trailer) {
        ArrayList attrs = new ArrayList();
        attrs.add(new AttrFloat("weight", Float.valueOf(1000.0f)).limit(0.0f, 2.1474836E9f));
        attrs.add(new AttrBoolean("constructor_show", true).editable(true));
        attrs.add(new AttrFloat("hitbox_width", Float.valueOf(1.0f)).limit(0.0f, 16.0f).editable(false));
        attrs.add(new AttrFloat("hitbox_height", Float.valueOf(1.0f)).limit(0.0f, 16.0f).editable(false));
        attrs.add(new AttrInteger("fuel_capacity", 20000).limit(0.0f, 2.1474836E9f));
        attrs.add(new AttrString("fuel_primary", ""));
        attrs.add(new AttrString("fuel_secondary", ""));
        attrs.add(new AttrFloat("fuel_quality", Float.valueOf(0.0f)).limit(0.0f, 10.0f));
        attrs.add(new AttrInteger("fuel_stored", 0).limit(0.0f, 2.1474836E9f));
        attrs.add(new AttrBoolean("lights", false).addAccess("driver").sync(true).addIcons("true", "fvtm:textures/gui/icons/lights_low_on.png", "false", "fvtm:textures/gui/icons/lights_low_off.png"));
        attrs.add(new AttrFloat("throttle", Float.valueOf(0.0f)).limit(-10.0f, 10.0f));
        attrs.add(new AttrBoolean("front_connected", false).editable(false));
        attrs.add(new AttrBoolean("rear_connected", false).editable(false));
        attrs.add(new AttrFloat("brake_force", Float.valueOf(15000.0f)).limit(0.0f, 2.1474836E9f));
        attrs.add(new AttrFloat("parking_brake_force", Float.valueOf(5000.0f)).limit(0.0f, 2.1474836E9f));
        attrs.add(new AttrFloat("roll_resistance", Float.valueOf(8.0f)).limit(0.0f, 2.1474836E9f));
        attrs.add(new AttrFloat("air_resistance", Float.valueOf(2.5f)).limit(0.0f, 2.1474836E9f));
        attrs.add(new AttrFloat("differential_ratio", Float.valueOf(3.5f)).limit(0.0f, 2.1474836E9f));
        attrs.add(new AttrInteger("gear", 0).limit(-64.0f, 64.0f));
        attrs.add(new AttrFloat("speed", Float.valueOf(0.0f)).limit(-2.1474836E9f, 2.1474836E9f).editable(false));
        attrs.add(new AttrInteger("rpm", 0).limit(0.0f, 2.1474836E9f).editable(false));
        attrs.add(new AttrInteger("generated_keys", 0).limit(0.0f, 8.0f).editable(false));
        switch (this) {
            case LAND: {
                attrs.add(new AttrBoolean("lights_fog", false).editable(true).addAccess("driver").sync(true).addIcons("true", "fvtm:textures/gui/icons/lights_fog_on.png", "false", "fvtm:textures/gui/icons/lights_fog_off.png"));
                attrs.add(new AttrBoolean("lights_long", false).editable(true).addAccess("driver").sync(true).addIcons("true", "fvtm:textures/gui/icons/lights_high_on.png", "false", "fvtm:textures/gui/icons/lights_high_off.png"));
                attrs.add(new AttrBoolean("lights_other", false).editable(true).addAccess("driver").sync(true));
                attrs.add(new AttrTristate("turn_lights", (Boolean)null).editable(true).addAccess("driver").sync(true).addIcons("true", "fvtm:textures/gui/icons/turn_indicator_right.png", "false", "fvtm:textures/gui/icons/turn_indicator_left.png", "null", "fvtm:textures/gui/icons/turn_indicator.png"));
                attrs.add(new AttrBoolean("warning_lights", false).editable(true).addAccess("driver").sync(true).addIcons("true", "fvtm:textures/gui/icons/warning_lights_on.png", "false", "fvtm:textures/gui/icons/warning_lights_off.png"));
                attrs.add(new AttrFloat("steering_angle", Float.valueOf(0.0f)).limit(-90.0f, 90.0f));
                attrs.add(new AttrFloat("wheel_angle", Float.valueOf(0.0f)).limit(-360.0f, 360.0f));
                attrs.add(new AttrFloat("max_steering_angle", Float.valueOf(35.0f)).limit(-90.0f, 90.0f).editable(false));
                attrs.add(new AttrFloat("max_towing", Float.valueOf(3500.0f)).limit(1.0f, 2.1474836E9f).editable(false));
                if (trailer) {
                    attrs.add(new AttrFloat("trailer_weight_ratio", Float.valueOf(0.2f)).limit(0.0f, 1.0f));
                }
                attrs.add(new AttrString("license_plate", "FVTM").addAccess("external").editable(false).perm("fvtm.attribute.license_plate"));
                attrs.add(new AttrInteger("lug_size", 0).limit(0.0f, 8.0f));
                break;
            }
            case RAIL: {
                attrs.add(new AttrFloat("bogie_front_angle", Float.valueOf(0.0f)).limit(-360.0f, 360.0f));
                attrs.add(new AttrFloat("bogie_rear_angle", Float.valueOf(0.0f)).limit(-360.0f, 360.0f));
                attrs.add(new AttrInteger("gauge", 30).limit(-2.1474836E9f, 2.1474836E9f).editable(false).addAccess("driver"));
                attrs.add(new AttrBoolean("forward", true).editable(false));
                attrs.add(new AttrBoolean("active", false).editable(true));
                attrs.add(new AttrBoolean("paused", false).editable(true));
                attrs.add(new AttrBoolean("doors_left", false).sync(true).group("mirror_lr"));
                attrs.add(new AttrBoolean("doors_right", false).sync(true).group("mirror_lr"));
                attrs.add(new AttrInteger("section_on", 0));
                break;
            }
            case WATER: {
                attrs.add(new AttrBoolean("lights_fog", false).addAccess("driver").sync(true).addIcons("true", "fvtm:textures/gui/icons/lights_fog_on.png", "false", "fvtm:textures/gui/icons/lights_fog_off.png"));
                attrs.add(new AttrBoolean("lights_long", false).addAccess("driver").sync(true).addIcons("true", "fvtm:textures/gui/icons/lights_high_on.png", "false", "fvtm:textures/gui/icons/lights_high_off.png"));
                attrs.add(new AttrBoolean("lights_other", false).addAccess("driver").sync(true));
                attrs.add(new AttrFloat("steering_angle", Float.valueOf(0.0f)).limit(-90.0f, 90.0f));
                attrs.add(new AttrFloat("wheel_angle", Float.valueOf(0.0f)).limit(-360.0f, 360.0f));
                attrs.add(new AttrFloat("max_steering_angle", Float.valueOf(35.0f)).limit(-90.0f, 90.0f).editable(false));
                attrs.add(new AttrFloat("max_towing", Float.valueOf(3500.0f)).limit(1.0f, 2.1474836E9f).editable(false));
                attrs.add(new AttrString("license_plate", "FVTM").addAccess("external").editable(false).perm("fvtm.attribute.license_plate"));
                break;
            }
        }
        return attrs;
    }

    public int minWheels() {
        return 4;
    }
}

