/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fcl.util.ClientPacketPlayer;
import net.fexcraft.mod.fvtm.FVTM4;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.block.Asphalt;
import net.fexcraft.mod.fvtm.block.VehicleLiftEntity;
import net.fexcraft.mod.fvtm.data.InteractZone;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.entity.RailVehicle;
import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.entity.WheelEntity;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.uni.FvtmWorld;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.UniWheel;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.Resources20;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.impl.WorldWI;
import net.fexcraft.mod.uni.packet.PacketListener;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.StateWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;

public class WorldWIE
extends WorldWI
implements FvtmWorld {
    public static AABB aabb = new AABB(-20.0, -20.0, -20.0, 20.0, 20.0, 20.0);
    public static AABB aabb2 = new AABB(-2.0, -2.0, -2.0, 2.0, 2.0, 2.0);

    public WorldWIE(Level world) {
        super(world);
    }

    @Override
    public SeatInstance getSeat(int entid, int seatid) {
        Entity ent = this.level.m_6815_(entid);
        if (ent == null || !(ent instanceof RootVehicle)) {
            return null;
        }
        return ((RootVehicle)ent).vehicle.seats.get(seatid);
    }

    @Override
    public SwivelPoint getSwivelPoint(int entid, String pointid) {
        Entity ent = this.level.m_6815_(entid);
        if (ent == null || !(ent instanceof RootVehicle)) {
            return null;
        }
        return ((RootVehicle)ent).vehicle.data.getRotationPoint(pointid);
    }

    @Override
    public Passenger getPassenger(int source) {
        return (Passenger)UniEntity.getCasted((Object)this.level.m_6815_(source));
    }

    @Override
    public VehicleInstance getVehicle(int entid) {
        Entity ent = this.level.m_6815_(entid);
        if (!(ent instanceof RootVehicle)) {
            return null;
        }
        return ((RootVehicle)ent).vehicle;
    }

    @Override
    public Map.Entry<VehicleData, InteractionHandler.InteractRef> getInteractRef(TagCW packet) {
        if (packet.has("entity")) {
            VehicleInstance inst = this.getVehicle(packet.getInteger("entity"));
            return inst == null ? null : new AbstractMap.SimpleEntry<VehicleData, InteractionHandler.InteractRef>(inst.data, inst.iref());
        }
        V3I pos = new V3I(packet.getIntArray("lift"), 0);
        VehicleLiftEntity tile = (VehicleLiftEntity)this.level.m_7702_(new BlockPos(pos.x, pos.y, pos.z));
        return tile == null ? null : new AbstractMap.SimpleEntry<VehicleData, InteractionHandler.InteractRef>(tile.getVehicleData(), tile.iref());
    }

    @Override
    public boolean noViewEntity() {
        return ClientPacketPlayer.get() == null;
    }

    @Override
    public ArrayList<VehicleInstance> getVehicles(V3D pos) {
        ArrayList<VehicleInstance> list = new ArrayList<VehicleInstance>();
        VehicleInstance inst = null;
        List entities = this.level.m_45933_(null, aabb.m_82386_(pos.x, pos.y, pos.z));
        block0: for (Entity entity : entities) {
            if (!(entity instanceof RootVehicle)) continue;
            inst = ((RootVehicle)entity).vehicle;
            for (InteractZone zone : inst.data.getInteractZones().values()) {
                if (list.contains(inst)) continue block0;
                if (!zone.inRange(inst, pos)) continue;
                list.add(inst);
            }
        }
        return list;
    }

    @Override
    public Map<VehicleData, InteractionHandler.InteractRef> getVehicleDatas(V3D pos) {
        LinkedHashMap<VehicleData, InteractionHandler.InteractRef> map = new LinkedHashMap<VehicleData, InteractionHandler.InteractRef>();
        VehicleInstance inst = null;
        List entities = this.level.m_45933_(null, aabb.m_82386_(pos.x, pos.y, pos.z));
        block0: for (Entity entity : entities) {
            if (!(entity instanceof RootVehicle)) continue;
            inst = ((RootVehicle)entity).vehicle;
            for (InteractZone zone : inst.data.getInteractZones().values()) {
                if (map.containsKey(inst.data)) continue block0;
                if (!zone.inRange(inst, pos)) continue;
                map.put(inst.data, new InteractionHandler.InteractRef(inst));
            }
        }
        int xx = (int)pos.x >> 4;
        int zz = (int)pos.z >> 4;
        for (int x = -1; x < 2; ++x) {
            for (int z = -1; z < 2; ++z) {
                LevelChunk chunk = this.level.m_6325_(xx + x, zz + z);
                block4: for (BlockEntity tile : chunk.m_62954_().values()) {
                    VehicleLiftEntity lift;
                    if (!(tile instanceof VehicleLiftEntity) || (lift = (VehicleLiftEntity)tile).getVehicleData() == null) continue;
                    for (InteractZone zone : lift.getVehicleData().getInteractZones().values()) {
                        if (map.containsKey(lift.getVehicleData())) continue block4;
                        if (!zone.inRange(lift.getVehicleData(), lift.getVehicleDataPos(), pos)) continue;
                        map.put(lift.getVehicleData(), lift.iref());
                    }
                }
            }
        }
        return map;
    }

    @Override
    public Passenger getClientPassenger() {
        return (Passenger)UniEntity.getCasted((Object)ClientPacketPlayer.get());
    }

    @Override
    public boolean isFvtmRoad(StateWrapper state) {
        return state.getBlock() instanceof Asphalt;
    }

    @Override
    public int getRoadHeight(StateWrapper state) {
        if (state.getBlock() instanceof Asphalt) {
            return ((Asphalt)((Object)state.getBlock())).height;
        }
        return 0;
    }

    @Override
    public StateWrapper getRoadWithHeight(StateWrapper block, int height) {
        if (!(block.getBlock() instanceof Asphalt)) {
            ResourceLocation rl = BuiltInRegistries.f_256975_.m_7981_((Object)((Block)block.getBlock()));
            String str = rl.toString();
            str = str.substring(0, str.lastIndexOf("_") + 1);
            return StateWrapper.of((Object)((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(str + height))).m_49966_());
        }
        return StateWrapper.of((Object)Resources20.ASPHALT[height].get().m_49966_());
    }

    @Override
    public void handleBlockEntityPacket(TagCW com, Passenger player) {
        BlockPos pos = BlockPos.m_122022_((long)com.getLong("pos"));
        BlockEntity tile = this.level.m_7702_(pos);
        if (tile instanceof PacketListener) {
            ((PacketListener)tile).handle(com, (EntityW)player);
        } else {
            FvtmLogger.debug((Object)("No receiver for packet '" + String.valueOf(com) + "' found. Dest: " + String.valueOf(pos)));
        }
    }

    @Override
    public void spawnRailEntity(RailEntity ent) {
        this.level.m_7967_((Entity)((RailVehicle)((EntityType)FVTM4.RAILVEH_ENTITY.get()).m_20615_(this.level)).assign(ent));
    }

    @Override
    public void spawnLandEntity(VehicleData data, V3D pos, EntityW placer) {
        RootVehicle veh = (RootVehicle)((EntityType)FVTM4.VEHICLE_ENTITY.get()).m_20615_(this.level);
        veh.m_6034_(pos.x, pos.y, pos.z);
        veh.initVD(data);
        this.level.m_7967_((Entity)veh);
    }

    @Override
    public void spawnLandEntity(VehicleData data, VehicleInstance truck, EntityW placer) {
        RootVehicle veh = (RootVehicle)((EntityType)FVTM4.VEHICLE_ENTITY.get()).m_20615_(this.level);
        veh.vehicle.front = truck;
        truck.rear = veh.vehicle;
        veh.initVD(data);
        veh.vehicle.point.updatePrevAxe();
        veh.vehicle.point.getPivot().copy(truck.point.getPivot());
        veh.m_146884_(((Entity)truck.entity.local()).m_20182_());
        this.level.m_7967_((Entity)veh);
    }

    @Override
    public UniWheel spawnWheel(VehicleInstance vehicle, String id) {
        WheelEntity wheel = new WheelEntity((RootVehicle)((Object)vehicle.entity.local()), id);
        this.level.m_7967_((Entity)wheel);
        return wheel;
    }
}

