/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.ui.UIKeys;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class JunctionTool
extends Item {
    public JunctionTool() {
        super(new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237113_((String)ContainerInterface.translate((String)"&9Junction Editing Toolbox")));
        tooltip.add((Component)Component.m_237113_((String)ContainerInterface.translate((String)"&9- - - - - - &7-")));
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("fvtm:junction")) {
            tooltip.add((Component)Component.m_237113_((String)ContainerInterface.translate((String)("&9Junction Selected: &7" + String.valueOf(new QV3D(TagCW.wrap((Object)stack.m_41783_()), "fvtm:junction"))))));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"No Junction Position Cached."));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Junction junk;
        if (context.m_43725_().f_46443_ || Config.DISABLE_RAILS) {
            return InteractionResult.PASS;
        }
        WorldW world = WrapperHolder.getWorld((Object)context.m_43725_());
        RailSystem railsys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, world);
        if (railsys == null) {
            context.m_43723_().m_213846_(GenericUtils.format("RailSystem not found on this Level."));
            return InteractionResult.FAIL;
        }
        QV3D vector = new QV3D(context.m_43720_().f_82479_, context.m_43720_().f_82480_, context.m_43720_().f_82481_);
        Player player = context.m_43723_();
        Passenger pass = (Passenger)UniEntity.getEntity((Object)player);
        ItemStack stack = player.m_21120_(context.m_43724_());
        if (player.m_6047_()) {
            Junction junc = railsys.getJunction(vector.pos);
            if (junc == null) {
                pass.bar("&cNo junction at position.");
            } else if (junc.size() > 0) {
                pass.bar("&cDisconnect all tracks before removing a Junction.");
            } else {
                railsys.delJunction(vector.pos);
                pass.bar("&c&oRemoving Junction...");
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41783_() == null) {
            stack.m_41751_(new CompoundTag());
        }
        if ((junk = railsys.getJunction(vector.pos, true)) == null) {
            pass.bar("&cNo Junction at this Position.");
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41783_().m_128441_("fvtm:junction")) {
            QV3D cached = new QV3D(TagCW.wrap((Object)stack.m_41783_()), "fvtm:junction");
            if (cached.equals(vector)) {
                pass.openUI(UIKeys.RAIL_JUNCTION, cached.pos.x, cached.pos.y, cached.pos.z);
                return InteractionResult.SUCCESS;
            }
            if (junk.tracks.size() <= 2) {
                stack.m_41783_().m_128473_("fvtm:junction");
                pass.bar("&7&oResetting previous Cached Position.");
            }
        }
        if (junk.tracks.size() < 2) {
            pass.openUI(UIKeys.RAIL_JUNCTION, vector.pos.x, vector.pos.y, vector.pos.z);
        } else {
            vector.write(TagCW.wrap((Object)stack.m_41783_()), "fvtm:junction");
            pass.bar("&a&lJunction Position Cached.");
        }
        return InteractionResult.SUCCESS;
    }
}

