/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.data.part.PartFunction;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.handler.DefaultPartInstallHandler;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class PartItem
extends Item
implements ContentItem.ContentDataItem<Part, PartData>,
ItemTextureable.TextureableItem<Part> {
    private Part part;

    public PartItem(Part content) {
        super(new Item.Properties().m_41487_(1));
        this.part = content;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        PartData data = (PartData)this.getDataFromTag(stack.m_41783_());
        tooltip.add(GenericUtils.format("&9Name: &7" + this.part.getName()));
        tooltip.add(GenericUtils.format("&9Type: &7" + this.part.getCategory()));
        for (String s : this.part.getDescription()) {
            tooltip.add(GenericUtils.format(I18n.m_118938_((String)s, (Object[])new Object[0])));
        }
        if (data == null) {
            return;
        }
        tooltip.add(GenericUtils.format("&9Texture: &7" + this.getTexTitle(data)));
        if (this.part.getInstallHandlerData() != null && this.part.getInstallHandlerData() instanceof DefaultPartInstallHandler.DPIHData) {
            DefaultPartInstallHandler.DPIHData idata = (DefaultPartInstallHandler.DPIHData)this.part.getInstallHandlerData();
            if (!idata.removable) {
                tooltip.add(GenericUtils.format(idata.swappable ? "&c&oPermanent, &a&oSwappable" : "&c&oPermanent"));
            } else {
                tooltip.add(GenericUtils.format(idata.swappable ? "&a&oSwappable" : "&e&oNot Swappable"));
            }
        }
        UniStack uni = UniStack.get((Object)stack);
        if (!data.getFunctions().isEmpty() && uni != null) {
            ArrayList<String> tips = new ArrayList<String>();
            for (PartFunction func : data.getFunctions().values()) {
                func.addInformation(uni.stack, WrapperHolder.getWorld((Object)world), data, tips, flag.m_7050_());
            }
            for (String tip : tips) {
                tooltip.add(GenericUtils.format(tip));
            }
            tooltip.add(GenericUtils.format("&9- - - - - - &7-"));
        }
        if (this.part.getDefaultAttributes().size() > 0) {
            tooltip.add(GenericUtils.format("&0&9This part has &7%s &9Attribute/s.", this.part.getDefaultAttributes().size()));
        }
        if (this.part.getStaticModifiers().size() > 0) {
            tooltip.add(GenericUtils.format("&0&3This part has &7%s &3Modifier/s.", this.part.getStaticModifiers().size()));
        }
        if (this.part.getDefaultFunctions().size() > 0) {
            tooltip.add(GenericUtils.format("&0&bThis part has &7%s &bFunction/s.", this.part.getDefaultFunctions().size()));
        }
        if (this.part.getModel() != null && this.part.getModel().getCreators().size() > 0) {
            tooltip.add(GenericUtils.format("&9Model by:"));
            for (String str : this.part.getModel().getCreators()) {
                tooltip.add(GenericUtils.format("&7- " + str));
            }
        }
    }

    private String getTexTitle(PartData data) {
        if (data.getSelectedTexture() >= 0) {
            return "[" + data.getSelectedTexture() + "] " + ((Part)data.getType()).getDefaultTextures().get(data.getSelectedTexture()).name();
        }
        return data.isTextureExternal() ? "external" : "internal";
    }

    @Override
    public PartData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public PartData getData(TagCW compound) {
        return new PartData(this.part).read(compound);
    }

    @Override
    public Part getContent() {
        return this.part;
    }

    @Override
    public ContentType getType() {
        return ContentType.PART;
    }
}

