/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.JunctionGridItem;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.sys.rail.RailPlacingUtil;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.world.WorldW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class RailGaugeItem
extends Item
implements ContentItem<RailGauge>,
JunctionGridItem {
    private RailGauge gauge;

    public RailGaugeItem(RailGauge railgauge) {
        super(new Item.Properties());
        this.gauge = railgauge;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(GenericUtils.format("&9Name: &7" + this.gauge.getName()));
        for (String s : this.gauge.getDescription()) {
            tooltip.add(GenericUtils.format(ContainerInterface.translate((String)s)));
        }
        tooltip.add(GenericUtils.format("&9Width: &7" + this.gauge.getWidth()));
        if (this.gauge.getCompatible().size() > 0) {
            tooltip.add(GenericUtils.format("&9Compatible with:"));
            for (String str : this.gauge.getCompatible()) {
                tooltip.add(GenericUtils.format("&7 - " + str));
            }
        }
        tooltip.add(GenericUtils.format("&9- - - - - - &7-"));
        if (flag.m_7050_()) {
            tooltip.add(GenericUtils.format("&6Usage:"));
            tooltip.add(GenericUtils.format("&b- Rightclick twice in the same position to create a Junction."));
            tooltip.add(GenericUtils.format("&b- Rightclick in sequence between 2 Junctions to create a track."));
            tooltip.add(GenericUtils.format("&b- Rightclick + Sneak to reset point cache (sequence)."));
        } else {
            tooltip.add(GenericUtils.format("&6Enable advanced tooltips for item usage info."));
        }
        tooltip.add(GenericUtils.format("&9- - - - - - &7-"));
        if (stack.m_41782_() && stack.m_41783_().m_128441_("fvtm:railpoints")) {
            ListTag list = (ListTag)stack.m_41783_().m_128423_("fvtm:railpoints");
            for (int i = 0; i < list.size(); ++i) {
                tooltip.add(GenericUtils.format("&9PT" + i + " POS:" + String.valueOf(new QV3D(TagCW.wrap((Object)list.m_128728_(i)), null))));
            }
        } else {
            tooltip.add(GenericUtils.format("No Connection data."));
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_ || Config.DISABLE_RAILS) {
            return InteractionResult.PASS;
        }
        WorldW world = WrapperHolder.getWorld((Object)context.m_43725_());
        RailSystem railsys = (RailSystem)SystemManager.get(SystemManager.Systems.RAIL, world);
        if (railsys == null) {
            context.m_43723_().m_213846_(GenericUtils.format("RailSystem not found on this Level."));
            return InteractionResult.FAIL;
        }
        QV3D vector = new QV3D(context.m_43720_().f_82479_, context.m_43720_().f_82480_, context.m_43720_().f_82481_);
        RailPlacingUtil.place(railsys, UniEntity.getEntity((Object)context.m_43723_()), this.gauge, vector);
        return InteractionResult.SUCCESS;
    }

    @Override
    public RailGauge getContent() {
        return this.gauge;
    }

    @Override
    public ContentType getType() {
        return ContentType.RAILGAUGE;
    }
}

