/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.data.root.Textureable;
import net.fexcraft.mod.fvtm.data.vehicle.EntitySystem;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.function.part.EngineFunction;
import net.fexcraft.mod.fvtm.function.part.TransmissionFunction;
import net.fexcraft.mod.fvtm.render.ItemRenderers;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.MessageSender;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class VehicleItem
extends Item
implements ContentItem.ContentDataItem<Vehicle, VehicleData>,
ItemTextureable.TextureableItem<Vehicle> {
    private Vehicle vehicle;

    public VehicleItem(Vehicle content) {
        super(new Item.Properties().m_41487_(1));
        this.vehicle = content;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(GenericUtils.format("&9Name: &7" + this.vehicle.getName()));
        for (String s : this.vehicle.getDescription()) {
            tooltip.add(GenericUtils.format(I18n.m_118938_((String)s, (Object[])new Object[0])));
        }
        VehicleData data = (VehicleData)this.getDataFromTag(stack.m_41783_());
        if (data == null) {
            return;
        }
        tooltip.add(GenericUtils.format("&9Texture: &7" + VehicleItem.getTexTitle(data)));
        if (data.hasPart("engine")) {
            tooltip.add(GenericUtils.format("&9Engine: &7" + ((Part)data.getPart("engine").getType()).getName()));
            tooltip.add(GenericUtils.format("&9Fuel Group: &7" + data.getPart("engine").getFunction(EngineFunction.class, "fvtm:engine").getFuelGroup()[0]));
            tooltip.add(GenericUtils.format("&9Fuel Stored: &7" + data.getAttribute("fuel_stored").asInteger() + "mB"));
        }
        if (data.hasPart("transmission")) {
            TransmissionFunction func = (TransmissionFunction)data.getFunctionInPart("transmission", "fvtm:transmission");
            tooltip.add(GenericUtils.format("&9Transmission: &7" + (func == null ? "disfunctional" : (func.isAutomatic() ? "automatic" : "manual"))));
        }
        tooltip.add(GenericUtils.format("&9Weight: &7" + data.getAttribute("weight").asFloat() + "kg"));
        tooltip.add(GenericUtils.format("&9Seats: &7" + data.getSeats().size()));
        tooltip.add(GenericUtils.format("&9LockCode: &7" + data.getLock().getCode()));
        if (this.vehicle.getModel() != null && this.vehicle.getModel().getCreators().size() > 0) {
            tooltip.add(GenericUtils.format("&9Model by:"));
            for (String str : this.vehicle.getModel().getCreators()) {
                tooltip.add(GenericUtils.format("&7- " + str));
            }
        }
    }

    protected static String getTexTitle(Textureable.TextureUser data) {
        if (data.getSelectedTexture() >= 0) {
            return "[" + data.getSelectedTexture() + "] " + data.getTexHolder().getDefaultTextures().get(data.getSelectedTexture()).name();
        }
        return data.isTextureExternal() ? "external" : "internal";
    }

    @Override
    public VehicleData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public VehicleData getData(TagCW compound) {
        return new VehicleData(this.vehicle).read(compound);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.PASS;
        }
        ItemStack stack = context.m_43722_();
        VehicleData data = (VehicleData)this.getDataFromTag(stack.m_41783_());
        EntityW ent = UniEntity.getEntity((Object)context.m_43723_());
        EntitySystem.spawnVehicle((MessageSender)ent, ent.getWorld(), new V3D(context.m_43720_().f_82479_, context.m_43720_().f_82480_, context.m_43720_().f_82481_), data, UniStack.getStack((Object)stack));
        return InteractionResult.SUCCESS;
    }

    @Override
    public Vehicle getContent() {
        return this.vehicle;
    }

    @Override
    public ContentType getType() {
        return ContentType.VEHICLE;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                return (BlockEntityWithoutLevelRenderer)ItemRenderers.VEHICLE_RENDERER.get();
            }
        });
    }
}

