/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.WireType;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.wire.WireSystem;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.EntityW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class WireItem
extends Item
implements ContentItem<WireType> {
    private WireType wire;
    private StackWrapper wrapper = StackWrapper.EMPTY;

    public WireItem(WireType wire) {
        super(new Item.Properties().m_41487_(1));
        this.wire = wire;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add(GenericUtils.format("&9Name: &7" + this.wire.getName()));
        for (String s : this.wire.getDescription()) {
            tooltip.add(GenericUtils.format(I18n.m_118938_((String)s, (Object[])new Object[0])));
        }
        tooltip.add(GenericUtils.format("&9Def. Slack: &7" + this.wire.getDefaultSlack()));
        tooltip.add(GenericUtils.format("&9Customisable: &7" + this.wire.isCustomisable()));
        tooltip.add(GenericUtils.format("&9- &6- &9- - - - &6-"));
        if (stack.m_41782_() && stack.m_41783_().m_128441_("fvtm:wirepoint")) {
            tooltip.add(GenericUtils.format("&9Block: &7" + String.valueOf(stack.m_41783_().m_128465_("fvtm:wirepoint"))));
            tooltip.add(GenericUtils.format("&9Relay: &7" + stack.m_41783_().m_128461_("fvtm:wirepoint_key")));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"No Connection data."));
        }
        tooltip.add(GenericUtils.format("&9- &6- &9- - - - &6-"));
        tooltip.add(GenericUtils.format("&6Usage:"));
        tooltip.add(GenericUtils.format("&b- Rightclick on a relay to select."));
        tooltip.add(GenericUtils.format("&b- Rightclick 2 relays in sequence to create a wire. "));
        tooltip.add(GenericUtils.format("&b- Rightclick + Sneak to reset point cache (sequence)."));
    }

    @Override
    public WireType getContent() {
        return this.wire;
    }

    @Override
    public ContentType getType() {
        return ContentType.WIRE;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43725_().f_46443_ || Config.DISABLE_WIRES || context.m_43724_() != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        WireSystem system = (WireSystem)SystemManager.get(SystemManager.Systems.WIRE, WrapperHolder.getWorld((Object)context.m_43725_()));
        EntityW player = UniEntity.getEntity((Object)context.m_43723_());
        if (system == null) {
            player.send("&cWire System not found. Is it enabled?");
            return InteractionResult.FAIL;
        }
        ItemStack stack = context.m_43723_().m_21205_();
        if (player.isShiftDown()) {
            if (stack.m_41783_() != null && stack.m_41783_().m_128441_("fvtm:wirepoint")) {
                stack.m_41783_().m_128473_("fvtm:wirepoint");
                stack.m_41783_().m_128473_("fvtm:wirepoint_key");
                UniEntity.getEntity((Object)player).send("interact.fvtm.relay.cache_reset");
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }
}

