/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.loaders;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.tmt.JsonToTMT;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.GLObject;
import net.fexcraft.mod.fvtm.model.Model;
import net.fexcraft.mod.fvtm.model.ModelData;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelLoader;

public class JTMTModelLoader
implements ModelLoader {
    @Override
    public boolean accepts(String name, String suffix) {
        return suffix.equals("jtmt") || suffix.equals("frlj");
    }

    @Override
    public Object[] load(String name, ModelData confdata, Supplier<Model> supplier) throws Exception {
        DefaultModel model = (DefaultModel)supplier.get();
        JsonMap map = JsonHandler.parse((InputStream)FvtmResources.INSTANCE.getAssetInputStream(name, true), (boolean)true).asMap();
        if (map.has("creators")) {
            ((List)map.getArray((String)"creators").value).forEach(elm -> model.addToCreators(elm.string_value()));
        }
        model.tex_width = confdata.gsI("TextureWidth", () -> map.getInteger("texture_size_x", 256));
        model.tex_height = confdata.gsI("TextureHeight", () -> map.getInteger("texture_size_y", 256));
        confdata.gsB("SmoothShading", () -> map.getBoolean("smooth_shading", false));
        try {
            if (map.getInteger("format", 2) == 1) {
                JsonMap modelmap = map.getMap("model");
                for (Map.Entry entry : modelmap.entries()) {
                    ModelRendererTurbo[] mrts = JsonToTMT.parse(null, (JsonArray)((JsonValue)entry.getValue()).asArray(), (int)model.tex_width, (int)model.tex_height);
                    ModelGroup group = new ModelGroup((String)entry.getKey());
                    for (ModelRendererTurbo mrt : mrts) {
                        group.add((Polyhedron<GLObject>)new Polyhedron().importMRT(mrt, false, 0.0625f));
                    }
                    model.groups.add(group);
                }
            } else {
                JsonMap modelmap = map.getMap("groups");
                for (Map.Entry entry : modelmap.entries()) {
                    JsonMap group = ((JsonValue)entry.getValue()).asMap();
                    ModelRendererTurbo[] mrts = JsonToTMT.parse(null, (JsonArray)group.get("polygons").asArray(), (int)model.tex_width, (int)model.tex_height);
                    ModelGroup mgroup = new ModelGroup((String)entry.getKey());
                    for (ModelRendererTurbo mrt : mrts) {
                        mgroup.add((Polyhedron<GLObject>)new Polyhedron().importMRT(mrt, false, 0.0625f));
                    }
                    model.groups.add(mgroup);
                    if (!group.has("fvtm:programs")) continue;
                    JsonArray arr = confdata.getArray("Programs", 0);
                    JsonArray array = group.get("fvtm:programs").asArray();
                    for (JsonValue elm2 : (List)array.value) {
                        arr.add((String)entry.getKey() + " " + elm2.string_value());
                    }
                }
            }
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            Static.stop();
        }
        return new Object[]{model, confdata};
    }
}

