/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.model.program;

import java.util.ArrayList;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.tmt.ModelRendererTurbo;
import net.fexcraft.mod.fvtm.model.ModelGroup;
import net.fexcraft.mod.fvtm.model.ModelRenderData;
import net.fexcraft.mod.fvtm.model.Program;
import net.fexcraft.mod.fvtm.render.WireRenderer;
import net.fexcraft.mod.fvtm.sys.wire.Wire;
import net.fexcraft.mod.fvtm.sys.wire.WireKey;
import net.fexcraft.mod.fvtm.sys.wire.WireRelay;
import org.lwjgl.opengl.GL11;

public class WirePrograms {
    public static Program ROTATED = new Program(){

        @Override
        public String id() {
            return "fvtm:wire_rotated";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            GL11.glRotated((double)WireRenderer.ANGLE, (double)0.0, (double)1.0, (double)0.0);
        }
    };

    public static void init() {
        ModelGroup.PROGRAMS.add(new RotateY(0.0f));
        ModelGroup.PROGRAMS.add(ROTATED);
        ModelGroup.PROGRAMS.add(new DownwardAngled(0.0f, false));
        ModelGroup.PROGRAMS.add(new SpacedDeco(new String[0]));
        ModelGroup.PROGRAMS.add(new CatenaryDropper(new String[0]));
    }

    public static class RotateY
    implements Program {
        private float deg;

        public RotateY(float angle) {
            this.deg = angle;
        }

        @Override
        public String id() {
            return "fvtm:wire_rotate_y";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            GL11.glRotatef((float)this.deg, (float)0.0f, (float)1.0f, (float)0.0f);
        }

        @Override
        public Program parse(String[] args) {
            return args.length > 0 ? new RotateY(Float.parseFloat(args[0])) : this;
        }
    }

    public static class DownwardAngled
    implements Program {
        private float length;
        private boolean diswire;

        public DownwardAngled(float length, boolean disable) {
            this.length = length;
            this.diswire = disable;
        }

        @Override
        public String id() {
            return "fvtm:wire_downward_angled";
        }

        @Override
        public void pre(ModelGroup list, ModelRenderData data) {
            GL11.glRotated((double)WireRenderer.ANGLE_DOWN, (double)1.0, (double)0.0, (double)0.0);
        }

        @Override
        public Program parse(String[] args) {
            return new DownwardAngled(args.length > 0 ? Float.parseFloat(args[0]) : 0.0625f, args.length > 1 ? Boolean.parseBoolean(args[1]) : false);
        }

        public float length() {
            return this.length;
        }

        public boolean disable_wire() {
            return this.diswire;
        }
    }

    public static class SpacedDeco
    implements Program {
        protected boolean symmetric;
        protected boolean centered;
        protected float center_spacing = 0.5f;
        protected float ending_spacing = 0.5f;
        protected float between_spacing = 1.0f;
        protected int limit = 0;

        public SpacedDeco(String ... args) {
            block17: for (String arg : args) {
                String[] split = arg.split(":");
                switch (split[0]) {
                    case "symmetric": {
                        this.symmetric = Boolean.parseBoolean(split[1]);
                        continue block17;
                    }
                    case "centered": {
                        this.centered = Boolean.parseBoolean(split[1]);
                        continue block17;
                    }
                    case "start_spacing": 
                    case "center_spacing": {
                        this.center_spacing = Float.parseFloat(split[1]);
                        continue block17;
                    }
                    case "ending_spacing": {
                        this.ending_spacing = Float.parseFloat(split[1]);
                        continue block17;
                    }
                    case "between_spacing": {
                        this.between_spacing = Float.parseFloat(split[1]);
                        continue block17;
                    }
                    case "limit": {
                        this.limit = Integer.parseInt(split[1]);
                    }
                }
            }
        }

        @Override
        public String id() {
            return "fvtm:wire_spaced_deco";
        }

        @Override
        public Program parse(String[] args) {
            return new SpacedDeco(args);
        }

        public ArrayList generate(WireRelay relay, Wire wire, ModelGroup group, String decoid, boolean vecs) {
            ArrayList<Float> list;
            ArrayList<Float> arrayList = list = vecs ? new ArrayList<Float>() : new ArrayList();
            if (this.symmetric) {
                int limit = this.limit * 2;
                float half = wire.length / 2.0f;
                if (this.centered) {
                    for (float pass = half - this.center_spacing; pass > this.ending_spacing && (limit <= 0 || list.size() < limit); pass -= this.between_spacing) {
                        list.add((Float)(vecs ? wire.getVectorPosition(pass, false) : Float.valueOf(pass)));
                        list.add((Float)(vecs ? wire.getVectorPosition(pass, true) : Float.valueOf(pass)));
                    }
                } else {
                    for (float pass = this.ending_spacing; pass < half - this.center_spacing && (limit <= 0 || list.size() < limit); pass += this.between_spacing) {
                        list.add((Float)(vecs ? wire.getVectorPosition(pass, false) : Float.valueOf(pass)));
                        list.add((Float)(vecs ? wire.getVectorPosition(pass, true) : Float.valueOf(pass)));
                    }
                }
            } else {
                for (float pass = this.center_spacing; pass < wire.length - this.ending_spacing && (this.limit <= 0 || list.size() < this.limit); pass += this.between_spacing) {
                    list.add((Float)(vecs ? wire.getVectorPosition(pass, false) : Float.valueOf(pass)));
                }
            }
            return list;
        }
    }

    public static class CatenaryDropper
    extends SpacedDeco {
        public Vec3f[][] model = new Vec3f[4][];
        public float sx = 0.5f;
        public float sz = 0.5f;
        public float sl = 0.0625f;

        public CatenaryDropper(String ... args) {
            super(args);
            block10: for (String arg : args) {
                String[] split = arg.split(":");
                switch (split[0]) {
                    case "width": {
                        this.sx = Float.parseFloat(split[1]);
                        continue block10;
                    }
                    case "depth": {
                        this.sz = Float.parseFloat(split[1]);
                        continue block10;
                    }
                    case "scale": {
                        this.sl = Float.parseFloat(split[1]);
                    }
                }
            }
            float hx = this.sx / 2.0f;
            float hz = this.sz / 2.0f;
            this.model[0] = new Vec3f[]{new Vec3f(-hx, 0.0f, -hz).scale(this.sl), new Vec3f(hx, -hz, 0.0f).scale(this.sl)};
            this.model[1] = new Vec3f[]{new Vec3f(-hx, 0.0f, hz).scale(this.sl), new Vec3f(-hx, -hz, 0.0f).scale(this.sl)};
            this.model[2] = new Vec3f[]{new Vec3f(hx, 0.0f, -hz).scale(this.sl), new Vec3f(hx, 0.0f, hz).scale(this.sl)};
            this.model[3] = new Vec3f[]{new Vec3f(-hx, 0.0f, hz).scale(this.sl), new Vec3f(hx, 0.0f, hz).scale(this.sl)};
        }

        @Override
        public String id() {
            return "fvtm:wire_catenary_dropper";
        }

        @Override
        public Program parse(String[] args) {
            return new CatenaryDropper(args);
        }

        @Override
        public ArrayList generate(WireRelay relay, Wire wire, ModelGroup group, String decoid, boolean bool) {
            ArrayList veclis = super.generate(relay, wire, group, decoid, true);
            if (!relay.getKey().equals("contact")) {
                return veclis;
            }
            WireRelay other = relay.getHolder().relays.get("support");
            if (other == null) {
                return veclis;
            }
            ArrayList dislis = super.generate(relay, wire, group, decoid, false);
            Wire owir = other.getWire(new WireKey(wire.key.start_pos, "support", wire.key.end_pos, "support"));
            if (owir != null) {
                ArrayList<ModelRendererTurbo> tlist = new ArrayList<ModelRendererTurbo>();
                float rat = owir.length / wire.length;
                float last = -1.0f;
                int idx = 0;
                for (Float dis : dislis) {
                    V3D vec = owir.getVectorPosition(dis.floatValue() * rat, last == dis.floatValue());
                    V3D vecl = (V3D)veclis.get(idx);
                    double hei = vec.y - vecl.y;
                    tlist.add(new ModelRendererTurbo(null, 0, 0, 16, 16).addBox(-this.sx / 2.0f, 0.0f, -this.sz / 2.0f, this.sx, (float)hei * 16.0f, this.sz).setRotationPoint(0.0f, (float)(-hei) * 16.0f, 0.0f));
                    last = dis.floatValue();
                    ++idx;
                }
                wire.deco_g.get(decoid).put(group.name, tlist);
            }
            return veclis;
        }
    }
}

