/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.fexcraft.lib.common.Static;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.lib.frl.Polygon;
import net.fexcraft.lib.frl.Polyhedron;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.lib.frl.Vertex;
import net.fexcraft.mod.fvtm.model.GLObject;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;

public class Renderer120
extends Renderer<GLObject> {
    public static final Vector3f AY = new Vector3f(0.0f, 1.0f, 0.0f);
    public static final Vector3f AX = new Vector3f(1.0f, 0.0f, 0.0f);
    public static final Vector3f AZ = new Vector3f(0.0f, 0.0f, 1.0f);
    public static final Vector3f NULLVEC = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vec3f DEFCOLOR = new Vec3f(1.0f, 1.0f, 1.0f);
    private static Vec3f color = new Vec3f();
    private static float alpha;
    public static PoseStack pose;
    private static MultiBufferSource buffer;
    private static VertexConsumer cons;
    protected static RenderType rentype;
    public static int overlay;
    public static int light;

    public static void setColor(RGB col) {
        float[] arr = col.toFloatArray();
        Renderer120.color.x = arr[0];
        Renderer120.color.y = arr[1];
        Renderer120.color.z = arr[2];
        alpha = col.alpha;
    }

    public static void setColor(RGB col, float al) {
        Renderer120.setColor(col);
        alpha = al;
    }

    public static void setColor(Vec3f col) {
        color.copy(col);
    }

    public static void resetColor() {
        Renderer120.color.z = 1.0f;
        Renderer120.color.y = 1.0f;
        Renderer120.color.x = 1.0f;
    }

    public static void rotateDeg(float by, Vector3f axe) {
        pose.m_252781_(new Quaternionf().rotateAxis(Static.toRadians((float)by), (Vector3fc)axe));
    }

    public static void rotateRad(float by, Vector3f axe) {
        pose.m_252781_(new Quaternionf().rotateAxis(by, (Vector3fc)axe));
    }

    public static void rotateDeg(PoseStack pose, float by, Vector3f axe) {
        pose.m_252781_(new Quaternionf().rotateAxis(Static.toRadians((float)by), (Vector3fc)axe));
    }

    public static void rotateRad(PoseStack pose, float by, Vector3f axe) {
        pose.m_252781_(new Quaternionf().rotateAxis(by, (Vector3fc)axe));
    }

    public static void pushPose() {
        pose.m_85836_();
    }

    public static void popPose() {
        pose.m_85849_();
    }

    public static RenderType rentype() {
        return rentype;
    }

    public static MultiBufferSource buffer() {
        return buffer;
    }

    public void render(Polyhedron<GLObject> poly) {
        if (!poly.visible) {
            return;
        }
        pose.m_85836_();
        pose.m_252880_(poly.posX, poly.posY, poly.posZ);
        if (poly.rotX != 0.0f || poly.rotY != 0.0f || poly.rotZ != 0.0f) {
            pose.m_252781_(new Quaternionf().rotateAxis(Static.toRadians((float)poly.rotY), (Vector3fc)AY).rotateAxis(Static.toRadians((float)poly.rotX), (Vector3fc)AX).rotateAxis(Static.toRadians((float)poly.rotZ), (Vector3fc)AZ));
        }
        if (buffer != null) {
            cons = buffer.m_6299_(rentype);
        }
        Matrix4f verma = pose.m_85850_().m_252922_();
        Matrix3f norma = pose.m_85850_().m_252943_();
        for (Polygon poli : poly.polygons) {
            if (rentype.m_173186_() == VertexFormat.Mode.QUADS) {
                for (Vertex vert : poli.vertices) {
                    this.fillVert(verma, norma, vert);
                }
                if (poli.vertices.length >= 4) continue;
                this.fillVert(verma, norma, poli.vertices[2]);
                continue;
            }
            if (poli.vertices.length == 4) {
                this.fillVert(verma, norma, poli.vertices[0]);
                this.fillVert(verma, norma, poli.vertices[1]);
                this.fillVert(verma, norma, poli.vertices[2]);
                this.fillVert(verma, norma, poli.vertices[0]);
                this.fillVert(verma, norma, poli.vertices[2]);
                this.fillVert(verma, norma, poli.vertices[3]);
                continue;
            }
            for (Vertex vert : poli.vertices) {
                this.fillVert(verma, norma, vert);
            }
        }
        pose.m_85849_();
    }

    private void fillVert(Matrix4f verma, Matrix3f norma, Vertex vert) {
        Vector4f vec = verma.transform(new Vector4f(vert.vector.x, vert.vector.y, vert.vector.z, 1.0f));
        Vector3f norm = norma.transform(vert.norm == null ? NULLVEC : new Vector3f(vert.norm.x, vert.norm.y, vert.norm.z));
        cons.m_5954_(vec.x, vec.y, vec.z, Renderer120.color.x, Renderer120.color.y, Renderer120.color.z, alpha, vert.u, vert.v, overlay, light, norm.x, norm.y, norm.z);
    }

    public void delete(Polyhedron<GLObject> poly) {
    }

    public void push() {
        pose.m_85836_();
    }

    public void pop() {
        pose.m_85849_();
    }

    public void translate(double x, double y, double z) {
        pose.m_85837_(x, y, z);
    }

    public void rotate(float deg, int x, int y, int z) {
        Matrix4f mat = new Matrix4f();
        if ((float)x != 0.0f) {
            mat.rotate(deg * 0.0174533f, (Vector3fc)AX);
        }
        if ((float)y != 0.0f) {
            mat.rotate(deg * 0.0174533f, (Vector3fc)AY);
        }
        if ((float)z != 0.0f) {
            mat.rotate(deg * 0.0174533f, (Vector3fc)AZ);
        }
        pose.m_252931_(mat);
    }

    public void scale(double x, double y, double z) {
        pose.m_85841_((float)x, (float)y, (float)z);
    }

    public static void set(PoseStack ps, MultiBufferSource mbs, int lgt, int ol) {
        pose = ps;
        buffer = mbs;
        cons = null;
        light = lgt;
        overlay = ol;
    }

    public static void set(PoseStack ps, MultiBufferSource mbs, int lgt) {
        pose = ps;
        buffer = mbs;
        cons = null;
        light = lgt;
        overlay = OverlayTexture.f_118083_;
    }

    public static void set(PoseStack ps, VertexConsumer con, int lgt, int ol) {
        pose = ps;
        buffer = null;
        cons = con;
        light = lgt;
        overlay = ol;
    }

    public static void set(PoseStack ps, VertexConsumer con, int lgt) {
        pose = ps;
        buffer = null;
        cons = con;
        light = lgt;
        overlay = OverlayTexture.f_118083_;
    }

    static {
        overlay = OverlayTexture.f_118083_;
    }
}

