/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.entity.RoadMarker;
import net.fexcraft.mod.fvtm.model.entity.RoadMarkerModel;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.Renderer120;
import net.fexcraft.mod.fvtm.sys.road.RoadPlacingUtil;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.joml.Quaternionf;
import org.joml.Vector3fc;

public class RoadMarkerRenderer
extends EntityRenderer<RoadMarker> {
    private IDL texture = IDLManager.getIDLCached((String)"fvtm:textures/entity/roadmarker.png");
    public static final RGB CYAN = new RGB(0, 255, 255);

    public RoadMarkerRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.125f;
    }

    public void render(RoadMarker marker, float yaw, float tick, PoseStack pose, MultiBufferSource buffer, int light) {
        pose.m_85836_();
        Renderer120.set(pose, buffer, light);
        FvtmRenderTypes.setCutout(this.texture);
        pose.m_252781_(new Quaternionf().rotateAxis(3.14159f, (Vector3fc)Renderer120.AZ));
        RoadMarkerModel.INST.marker.render();
        if (marker.queueid == null) {
            Renderer120.setColor(RGB.BLACK);
            RoadMarkerModel.INST.arrow.render();
        } else {
            RoadPlacingUtil.NewRoad road = RoadPlacingUtil.QUEUE.get(marker.queueid);
            if (road != null) {
                boolean arrow;
                int index = road.indexOf(marker.position);
                boolean bl = arrow = index == road.selected || index == 0 || index == road.points.size() - 1;
                if (arrow) {
                    Renderer120.setColor(index == road.selected ? CYAN : (index == 0 ? RGB.GREEN : RGB.RED));
                    RoadMarkerModel.INST.arrow.render();
                }
            }
        }
        Renderer120.resetColor();
        pose.m_85849_();
    }

    public ResourceLocation getTextureLocation(RoadMarker entity) {
        return (ResourceLocation)this.texture.local();
    }
}

