/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.render;

import com.mojang.blaze3d.vertex.PoseStack;
import net.fexcraft.lib.frl.Renderer;
import net.fexcraft.mod.fvtm.Config;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.SignData;
import net.fexcraft.mod.fvtm.data.ToolboxType;
import net.fexcraft.mod.fvtm.event.ForgeClientEvents;
import net.fexcraft.mod.fvtm.item.SignItem;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.model.DefaultModel;
import net.fexcraft.mod.fvtm.model.RenderCache;
import net.fexcraft.mod.fvtm.render.FvtmRenderTypes;
import net.fexcraft.mod.fvtm.render.Renderer120;
import net.fexcraft.mod.fvtm.sys.sign.SignInstance;
import net.fexcraft.mod.fvtm.sys.sign.SignSystem;
import net.fexcraft.mod.fvtm.sys.uni.SystemManager;
import net.fexcraft.mod.fvtm.sys.uni.SystemRegion;
import net.fexcraft.mod.fvtm.util.DebugUtils;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import org.joml.Vector3fc;

@Mod.EventBusSubscriber(modid="fvtm", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class SignRenderer {
    private static SignSystem sys;
    private static boolean holding;
    private static BlockPos.MutableBlockPos pos;

    @SubscribeEvent
    public static void renderSigns(RenderLevelStageEvent event) {
        if (Config.DISABLE_SIGNS) {
            return;
        }
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        sys = (SignSystem)SystemManager.get(SystemManager.Systems.SIGN, WrapperHolder.getWorld((Object)event.getCamera().m_90592_().m_9236_()));
        if (sys == null) {
            return;
        }
        Camera camera = event.getCamera();
        double cx = camera.m_90583_().f_82479_;
        double cy = camera.m_90583_().f_82480_;
        double cz = camera.m_90583_().f_82481_;
        PoseStack pose = event.getPoseStack();
        Renderer120.set(pose, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0);
        holding = Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof ToolboxItem && ((ToolboxItem)Minecraft.m_91087_().f_91074_.m_21205_().m_41720_()).var == ToolboxType.SIGN_ADJREM.idx;
        pose.m_85836_();
        pose.m_85837_(-cx, -cy, -cz);
        Renderer120.resetColor();
        for (SystemRegion reg : sys.getRegions().values()) {
            for (SignInstance sign : reg.getObjects().values()) {
                pose.m_85836_();
                pose.m_85837_(sign.vec.vec.x, sign.vec.vec.y, sign.vec.vec.z);
                if (sign.components.size() == 0) {
                    FvtmRenderTypes.setLines();
                    Renderer120.setColor(ForgeClientEvents.ORG);
                    pose.m_85836_();
                    pose.m_85841_(0.5f, 0.5f, 0.5f);
                    DebugUtils.CUBE.render();
                    pose.m_85849_();
                    Renderer120.resetColor();
                } else {
                    if (holding || Minecraft.m_91087_().f_91074_.m_21205_().m_41720_() instanceof SignItem) {
                        FvtmRenderTypes.setLines();
                        pose.m_85836_();
                        Renderer120.setColor(ForgeClientEvents.ORG);
                        pose.m_85841_(0.5f, 0.5f, 0.5f);
                        DebugUtils.CUBE.render();
                        pose.m_85849_();
                        Renderer120.resetColor();
                    }
                    RenderCache cache = sign.getRenderCache();
                    pose.m_252931_(new Matrix4f().rotate(sign.yaw, (Vector3fc)Renderer120.AY));
                    for (SignData scom : sign.components) {
                        if (((Sign)scom.getType()).getModel() == null) {
                            FvtmRenderTypes.setLines();
                            Renderer120.setColor(ForgeClientEvents.ORG);
                            pose.m_85836_();
                            pose.m_85841_(0.5f, 0.5f, 0.5f);
                            DebugUtils.CUBE.render();
                            pose.m_85849_();
                            Renderer120.resetColor();
                            continue;
                        }
                        Renderer120.light = LevelRenderer.m_109541_((BlockAndTintGetter)camera.m_90592_().m_9236_(), (BlockPos)pos.m_122178_(sign.vec.pos.x, sign.vec.pos.y, sign.vec.pos.z));
                        pose.m_85836_();
                        pose.m_85837_(scom.offset.x, scom.offset.y, scom.offset.z);
                        if (scom.roty != 0.0f) {
                            Renderer.RENDERER.rotate(scom.roty, 0, 1, 0);
                        }
                        if (scom.rotz != 0.0f) {
                            Renderer.RENDERER.rotate(scom.rotz, 0, 0, 1);
                        }
                        if (scom.rotx != 0.0f) {
                            Renderer.RENDERER.rotate(scom.rotx, 1, 0, 0);
                        }
                        if (scom.sclx != 1.0f || scom.scly != 1.0f || scom.sclz != 1.0f) {
                            pose.m_85841_(scom.sclx, scom.scly, scom.sclz);
                        }
                        FvtmRenderTypes.setCutout(scom.getTexture().getTexture());
                        ((Sign)scom.getType()).getModel().render(DefaultModel.RENDERDATA.set(scom, sign).rc(cache));
                        pose.m_85849_();
                    }
                }
                pose.m_85849_();
            }
        }
        pose.m_85849_();
    }

    static {
        pos = new BlockPos.MutableBlockPos();
    }
}

