/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.packet.Packets;
import net.fexcraft.mod.fvtm.sys.rail.Compound;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.RailSystem;
import net.fexcraft.mod.fvtm.sys.rail.Track;
import net.fexcraft.mod.fvtm.sys.rail.TrackUnit;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;

public class Section {
    private final long uid;
    private RailSystem data;
    private HashSet<TrackUnit> units = new HashSet();
    public Long reserved;
    public RGB color = RGB.random();

    public Section(RailSystem data, Long sid) {
        this.data = data;
        this.uid = sid == null ? data.getNewSectionId() : sid.longValue();
        FvtmLogger.log((Object)("Created Section [" + String.valueOf(sid == null ? "new/" + this.uid : sid) + "]"));
    }

    public Section fill(TrackUnit ... tracks) {
        for (TrackUnit track : tracks) {
            this.units.add(track);
        }
        return this;
    }

    public Section fill(Collection<TrackUnit> tracks) {
        this.units.addAll(tracks);
        return this;
    }

    public void insert(TrackUnit unit) {
        this.units.add(unit);
    }

    public long getUID() {
        return this.uid;
    }

    public void fuseAtTrack(Track zero) {
        FvtmLogger.log((Object)("Fusing sections at track: " + String.valueOf(zero)));
        Section old = null;
        ArrayList<TrackUnit> list = new ArrayList<TrackUnit>();
        list.add(zero.unit);
        list = this.explore(this.data.getJunction(zero.start.pos), list);
        list = this.explore(this.data.getJunction(zero.end.pos), list);
        for (TrackUnit unit : list) {
            if (unit.getSectionId() == this.uid) continue;
            old = unit.section();
            old.units.remove(unit);
            unit.setSection(this, true);
            FvtmLogger.log((Object)("Added into section '" + this.uid + "': " + String.valueOf(unit)));
            if (old.units.size() != 0) continue;
            this.data.getSections().remove(old.getUID());
            FvtmLogger.log((Object)("Removing section '" + old.getUID() + "'!"));
        }
        this.units.clear();
        this.units.addAll(list);
    }

    public void splitAtTrack(Track track) {
        ArrayList<TrackUnit> less;
        FvtmLogger.log((Object)("Splitting section at track: " + String.valueOf(track)));
        ArrayList<TrackUnit> list0 = new ArrayList<TrackUnit>();
        ArrayList<TrackUnit> list1 = new ArrayList<TrackUnit>();
        list0 = this.explore(this.data.getJunction(track.start.pos), list0);
        list1 = this.explore(this.data.getJunction(track.end.pos), list1);
        for (TrackUnit unit : list0) {
            if (!list1.contains(unit)) continue;
            return;
        }
        ArrayList<TrackUnit> arrayList = less = list0.size() > list1.size() ? list1 : list0;
        if (less.isEmpty()) {
            return;
        }
        Section section = this.data.getSection(null);
        for (TrackUnit unit : less) {
            unit.setSection(section, true);
        }
        this.units.removeAll(less);
        section.units.addAll(less);
        FvtmLogger.log((Object)("Created section '" + section.getUID() + "' and assigned TrackUnits."));
    }

    public void splitAtSignal(Junction junction) {
        ArrayList<TrackUnit> less;
        FvtmLogger.log((Object)("Splitting section at junction: " + String.valueOf(junction)));
        ArrayList<TrackUnit> list0 = new ArrayList<TrackUnit>();
        ArrayList<TrackUnit> list1 = new ArrayList<TrackUnit>();
        list0.add(junction.tracks.get((int)0).unit);
        list1.add(junction.tracks.get((int)1).unit);
        list0 = this.explore(this.data.getJunction(junction.tracks.get((int)0).end.pos), list0);
        list1 = this.explore(this.data.getJunction(junction.tracks.get((int)1).end.pos), list1);
        for (TrackUnit unit : list0) {
            if (!list1.contains(unit)) continue;
            return;
        }
        ArrayList<TrackUnit> arrayList = less = list0.size() > list1.size() ? list1 : list0;
        if (less.isEmpty()) {
            return;
        }
        Section section = this.data.getSection(null);
        for (TrackUnit unit : less) {
            unit.setSection(section, true);
        }
        this.units.removeAll(less);
        section.units.addAll(less);
        FvtmLogger.log((Object)("Created section '" + section.getUID() + "' and assigned TrackUnits."));
    }

    private ArrayList<TrackUnit> explore(Junction junction, ArrayList<TrackUnit> list) {
        if (junction == null) {
            return list;
        }
        ArrayList<Track> tracks = new ArrayList<Track>();
        if (!junction.hasSignal(null)) {
            tracks.addAll(junction.tracks);
        }
        for (Track track : tracks) {
            if (list.contains(track.unit)) continue;
            list.add(track.unit);
            list = this.explore(this.data.getJunction(track.end.pos), list);
        }
        return list;
    }

    public boolean isFree(RailEntity except) {
        return this.isFree(except == null ? null : except.com);
    }

    public boolean isFree(Compound except) {
        for (TrackUnit unit : this.units) {
            if (!unit.hasCompound(except)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.units.size();
    }

    public boolean remove(Track track) {
        return this.units.remove(track.unit);
    }

    public boolean remove(TrackUnit unit) {
        return this.units.remove(unit);
    }

    private void updateClientSections(Junction junction, Section sec0, Section sec1) {
        TagCW com;
        TagCW compound = TagCW.create();
        compound.set("target_listener", "fvtm:railsys");
        compound.set("task", "update_sections");
        TagLW list = TagLW.create();
        if (sec0 != null) {
            for (TrackUnit unit : sec0.units) {
                com = TagCW.create();
                com.set("unit", unit.getUID());
                com.set("section", unit.getSectionId());
                list.add(com);
            }
        }
        if (sec1 != null) {
            for (TrackUnit unit : sec1.units) {
                com = TagCW.create();
                com.set("unit", unit.getUID());
                com.set("section", unit.getSectionId());
                list.add(com);
            }
        }
        compound.set("units", list);
        Packets.sendToAllTrackingPos(Packets.PKT_TAG, ((RailSystem)junction.region.system).getWorld(), junction.getPos().vec, "rail_upd_sections", compound);
    }
}

