/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.rail.cmd;

import java.util.ArrayList;
import net.fexcraft.mod.fvtm.sys.rail.EntryDirection;
import net.fexcraft.mod.fvtm.sys.rail.Junction;
import net.fexcraft.mod.fvtm.sys.rail.RailEntity;
import net.fexcraft.mod.fvtm.sys.rail.cmd.JECType;
import net.fexcraft.mod.fvtm.sys.uni.PathKey;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.tag.TagLW;

public abstract class JEC {
    protected JECType type;
    protected EntryDirection diron;
    protected ArrayList<String> targets = new ArrayList();
    protected String label;
    protected int interval;

    public JEC(String label, JECType type, EntryDirection dir, String ... targets) {
        this.type = type;
        for (String str : targets) {
            this.targets.add(str);
        }
        this.diron = dir;
        this.label = label;
    }

    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        compound.set("Type", this.type.name());
        TagLW list = TagLW.create();
        for (String str : this.targets) {
            list.add(str);
        }
        compound.set("Targets", list);
        compound.set("Data", this.writeData());
        compound.set("EntryDir", (int)((byte)this.diron.ordinal()));
        compound.set("Interval", this.interval);
        compound.set("Label", this.label);
        return compound;
    }

    public JEC(TagCW compound) {
        this.type = JECType.valueOf(compound.getString("Type"));
        TagLW list = (TagLW)compound.getList("Targets").local();
        for (int i = 0; i < list.size(); ++i) {
            this.targets.add(list.getString(i));
        }
        this.readData(compound.getCompound("Data"));
        this.diron = EntryDirection.values()[compound.getInteger("EntryDir")];
        this.interval = compound.getInteger("Interval");
        this.label = compound.getString("Label");
    }

    public static JEC read(TagCW compound) {
        if (compound == null || !compound.has("Type")) {
            return null;
        }
        JECType type = JECType.valueOf(compound.getString("Type"));
        if (type == null) {
            return null;
        }
        try {
            return type.getJCClass().getConstructor(TagCW.class).newInstance(compound);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public abstract JEC copy();

    public abstract TagCW writeData();

    public abstract void readData(TagCW var1);

    public abstract void processEntity(RailEntity var1);

    public abstract void processSwitch(RailEntity var1, Junction var2, PathKey var3, int var4, boolean var5);

    public boolean isTarget(RailEntity entity) {
        if (this.targets.isEmpty()) {
            return true;
        }
        String id = "id:" + entity.uid;
        for (String str : this.targets) {
            if (!entity.lines.contains(str) && !id.equals(str)) continue;
            return true;
        }
        return false;
    }

    public boolean isDone() {
        return this.interval <= -1;
    }
}

