/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.sys.uni;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.data.Seat;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.data.vehicle.SwivelPoint;
import net.fexcraft.mod.fvtm.handler.InteractionHandler;
import net.fexcraft.mod.fvtm.sys.uni.KeyPress;
import net.fexcraft.mod.fvtm.sys.uni.Passenger;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.fvtm.util.Pivot;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.EntityW;

public class SeatInstance {
    public final int index;
    public final VehicleInstance root;
    public final SwivelPoint point;
    public final Seat seat;
    private EntityW passenger;
    public boolean controlmode;
    public Pivot slook;
    public Pivot pslook;
    public Pivot elook;
    public Pivot pelook;
    public float eyaw;
    public float epitch;
    public float peyaw;
    public float pepitch;
    public byte clicktimer;
    public byte interacttimer;
    private ConcurrentHashMap<KeyPress, byte[]> attrkeys = new ConcurrentHashMap();
    private Collection<Attribute> seatattrs;

    public SeatInstance(VehicleInstance veh, int idx) {
        this.root = veh;
        this.index = idx;
        this.seat = veh.data.getSeat(this.index);
        this.point = veh.data.getRotationPoint(this.seat.swivel_point);
        this.seatattrs = this.root.data.getAttributes().values().stream().filter(pr -> (pr.valuetype.isTristate() || pr.valuetype.isNumber()) && pr.access.contains(this.seat.name)).collect(Collectors.toList());
        block0: for (KeyPress key : KeyPress.values()) {
            for (Attribute attr : this.seatattrs) {
                if (attr.getKeyValue(key) == null) continue;
                this.attrkeys.put(key, new byte[]{0});
                continue block0;
            }
        }
        this.resetPivots();
    }

    private void resetPivots() {
        this.pslook = new Pivot();
        this.slook = new Pivot();
        this.pelook = new Pivot();
        this.elook = new Pivot();
        this.slook.set_rotation((this.seat.minyaw + this.seat.maxyaw) / 2.0f, 0.0f, 0.0f, true);
        this.pslook.set_rotation((this.seat.minyaw + this.seat.maxyaw) / 2.0f, 0.0f, 0.0f, true);
    }

    public EntityW passenger() {
        return this.passenger;
    }

    public Object passenger_direct() {
        return this.passenger == null ? null : this.passenger.direct();
    }

    public void passenger(EntityW pass) {
        SeatInstance old;
        if (pass != null && (old = this.root.getSeatOf(pass)) != null && old != this) {
            old.passenger(null);
        }
        this.passenger = pass;
        this.resetPivots();
        this.eyaw = this.peyaw = this.seat.defyaw;
        this.epitch = this.pepitch = this.seat.defpitch;
        this.elook.set_rotation(this.eyaw, this.epitch, 0.0f, true);
        this.pelook.set_rotation(this.peyaw, this.pepitch, 0.0f, true);
        this.slook.set_rotation(this.eyaw, this.epitch, 0.0f, true);
        this.pslook.set_rotation(this.peyaw, this.pepitch, 0.0f, true);
    }

    public void update() {
        if (this.attrkeys.size() > 0) {
            for (byte[] bt : this.attrkeys.values()) {
                if (bt[0] <= 0) continue;
                bt[0] = (byte)(bt[0] - 1);
            }
        }
        if (this.clicktimer > 0) {
            this.clicktimer = (byte)(this.clicktimer - 1);
        }
        if (this.interacttimer > 0) {
            this.interacttimer = (byte)(this.interacttimer - 1);
        }
        if (this.passenger == null) {
            return;
        }
        this.peyaw = this.eyaw;
        this.pepitch = this.epitch;
        this.eyaw = this.elook.deg_yaw() + this.point.getPivot().deg_yaw();
        this.epitch = this.elook.pitch() + this.point.getPivot().deg_pitch();
    }

    public V3D getCurrentLocalPosition() {
        return this.point.getRelativeVector(this.seat.pos);
    }

    public V3D getCurrentGlobalPosition() {
        return this.point.getRelativeVector(this.seat.pos).add(this.root.getV3D());
    }

    public boolean passengerIsPlayer() {
        return this.passenger != null && this.passenger.isPlayer();
    }

    public boolean onKeyPress(KeyPress key, Passenger player) {
        return this.onKeyPress(key, player, false);
    }

    public boolean onKeyPress(KeyPress key, Passenger player, boolean state) {
        if (key == null) {
            return false;
        }
        if (key.control() && this.seat.driver) {
            if (this.clicktimer > 0) {
                return false;
            }
            this.controlmode = !this.controlmode;
            player.bar("fvtm.seat.control_mode." + (this.controlmode ? "on" : "off"));
            this.clicktimer = (byte)(this.clicktimer + 10);
            return true;
        }
        if (key.toggable_input() && this.root.entity.isOnClient()) {
            if (this.clicktimer > 0) {
                return false;
            }
            boolean bool = InteractionHandler.handle(key, this.root.data, this.root.iref(), this, player, StackWrapper.EMPTY);
            this.clicktimer = (byte)(this.clicktimer + 10);
            return bool;
        }
        if ((this.controlmode || !this.seat.driver) && this.root.entity.isOnClient()) {
            if (this.attrKeyPress(key, player)) {
                return true;
            }
            if (this.controlmode) {
                return true;
            }
        } else if (key.dismount() && this.root.entity.isOnClient() && this.passenger != null) {
            this.passenger.dismount();
            return true;
        }
        return this.root.onKeyPress(key, this.seat, player, state, false);
    }

    private boolean attrKeyPress(KeyPress key, Passenger player) {
        if (!this.attrkeys.containsKey((Object)key)) {
            return false;
        }
        if (this.attrkeys.get((Object)key)[0] > 0) {
            return false;
        }
        boolean bool = false;
        for (Attribute attr : this.seatattrs) {
            KeyPress mouse;
            Float val = attr.getKeyValue(key);
            if (val == null) continue;
            KeyPress keyPress = val.floatValue() == 0.0f ? KeyPress.RESET : (mouse = val.floatValue() > 0.0f ? KeyPress.MOUSE_MAIN : KeyPress.MOUSE_RIGHT);
            if (!InteractionHandler.toggle(attr, this.root.data, this.root.iref(), mouse, val, player)) continue;
            bool = true;
        }
        byte[] byArray = this.attrkeys.get((Object)key);
        byArray[0] = (byte)(byArray[0] + 5);
        return bool;
    }
}

