/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JColorChooser;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonHandler;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.SignData;
import net.fexcraft.mod.fvtm.ui.SignContainer;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIField;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class SignEditor
extends UserInterface {
    private SignContainer scon;
    private static ArrayList<String> colors = new ArrayList();
    protected int col_sel;
    protected int com_sel;
    protected SignData sign;

    public SignEditor(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
        this.scon = (SignContainer)con;
    }

    public void init() {
        this.select(0, 0);
    }

    public boolean onAction(UIButton button, String id, int x, int y, int mb) {
        boolean found = true;
        switch (id) {
            case "com_prev": {
                this.select(-1);
                break;
            }
            case "com_next": {
                this.select(1);
                break;
            }
            case "com_rem": {
                TagCW com = TagCW.create();
                com.set("task", "rem");
                com.set("idx", this.com_sel);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "com_copy": {
                TagCW com = TagCW.create();
                com.set("task", "copy");
                com.set("idx", this.com_sel);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "text_cen": {
                TagCW com = TagCW.create();
                com.set("task", "text_center");
                com.set("idx", this.com_sel);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "tex_prev": {
                if (this.com_sel < 0 || this.com_sel >= this.scon.signs.size()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "tex");
                com.set("idx", this.com_sel);
                com.set("sel", this.sign.getTexture().getSelected() - 1 < 0 ? ((Sign)this.sign.getType()).getDefaultTextures().size() - 1 : this.sign.getTexture().getSelected() - 1);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "tex_next": {
                if (this.com_sel < 0 || this.com_sel >= this.scon.signs.size()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "tex");
                com.set("idx", this.com_sel);
                com.set("sel", this.sign.getTexture().getSelected() + 1 < ((Sign)this.sign.getType()).getDefaultTextures().size() ? this.sign.getTexture().getSelected() + 1 : 0);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "ch_prev": {
                if (colors.isEmpty()) {
                    return true;
                }
                --this.col_sel;
                if (this.col_sel < 0) {
                    this.col_sel = colors.size() - 1;
                }
                this.select(this.com_sel, this.col_sel);
                break;
            }
            case "ch_next": {
                if (colors.isEmpty()) {
                    return true;
                }
                ++this.col_sel;
                if (this.col_sel >= colors.size()) {
                    this.col_sel = 0;
                }
                this.select(this.com_sel, this.col_sel);
                break;
            }
            case "rgb": {
                if (this.com_sel < 0 || this.com_sel >= this.scon.signs.size() || colors.isEmpty()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "color");
                com.set("idx", this.com_sel);
                com.set("channel", colors.get(this.col_sel));
                RGB rgb = RGB.WHITE;
                try {
                    String[] arr = ((UIField)this.fields.get("rgb")).text().split("\\,");
                    int r = Integer.parseInt(arr[0].trim());
                    int g = Integer.parseInt(arr[1].trim());
                    int b = Integer.parseInt(arr[2].trim());
                    rgb = new RGB(r, g, b);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                com.set("rgb", rgb.packed);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "hex": {
                if (this.com_sel < 0 || this.com_sel >= this.scon.signs.size() || colors.isEmpty()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "color");
                com.set("idx", this.com_sel);
                com.set("channel", colors.get(this.col_sel));
                RGB rgb = RGB.WHITE;
                try {
                    rgb = new RGB(((UIField)this.fields.get("hex")).text());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                com.set("rgb", rgb.packed);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "colorpicker": {
                if (this.com_sel < 0 || this.com_sel >= this.scon.signs.size() || colors.isEmpty()) {
                    return true;
                }
                try {
                    new Thread(){

                        @Override
                        public void run() {
                            Color color = JColorChooser.showDialog(null, "select color", new Color(SignEditor.this.sign.getColorChannel((String)SignEditor.colors.get((int)SignEditor.this.col_sel)).packed));
                            RGB rgb = new RGB(color.getRGB());
                            byte[] ar = rgb.toByteArray();
                            ((UIField)SignEditor.this.fields.get("rgb")).text(ar[0] + 128 + ", " + (ar[1] + 128) + ", " + (ar[2] + 128));
                            ((UIField)SignEditor.this.fields.get("hex")).text("#" + Integer.toHexString(rgb.packed).substring(2));
                        }
                    }.start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "text_set": {
                if (!((Sign)this.sign.getType()).isText()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "text");
                com.set("idx", this.com_sel);
                com.set("text", ((UIField)this.fields.get("text")).text());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "sign_top": {
                if (!((Sign)this.sign.getType()).isBase()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "side");
                com.set("idx", this.com_sel);
                com.set("side", 0);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "sign_left": {
                if (!((Sign)this.sign.getType()).isBase()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "side");
                com.set("idx", this.com_sel);
                com.set("side", 1);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "sign_right": {
                if (!((Sign)this.sign.getType()).isBase()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "side");
                com.set("idx", this.com_sel);
                com.set("side", 2);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "sign_bot": {
                if (!((Sign)this.sign.getType()).isBase()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "side");
                com.set("idx", this.com_sel);
                com.set("side", 3);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "sign_scale_x": {
                if (!((Sign)this.sign.getType()).isBase()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "width");
                com.set("idx", this.com_sel);
                com.set("val", ((UIField)this.fields.get("scale_x"))._double());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "sign_scale_y": {
                if (!((Sign)this.sign.getType()).isBase()) {
                    return true;
                }
                TagCW com = TagCW.create();
                com.set("task", "height");
                com.set("idx", this.com_sel);
                com.set("val", ((UIField)this.fields.get("scale_y"))._double());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "remove": {
                TagCW com = TagCW.create();
                com.set("task", "rem_all");
                com.set("idx", this.com_sel);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "import": {
                TagCW com = TagCW.create();
                com.set("task", "import");
                com.set("cb", this.root.getClipboard());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                break;
            }
            case "export": {
                JsonArray array = new JsonArray();
                for (SignData sign : this.scon.signs) {
                    array.add((JsonValue)sign.toJson());
                }
                this.root.setClipboard(JsonHandler.toString((JsonValue)array, (JsonHandler.PrintOption)JsonHandler.PrintOption.FLAT));
                break;
            }
            default: {
                found = false;
            }
        }
        if (!found) {
            if (id.startsWith("pos")) {
                int ax = Integer.parseInt(id.substring(3));
                TagCW com = TagCW.create();
                com.set("task", "pos");
                com.set("axis", ax);
                com.set("idx", this.com_sel);
                com.set("value", ((UIField)this.fields.get(id))._double());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            if (id.startsWith("rot")) {
                int ax = Integer.parseInt(id.substring(3));
                TagCW com = TagCW.create();
                com.set("task", "rot");
                com.set("axis", ax);
                com.set("idx", this.com_sel);
                com.set("value", ((UIField)this.fields.get(id))._double());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
            if (id.startsWith("scl")) {
                int ax = Integer.parseInt(id.substring(3));
                TagCW com = TagCW.create();
                com.set("task", "scale");
                com.set("axis", ax);
                com.set("idx", this.com_sel);
                com.set("value", ((UIField)this.fields.get(id))._double());
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
        }
        return found;
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        if (id.startsWith("pos")) {
            int ax = Integer.parseInt(id.substring(3));
            double val = ((UIField)this.fields.get(id))._double();
            ((UIField)this.fields.get("pos" + ax)).text((Number)(val += am > 0 ? -0.01 : 0.01));
            this.onAction(button, id, mx, my, 0);
            return true;
        }
        if (id.startsWith("rot")) {
            int ax = Integer.parseInt(id.substring(3));
            double val = ((UIField)this.fields.get(id))._double();
            ((UIField)this.fields.get("rot" + ax)).text((Number)(val += am > 0 ? -1.0 : 1.0));
            this.onAction(button, id, mx, my, 0);
            return true;
        }
        if (id.startsWith("scl")) {
            int ax = Integer.parseInt(id.substring(3));
            double val = ((UIField)this.fields.get(id))._double();
            ((UIField)this.fields.get("scl" + ax)).text((Number)(val += am > 0 ? -0.01 : 0.01));
            this.onAction(button, id, mx, my, 0);
            return true;
        }
        if (id.equals("sign_scale_x")) {
            double val = ((UIField)this.fields.get("scale_x"))._double();
            ((UIField)this.fields.get("scale_x")).text((Number)(val += am > 0 ? -0.1 : 0.1));
            this.onAction(button, id, mx, my, 0);
        } else if (id.equals("sign_scale_y")) {
            double val = ((UIField)this.fields.get("scale_y"))._double();
            ((UIField)this.fields.get("scale_y")).text((Number)(val += am > 0 ? -0.1 : 0.1));
            this.onAction(button, id, mx, my, 0);
        }
        return false;
    }

    public void select(int i) {
        this.select(this.com_sel += i, this.col_sel);
    }

    public void select(int idx, int colidx) {
        this.com_sel = idx;
        if (this.com_sel < 0) {
            this.com_sel = this.scon.signs.size() - 1;
        }
        if (this.com_sel >= this.scon.signs.size()) {
            this.com_sel = 0;
        }
        colors.clear();
        this.sign = this.com_sel >= this.scon.signs.size() ? null : this.scon.signs.get(this.com_sel);
        boolean miss = this.sign == null;
        for (int i = 0; i < 3; ++i) {
            ((UIField)this.fields.get("pos" + i)).text((Number)(miss ? 0.0 : (i == 0 ? this.sign.offset.x : (i == 1 ? this.sign.offset.y : this.sign.offset.z))));
            ((UIField)this.fields.get("rot" + i)).text((Number)Float.valueOf(miss ? 0.0f : (i == 0 ? this.sign.rotx : (i == 1 ? this.sign.roty : this.sign.rotz))));
            ((UIField)this.fields.get("scl" + i)).text((Number)Float.valueOf(miss ? 0.0f : (i == 0 ? this.sign.sclx : (i == 1 ? this.sign.scly : this.sign.sclz))));
        }
        ((UIText)this.texts.get("texc")).value(miss ? "" : this.sign.getCurrentTexture().name());
        this.col_sel = colidx;
        if (!miss) {
            colors.addAll(((TreeMap)this.sign.getColorChannels()).keySet());
        }
        if (this.col_sel >= colors.size() || this.col_sel < 0) {
            this.col_sel = 0;
        }
        ((UIText)this.texts.get("channel")).value(miss ? "" : (colors.isEmpty() ? "gui.fvtm.decoration_editor.no_color_channels" : colors.get(this.col_sel)));
        ((UIText)this.texts.get("channel")).translate();
        RGB color = miss || colors.isEmpty() ? RGB.WHITE : this.sign.getColorChannel(colors.get(this.col_sel));
        byte[] ar = color.toByteArray();
        ((UIField)this.fields.get("rgb")).text(ar[0] + 128 + ", " + (ar[1] + 128) + ", " + (ar[2] + 128));
        ((UIField)this.fields.get("hex")).text("#" + Integer.toHexString(color.packed));
        ((UIText)this.texts.get("com_sel")).value("ui.fvtm.sign_editor.com_sel");
        ((UIText)this.texts.get("com_sel")).translate(new Object[]{this.com_sel + 1, this.scon.signs.size()});
        ((UIText)this.texts.get("com_name")).value(this.sign == null ? "null" : ((Sign)this.sign.getType()).getName());
        ((UIText)this.texts.get("text_sel")).value("...");
        ((UIText)this.texts.get("sign_sides")).value("...");
        ((UIButton)this.buttons.get((Object)"text_cen")).ecolor.packed = RGB.WHITE.packed;
        ((UIButton)this.buttons.get((Object)"sign_top")).ecolor.packed = RGB.WHITE.packed;
        ((UIButton)this.buttons.get((Object)"sign_bot")).ecolor.packed = RGB.WHITE.packed;
        ((UIButton)this.buttons.get((Object)"sign_left")).ecolor.packed = RGB.WHITE.packed;
        ((UIButton)this.buttons.get((Object)"sign_right")).ecolor.packed = RGB.WHITE.packed;
        ((UIField)this.fields.get("text")).text("");
        ((UIField)this.fields.get("scale_x")).text((Number)0);
        ((UIField)this.fields.get("scale_y")).text((Number)0);
        if (this.sign != null) {
            if (((Sign)this.sign.getType()).isText()) {
                ((UIText)this.texts.get("text_sel")).transval("ui.fvtm.sign_editor.text_sel");
                ((UIField)this.fields.get("text")).text(this.sign.form);
                ((UIButton)this.buttons.get((Object)"text_cen")).ecolor.packed = this.sign.centered ? RGB.GREEN.packed : RGB.BLUE.packed;
            } else {
                ((UIText)this.texts.get("text_sel")).transval("ui.fvtm.sign_editor.text_none");
            }
            if (((Sign)this.sign.getType()).isBase()) {
                ((UIText)this.texts.get("sign_sides")).transval("ui.fvtm.sign_editor.sign_sides");
                ((UIButton)this.buttons.get((Object)"sign_top")).ecolor.packed = this.sign.sides[0] ? RGB.WHITE.packed : RGB.GREEN.packed;
                ((UIButton)this.buttons.get((Object)"sign_left")).ecolor.packed = this.sign.sides[1] ? RGB.WHITE.packed : RGB.GREEN.packed;
                ((UIButton)this.buttons.get((Object)"sign_right")).ecolor.packed = this.sign.sides[2] ? RGB.WHITE.packed : RGB.GREEN.packed;
                ((UIButton)this.buttons.get((Object)"sign_bot")).ecolor.packed = this.sign.sides[3] ? RGB.WHITE.packed : RGB.GREEN.packed;
                ((UIField)this.fields.get("scale_x")).text((Number)Float.valueOf(this.sign.width));
                ((UIField)this.fields.get("scale_y")).text((Number)Float.valueOf(this.sign.height));
            } else {
                ((UIText)this.texts.get("sign_sides")).transval("ui.fvtm.sign_editor.sign_nosides");
            }
        }
    }
}

