/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.vehicle;

import java.util.ArrayList;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.attribute.Attribute;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class VehicleAttributes
extends UserInterface {
    private ArrayList<Attribute<?>> attributes = new ArrayList();
    private VehicleInstance veh = (VehicleInstance)this.container.get("vehicle", new Object[0]);
    private SeatInstance seat;
    private int scroll;
    private int lastveh;

    public VehicleAttributes(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
        this.seat = this.veh.getSeatOf(con.player.entity.direct());
        this.veh.data.getAttributes().values().forEach(attr -> {
            if (this.seat == null) {
                if (attr.external) {
                    this.attributes.add((Attribute<?>)attr);
                }
            } else if (this.seat.seat.driver || attr.access.contains(this.seat.seat.name)) {
                this.attributes.add((Attribute<?>)attr);
            }
        });
        if (this.lastveh != con.pos.x) {
            this.scroll = 0;
        }
        this.lastveh = con.pos.x;
        this.scroll(null);
    }

    public void predraw(float ticks, int mx, int my) {
        int l;
        UIText temp = null;
        for (int k = 0; k < 14 && (l = this.scroll + k) >= 0; ++k) {
            if (l >= this.attributes.size()) {
                ((UIText)this.texts.get("attr_" + k)).visible(false);
                ((UIButton)this.buttons.get("toggle_" + k)).visible(false);
                ((UIButton)this.buttons.get("edit_" + k)).visible(false);
                continue;
            }
            temp = (UIText)this.texts.get("attr_" + k);
            temp.visible(true);
            temp.value(this.attributes.get((int)l).id);
            ((UIButton)this.buttons.get("toggle_" + k)).visible(this.attributes.get((int)l).valuetype.isTristate());
            ((UIButton)this.buttons.get("edit_" + k)).visible(true);
        }
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        TagCW com;
        switch (id) {
            case "up": {
                this.scroll(-1);
                return true;
            }
            case "down": {
                this.scroll(1);
                return true;
            }
            case "filter_all": {
                this.attributes.clear();
                this.veh.data.getAttributes().values().forEach(attr -> this.attributes.add((Attribute<?>)attr));
                this.scroll(0);
                return true;
            }
            case "filter_editable": {
                this.attributes.removeIf(attr -> !attr.editable);
                this.scroll(null);
                return true;
            }
            case "filter_external": {
                this.attributes.clear();
                this.veh.data.getAttributes().values().forEach(attr -> {
                    if (attr.external) {
                        this.attributes.add((Attribute<?>)attr);
                    }
                });
                this.scroll(0);
                return true;
            }
            case "filter_seat": {
                this.attributes.clear();
                if (this.seat == null) {
                    return true;
                }
                this.veh.data.getAttributes().values().forEach(attr -> {
                    if (this.seat.seat.driver || attr.access.contains(this.seat.seat.name)) {
                        this.attributes.add((Attribute<?>)attr);
                    }
                });
                this.scroll(0);
                return true;
            }
        }
        if (id.startsWith("toggle_")) {
            int idx = Integer.parseInt(id.substring(7));
            if (idx + this.scroll >= this.attributes.size()) {
                return true;
            }
            Attribute<?> attr2 = this.attributes.get(this.scroll + idx);
            com = TagCW.create();
            com.set("cargo", "toggle");
            com.set("attr", attr2.id);
            if (!attr2.valuetype.isBoolean() && b != 0) {
                com.set("reset", true);
            }
            com.set("bool", !attr2.asBoolean());
            ContainerInterface.SEND_TO_SERVER.accept(com);
        }
        if (id.startsWith("edit_")) {
            int idx = Integer.parseInt(id.substring(5));
            if (idx + this.scroll >= this.attributes.size()) {
                return true;
            }
            Attribute<?> attr3 = this.attributes.get(this.scroll + idx);
            com = TagCW.create();
            com.set("cargo", "editor");
            com.set("attr", attr3.id);
            ContainerInterface.SEND_TO_SERVER.accept(com);
        }
        return false;
    }

    private void scroll(Integer by) {
        if (by != null) {
            this.scroll += by.intValue();
            if (this.scroll < 0) {
                this.scroll = 0;
            }
            if (this.scroll + 14 >= this.attributes.size()) {
                this.scroll = this.attributes.size() - 14;
            }
        }
        UIText text = (UIText)this.texts.get("scroll");
        text.value("ui.fvtm.vehicle_attributes.scroll");
        text.translate();
        int m = this.scroll + 14;
        if (m > this.attributes.size()) {
            m = this.attributes.size();
        }
        text.value(text.value() + " " + (this.scroll + 1) + "-" + m + "/" + this.attributes.size());
    }

    public boolean onScroll(UIButton button, String id, int mx, int my, int am) {
        this.scroll(am);
        return true;
    }

    public void getTooltip(int mx, int my, List<String> list) {
        UIText text = null;
        for (int i = 0; i < 14; ++i) {
            text = (UIText)this.texts.get("attr_" + i);
            if (!text.visible() || !text.hovered()) continue;
            int j = i + this.scroll;
            if (j < 0 || j >= this.attributes.size()) break;
            Attribute<?> attr = this.attributes.get(j);
            list.add("\u00a76V: \u00a77" + attr.asString());
            if (attr.group != null) {
                list.add("\u00a7bG: \u00a77" + attr.group);
            }
            if (attr.hasPerm()) {
                list.add("\u00a76P: \u00a77" + attr.perm);
            }
            if (attr.editable) continue;
            text.value("ui.fvtm.vehicle_attributes.not_editable");
            text.translate();
            list.add("\u00a7o\u00a7e" + text.value());
            text.value(attr.id);
        }
    }
}

