/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.vehicle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.data.addon.Addon;
import net.fexcraft.mod.fvtm.data.vehicle.CatalogPreset;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.data.vehicle.VehicleData;
import net.fexcraft.mod.fvtm.ui.vehicle.VehicleCatalogCon;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class VehicleCatalog
extends UserInterface {
    protected ArrayList<Addon> vehpacks = new ArrayList();
    protected HashMap<Addon, ArrayList<Vehicle>> vehicles = new LinkedHashMap<Addon, ArrayList<Vehicle>>();
    protected ArrayList<StackWrapper> stacks = new ArrayList();
    protected CatalogPreset preset;
    protected VehicleData data;
    protected Vehicle veh;
    protected int pack;
    protected int vehicle;
    protected int recipe;

    public VehicleCatalog(JsonMap map, ContainerInterface container) throws Exception {
        super(map, container);
        for (Vehicle veh : FvtmRegistry.VEHICLES) {
            if (veh.getCatalog().isEmpty()) continue;
            if (!this.vehpacks.contains(veh.getAddon())) {
                this.vehpacks.add(veh.getAddon());
                this.vehicles.put(veh.getAddon(), new ArrayList());
            }
            this.vehicles.get(veh.getAddon()).add(veh);
        }
        this.switchPack(0);
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        switch (id) {
            case "pack_prev": {
                this.switchPack(-1);
                return true;
            }
            case "pack_next": {
                this.switchPack(1);
                return true;
            }
            case "veh_prev": {
                this.switchVehicle(-1);
                return true;
            }
            case "veh_next": {
                this.switchVehicle(1);
                return true;
            }
            case "var_prev": {
                this.switchRecipe(-1);
                return true;
            }
            case "var_next": {
                this.switchRecipe(1);
                return true;
            }
            case "confirm": {
                TagCW com = TagCW.create();
                com.set("veh", this.veh.getIDS());
                com.set("rec", this.veh.getCatalog().get((int)this.recipe).id);
                ContainerInterface.SEND_TO_SERVER.accept(com);
                return true;
            }
        }
        return false;
    }

    private void switchPack(int i) {
        this.pack += i;
        if (this.pack >= this.vehpacks.size()) {
            this.pack = 0;
        }
        if (this.pack < 0) {
            this.pack = this.vehpacks.size() - 1;
        }
        ((UIText)this.texts.get("pack")).value(this.vehpacks.get(this.pack).getName());
        this.switchVehicle(0);
    }

    private void switchVehicle(int i) {
        this.vehicle += i;
        ArrayList<Vehicle> vehs = this.vehicles.get(this.vehpacks.get(this.pack));
        if (this.vehicle >= vehs.size()) {
            this.vehicle = 0;
        }
        if (this.vehicle < 0) {
            this.vehicle = vehs.size() - 1;
        }
        this.veh = vehs.get(this.vehicle);
        ((UIText)this.texts.get("vehicle")).value(this.veh.getName());
        this.switchRecipe(0);
    }

    private void switchRecipe(int i) {
        this.recipe += i;
        if (this.recipe >= this.veh.getCatalog().size()) {
            this.recipe = 0;
        }
        if (this.recipe < 0) {
            this.recipe = this.veh.getCatalog().size() - 1;
        }
        this.preset = this.veh.getCatalog().get(this.recipe);
        this.data = this.preset.getVehicleData();
        ((UIText)this.texts.get("desc0")).value(this.preset.name);
        ((UIText)this.texts.get("desc1")).value(this.preset.getDesc(0));
        ((UIText)this.texts.get("desc2")).value(this.preset.getDesc(1));
        if (this.preset.desc.isEmpty()) {
            ((UIText)this.texts.get("desc1")).translate();
        }
        ((UIText)this.texts.get("variant")).value("ui.fvtm.vehicle_catalog.variant");
        ((UIText)this.texts.get("variant")).translate(new Object[]{this.recipe + 1, this.veh.getCatalog().size()});
        VehicleCatalogCon cfr_ignored_0 = (VehicleCatalogCon)this.container;
        this.stacks = VehicleCatalogCon.parseStacks(this.preset);
    }

    public void postdraw(float ticks, int mx, int my) {
        for (int x = 0; x < 5; ++x) {
            int z;
            for (int y = 0; y < 4 && (z = x + y * 5) < this.stacks.size(); ++y) {
                this.drawer.draw(this.gLeft + 146 + x * 18, this.gTop + 25 + y * 18, this.stacks.get(z), true);
            }
        }
    }

    public void getTooltip(int mx, int my, List<String> list) {
        int x;
        int y;
        int z;
        if (mx >= this.gLeft + 145 && mx <= this.gLeft + 235 && my >= this.gTop + 24 && my <= this.gTop + 96 && (z = (y = (my - this.gTop - 24) / 18) * 5 + (x = (mx - this.gLeft - 145) / 18)) >= 0 && z < this.stacks.size()) {
            list.add(this.stacks.get(z).getName());
        }
    }
}

