/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.vehicle;

import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.V3I;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.vehicle.CatalogPreset;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.uni.UniEntity;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;

public class VehicleCatalogCon
extends ContainerInterface {
    public VehicleCatalogCon(JsonMap map, UniEntity ply, V3I pos) {
        super(map, ply, pos);
    }

    public void packet(TagCW com, boolean client) {
        if (client) {
            return;
        }
        try {
            Vehicle veh = FvtmRegistry.VEHICLES.get(com.getString("veh"));
            CatalogPreset preset = veh.getCatalogEntry(com.getString("rec"));
            if (this.player.entity.isCreative() || this.canCraft(VehicleCatalogCon.parseStacks(preset))) {
                if (!this.player.entity.isCreative()) {
                    this.doCraft(VehicleCatalogCon.parseStacks(preset));
                }
                this.player.entity.addStack(preset.getVehicleData().newItemStack());
                this.player.entity.send("ui.fvtm.vehicle_catalog.craft_success");
                this.player.entity.closeUI();
            }
        }
        catch (Exception e) {
            this.player.entity.send("error, see log for details");
            e.printStackTrace();
        }
    }

    public static ArrayList parseStacks(CatalogPreset preset) {
        ArrayList<StackWrapper> stacks = new ArrayList<StackWrapper>();
        for (Map.Entry<String, Integer> entry : preset.recipe.entrySet()) {
            StackWrapper stack = FvtmResources.newStack(FvtmRegistry.getItem(entry.getKey()));
            stack.count(entry.getValue().intValue());
            stacks.add(stack);
        }
        return stacks;
    }

    private boolean canCraft(ArrayList<StackWrapper> stacks) {
        for (StackWrapper stack : stacks) {
            if (!stack.empty()) continue;
            this.player.entity.send("ui.fvtm.vehicle_catalog.craft_invalid");
            return false;
        }
        ArrayList<StackWrapper> copy = new ArrayList<StackWrapper>();
        for (int idx = 0; idx < this.player.entity.getInventorySize(); ++idx) {
            StackWrapper wrp = this.player.entity.getStackAt(idx);
            if (wrp.empty()) continue;
            copy.add(wrp.copy());
        }
        for (StackWrapper stack : stacks) {
            int am;
            if (this.consume(copy, stack, am = stack.count()) >= am) continue;
            this.player.entity.send("ui.fvtm.vehicle_catalog.craft_not_enough", new Object[]{stack.getName()});
            return false;
        }
        stacks.removeIf(StackWrapper::empty);
        return true;
    }

    private int consume(ArrayList<StackWrapper> copy, StackWrapper stack, int am) {
        int cons = 0;
        for (StackWrapper wrp : copy) {
            if (!wrp.equals(stack)) continue;
            wrp.count(wrp.count() - am);
            if ((cons += wrp.count()) < am) continue;
            break;
        }
        copy.removeIf(StackWrapper::empty);
        return cons;
    }

    private void doCraft(ArrayList<StackWrapper> stacks) {
        ArrayList<StackWrapper> copy = new ArrayList<StackWrapper>();
        for (int idx = 0; idx < this.player.entity.getInventorySize(); ++idx) {
            StackWrapper wrp = this.player.entity.getStackAt(idx);
            if (wrp.empty()) continue;
            copy.add(wrp);
        }
        for (StackWrapper stack : stacks) {
            if (stack.empty()) continue;
            this.consume(copy, stack, stack.count());
        }
    }
}

