/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.ui.vehicle;

import java.util.ArrayList;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.lib.common.math.RGB;
import net.fexcraft.mod.fvtm.data.inv.FvtmInv;
import net.fexcraft.mod.fvtm.data.part.PartData;
import net.fexcraft.mod.fvtm.function.part.InventoryFunction;
import net.fexcraft.mod.fvtm.sys.uni.SeatInstance;
import net.fexcraft.mod.fvtm.sys.uni.VehicleInstance;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.ui.ContainerInterface;
import net.fexcraft.mod.uni.ui.UIButton;
import net.fexcraft.mod.uni.ui.UIText;
import net.fexcraft.mod.uni.ui.UserInterface;

public class VehicleInventories
extends UserInterface {
    private ArrayList<FvtmInv> inventories = new ArrayList();
    private ArrayList<String> inv_names = new ArrayList();
    private RGB[] colors = new RGB[8];
    private VehicleInstance vehicle = (VehicleInstance)this.container.get("vehicle", new Object[0]);
    private int page;

    public VehicleInventories(JsonMap map, ContainerInterface con) throws Exception {
        super(map, con);
        SeatInstance seat = this.vehicle.getSeatOf(con.player.entity.direct());
        for (int i = 0; i < this.vehicle.data.getVehInvKeys().size(); ++i) {
            this.inventories.add(this.vehicle.data.getVehInventories().get(i));
            this.inv_names.add(this.vehicle.data.getVehInvKeys().get(i));
        }
        for (Map.Entry<String, PartData> entry : this.vehicle.data.getParts().entrySet()) {
            InventoryFunction inv = (InventoryFunction)entry.getValue().getFunction("fvtm:inventory");
            if (inv == null || inv.inventory().type.isContainer() || !(seat == null ? inv.access().contains(this.vehicle.data.getLock().isLocked() ? "external-locked" : "external") : seat.seat.driver || inv.access().contains(seat.seat.name))) continue;
            this.inventories.add(inv.inventory());
            this.inv_names.add(entry.getKey());
        }
        for (int i = 0; i < 8; ++i) {
            this.colors[i] = RGB.WHITE;
        }
        this.updatePage(0);
    }

    public void drawbackground(float ticks, int mx, int my) {
        for (int i = 0; i < 8; ++i) {
            this.drawer.apply(this.colors[i]);
            this.drawer.draw((float)(this.gLeft + 175), (float)(this.gTop + 17 + 14 * i), 175, 17 + 14 * i, 12, 12);
            this.drawer.applyWhite();
        }
    }

    public boolean onAction(UIButton button, String id, int x, int y, int b) {
        if (id.equals("next")) {
            this.updatePage(1);
        } else if (id.equals("prev")) {
            this.updatePage(-1);
        } else if (id.startsWith("inv_")) {
            int idx = Integer.parseInt(id.substring(4));
            if (idx < 0 || idx + this.page * 8 >= this.inventories.size()) {
                return true;
            }
            TagCW com = TagCW.create();
            com.set("open", this.inv_names.get(idx + this.page * 8));
            ContainerInterface.SEND_TO_SERVER.accept(com);
        }
        return true;
    }

    public void scrollwheel(int am, int x, int y) {
        this.updatePage(am > 0 ? -1 : 1);
    }

    private void updatePage(int i) {
        this.page += i;
        if (this.page < 0) {
            this.page = 0;
        }
        for (int j = 0; j < 8; ++j) {
            int k = j + this.page * 8;
            boolean bool = k >= this.inventories.size();
            ((UIText)this.texts.get("inv_" + j)).value(bool ? "" : this.inv_names.get(k));
            ((UIButton)this.buttons.get("inv_" + j)).enabled(!bool);
            this.colors[j] = !bool ? this.inventories.get((int)k).type.color : RGB.WHITE;
        }
    }
}

