/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

public class Matrix {
    public float[] m0 = new float[4];
    public float[] m1 = new float[4];
    public float[] m2 = new float[4];

    public Matrix() {
        this.reset();
    }

    public void reset() {
        int i;
        for (i = 0; i < 4; ++i) {
            this.m0[i] = 0.0f;
        }
        for (i = 0; i < 4; ++i) {
            this.m1[i] = 0.0f;
        }
        for (i = 0; i < 4; ++i) {
            this.m2[i] = 0.0f;
        }
        this.m2[2] = 1.0f;
        this.m1[1] = 1.0f;
        this.m0[0] = 1.0f;
    }

    public void rotate(float am, float x, float y, float z) {
        float cos = (float)Math.cos(am);
        float sin = (float)Math.sin(am);
        float con = 1.0f - cos;
        float mxy = x * y;
        float mxz = x * z;
        float myz = y * z;
        float six = sin * x;
        float siy = sin * y;
        float siz = sin * z;
        float cx = x * x * con + cos;
        float cy = y * y * con + cos;
        float cz = z * z * con + cos;
        float c0y = mxy * con + siz;
        float c0z = mxz * con - siy;
        float c1x = mxy * con - siz;
        float c1z = myz * con + six;
        float c2x = mxz * con + siy;
        float c2y = myz * con - six;
        float[] tmp = new float[]{this.m0[0] * cx + this.m1[0] * c0y + this.m2[0] * c0z, this.m0[1] * cx + this.m1[1] * c0y + this.m2[1] * c0z, this.m0[2] * cx + this.m1[2] * c0y + this.m2[2] * c0z, this.m0[3] * cx + this.m1[3] * c0y + this.m2[3] * c0z, this.m0[0] * c1x + this.m1[0] * cy + this.m2[0] * c1z, this.m0[1] * c1x + this.m1[1] * cy + this.m2[1] * c1z, this.m0[2] * c1x + this.m1[2] * cy + this.m2[2] * c1z, this.m0[3] * c1x + this.m1[3] * cy + this.m2[3] * c1z};
        this.m2[0] = this.m0[0] * c2x + this.m1[0] * c2y + this.m2[0] * cz;
        this.m2[1] = this.m0[1] * c2x + this.m1[1] * c2y + this.m2[1] * cz;
        this.m2[2] = this.m0[2] * c2x + this.m1[2] * c2y + this.m2[2] * cz;
        this.m2[3] = this.m0[3] * c2x + this.m1[3] * c2y + this.m2[3] * cz;
        this.m0[0] = tmp[0];
        this.m0[1] = tmp[1];
        this.m0[2] = tmp[2];
        this.m0[3] = tmp[3];
        this.m1[0] = tmp[4];
        this.m1[1] = tmp[5];
        this.m1[2] = tmp[6];
        this.m1[3] = tmp[7];
    }

    public void rotateX(float am, float x) {
        float cos = (float)Math.cos(am);
        float sin = (float)Math.sin(am);
        float con = 1.0f - cos;
        float six = sin * x;
        float cx = x * x * con + cos;
        float[] tmp = new float[]{this.m0[0] * cx, this.m0[1] * cx, this.m0[2] * cx, this.m0[3] * cx, this.m1[0] * cos + this.m2[0] * six, this.m1[1] * cos + this.m2[1] * six, this.m1[2] * cos + this.m2[2] * six, this.m1[3] * cos + this.m2[3] * six};
        this.m2[0] = this.m1[0] * -six + this.m2[0] * cos;
        this.m2[1] = this.m1[1] * -six + this.m2[1] * cos;
        this.m2[2] = this.m1[2] * -six + this.m2[2] * cos;
        this.m2[3] = this.m1[3] * -six + this.m2[3] * cos;
        this.m0[0] = tmp[0];
        this.m0[1] = tmp[1];
        this.m0[2] = tmp[2];
        this.m0[3] = tmp[3];
        this.m1[0] = tmp[4];
        this.m1[1] = tmp[5];
        this.m1[2] = tmp[6];
        this.m1[3] = tmp[7];
    }

    public void rotateY(float am, float y) {
        float cos = (float)Math.cos(am);
        float sin = (float)Math.sin(am);
        float con = 1.0f - cos;
        float siy = sin * y;
        float cy = y * y * con + cos;
        float[] tmp = new float[]{this.m0[0] * cos + this.m2[0] * -siy, this.m0[1] * cos + this.m2[1] * -siy, this.m0[2] * cos + this.m2[2] * -siy, this.m0[3] * cos + this.m2[3] * -siy, this.m1[0] * cy, this.m1[1] * cy, this.m1[2] * cy, this.m1[3] * cy};
        this.m2[0] = this.m0[0] * siy + this.m2[0] * cos;
        this.m2[1] = this.m0[1] * siy + this.m2[1] * cos;
        this.m2[2] = this.m0[2] * siy + this.m2[2] * cos;
        this.m2[3] = this.m0[3] * siy + this.m2[3] * cos;
        this.m0[0] = tmp[0];
        this.m0[1] = tmp[1];
        this.m0[2] = tmp[2];
        this.m0[3] = tmp[3];
        this.m1[0] = tmp[4];
        this.m1[1] = tmp[5];
        this.m1[2] = tmp[6];
        this.m1[3] = tmp[7];
    }

    public void rotateZ(float am, float z) {
        float cos = (float)Math.cos(am);
        float sin = (float)Math.sin(am);
        float con = 1.0f - cos;
        float siz = sin * z;
        float cz = z * z * con + cos;
        float[] tmp = new float[]{this.m0[0] * cos + this.m1[0] * siz, this.m0[1] * cos + this.m1[1] * siz, this.m0[2] * cos + this.m1[2] * siz, this.m0[3] * cos + this.m1[3] * siz, this.m0[0] * -siz + this.m1[0] * cos, this.m0[1] * -siz + this.m1[1] * cos, this.m0[2] * -siz + this.m1[2] * cos, this.m0[3] * -siz + this.m1[3] * cos};
        this.m2[0] = this.m2[0] * cz;
        this.m2[1] = this.m2[1] * cz;
        this.m2[2] = this.m2[2] * cz;
        this.m2[3] = this.m2[3] * cz;
        this.m0[0] = tmp[0];
        this.m0[1] = tmp[1];
        this.m0[2] = tmp[2];
        this.m0[3] = tmp[3];
        this.m1[0] = tmp[4];
        this.m1[1] = tmp[5];
        this.m1[2] = tmp[6];
        this.m1[3] = tmp[7];
    }
}

