/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.UUID;
import java.util.function.Supplier;
import net.fexcraft.mod.fcl.util.ExternalTextures;
import net.fexcraft.mod.fvtm.FVTM4;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.block.Asphalt;
import net.fexcraft.mod.fvtm.block.ConstructorBlock;
import net.fexcraft.mod.fvtm.block.FuelFillerBlock;
import net.fexcraft.mod.fvtm.block.VehicleLiftBlock;
import net.fexcraft.mod.fvtm.data.Consumable;
import net.fexcraft.mod.fvtm.data.Decoration;
import net.fexcraft.mod.fvtm.data.Material;
import net.fexcraft.mod.fvtm.data.RailGauge;
import net.fexcraft.mod.fvtm.data.Sign;
import net.fexcraft.mod.fvtm.data.ToolboxType;
import net.fexcraft.mod.fvtm.data.WireType;
import net.fexcraft.mod.fvtm.data.part.Part;
import net.fexcraft.mod.fvtm.data.vehicle.Vehicle;
import net.fexcraft.mod.fvtm.entity.RailMarker;
import net.fexcraft.mod.fvtm.entity.RoadMarker;
import net.fexcraft.mod.fvtm.item.ConsumableItem;
import net.fexcraft.mod.fvtm.item.DecorationItem;
import net.fexcraft.mod.fvtm.item.JunctionTool;
import net.fexcraft.mod.fvtm.item.MaterialItem;
import net.fexcraft.mod.fvtm.item.PartItem;
import net.fexcraft.mod.fvtm.item.RailGaugeItem;
import net.fexcraft.mod.fvtm.item.RoadToolItem;
import net.fexcraft.mod.fvtm.item.SignItem;
import net.fexcraft.mod.fvtm.item.ToolboxItem;
import net.fexcraft.mod.fvtm.item.VehicleItem;
import net.fexcraft.mod.fvtm.item.WireItem;
import net.fexcraft.mod.fvtm.model.Transforms;
import net.fexcraft.mod.fvtm.model.program.ConditionalPrograms;
import net.fexcraft.mod.fvtm.model.program.DefaultPrograms20;
import net.fexcraft.mod.fvtm.render.Transforms120;
import net.fexcraft.mod.fvtm.util.QV3D;
import net.fexcraft.mod.fvtm.util.TransformMap;
import net.fexcraft.mod.uni.FclRecipe;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.impl.IWI;
import net.fexcraft.mod.uni.impl.IWR;
import net.fexcraft.mod.uni.impl.SWI;
import net.fexcraft.mod.uni.inv.ItemWrapper;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.world.WorldW;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class Resources20
extends FvtmResources {
    public static Supplier<RoadToolItem> ROAD_TOOL_ITEM;
    public static Supplier<ToolboxItem>[] TOOLBOX;
    public static Supplier<JunctionTool> JUNCTION_TOOl;
    public static Supplier<Asphalt>[] ASPHALT;
    public static Supplier<BlockItem>[] ASPHALT_ITEM;
    public static Supplier<VehicleLiftBlock> LIFT_BLOCK;
    public static Supplier<BlockItem> LIFT_BLOCK_ITEM;
    public static Supplier<ConstructorBlock> CONST_BLOCK;
    public static Supplier<FuelFillerBlock> FUELFILLER_BLOCK;
    public static Supplier<BlockItem> CONST_BLOCK_ITEM;
    public static Supplier<BlockItem> FUELFILLER_ITEM;

    @Override
    public void searchASMPacks() {
    }

    @Override
    public boolean searchPacksInResourcePacks() {
        return true;
    }

    @Override
    public void loadPackTextures() {
    }

    @Override
    public void createContentBlocks() {
        FvtmRegistry.BLOCKS.forEach(block -> FVTM4.BLOCK_REGISTRY.get(block.getID().space()).register(block.getID().id(), () -> (Block)block.genBlock()));
    }

    @Override
    public void createContentItems() {
        FvtmRegistry.MATERIALS.forEach(mat -> mat.setItemWrapper(this.wrapwrapper(mat.getID(), () -> new MaterialItem((Material)mat))));
        FvtmRegistry.CONSUMABLES.forEach(con -> con.setItemWrapper(this.wrapwrapper(con.getID(), () -> new ConsumableItem((Consumable)con))));
        FvtmRegistry.PARTS.forEach(part -> part.setItemWrapper(this.wrapwrapper(part.getID(), () -> new PartItem((Part)part))));
        FvtmRegistry.VEHICLES.forEach(veh -> veh.setItemWrapper(this.wrapwrapper(veh.getID(), () -> new VehicleItem((Vehicle)veh))));
        FvtmRegistry.BLOCKS.forEach(blk -> blk.setItemWrapper(this.wrapwrapper(blk.getID(), () -> {
            FvtmRegistry.CONTENT_BLOCKS.put(blk.getID(), blk.getBlock());
            return new net.fexcraft.mod.fvtm.item.BlockItem((net.fexcraft.mod.fvtm.data.block.Block)blk);
        })));
        FvtmRegistry.DECORATIONS.forEach(veh -> veh.setItemWrapper(this.wrapwrapper(veh.getID(), () -> new DecorationItem((Decoration)veh))));
        FvtmRegistry.RAILGAUGES.forEach(rg -> rg.setItemWrapper(this.wrapwrapper(rg.getID(), () -> new RailGaugeItem((RailGauge)rg))));
        FvtmRegistry.WIRES.forEach(wire -> wire.setItemWrapper(this.wrapwrapper(wire.getID(), () -> new WireItem((WireType)wire))));
        FvtmRegistry.SIGNS.forEach(sign -> sign.setItemWrapper(this.wrapwrapper(sign.getID(), () -> new SignItem((Sign)sign))));
    }

    @Override
    public void registerFvtmRecipes() {
        String blockcat = "recipe.fvtm.blocks";
        FclRecipe.newBuilder((String)blockcat).output((Object)new ItemStack((ItemLike)CONST_BLOCK_ITEM.get())).add((Object)new ItemStack((ItemLike)Blocks.f_50075_)).add((Object)new ItemStack((ItemLike)Items.f_42351_, 4)).add((Object)new ItemStack((ItemLike)Items.f_42350_, 8)).add((Object)new ItemStack((ItemLike)Items.f_42451_, 16)).add((Object)new ItemStack((ItemLike)Items.f_42517_, 2)).add((Object)new ItemStack((ItemLike)Blocks.f_50164_, 8)).register();
        FclRecipe.newBuilder((String)blockcat).output((Object)new ItemStack((ItemLike)LIFT_BLOCK_ITEM.get())).add((Object)new ItemStack((ItemLike)Blocks.f_50075_, 2)).add((Object)new ItemStack((ItemLike)Items.f_42416_, 8)).add((Object)new ItemStack((ItemLike)Items.f_42351_, 2)).add((Object)new ItemStack((ItemLike)Items.f_42350_, 4)).add((Object)new ItemStack((ItemLike)Items.f_42451_, 4)).add((Object)new ItemStack((ItemLike)Items.f_42517_, 1)).add((Object)new ItemStack((ItemLike)Blocks.f_50164_, 2)).add((Object)new ItemStack((ItemLike)Blocks.f_50039_, 2)).register();
        FclRecipe.newBuilder((String)blockcat).output((Object)new ItemStack((ItemLike)FUELFILLER_ITEM.get())).add((Object)new ItemStack((ItemLike)Blocks.f_50075_)).add((Object)new ItemStack((ItemLike)Blocks.f_50332_, 2)).add((Object)new ItemStack((ItemLike)Blocks.f_50124_, 4)).register();
    }

    private ItemWrapper wrapwrapper(IDL id, Supplier<Item> item) {
        if (FvtmRegistry.CONTENT_ITEMS.containsKey(id)) {
            return FvtmRegistry.CONTENT_ITEMS.get(id);
        }
        IWR iwr = new IWR((Supplier)FVTM4.ITEM_REGISTRY.get(id.space()).register(id.id(), item));
        FvtmRegistry.CONTENT_ITEMS.put(id, (ItemWrapper)iwr);
        FvtmRegistry.ITEMS.put(id.colon(), (ItemWrapper)iwr);
        return iwr;
    }

    @Override
    public ItemWrapper getItemWrapper(String id) {
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(id));
        return item == null ? null : new IWI(item);
    }

    @Override
    public StackWrapper newStack0(ItemWrapper item) {
        return SWI.parse((Object)item);
    }

    @Override
    public void initModelPrograms() {
        Transforms.GET_TRANSFORM = args -> {
            switch (args[0]) {
                case "translation": 
                case "translate": 
                case "trans": 
                case "tra": 
                case "tr": {
                    return new Transforms120.TF_Translate(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]));
                }
                case "rotation": 
                case "rotate": 
                case "rot": {
                    return new Transforms120.TF_Rotate(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]), Float.parseFloat(args[4]));
                }
                case "scale": {
                    if (((String[])args).length < 3) {
                        float scale = Float.parseFloat(args[1]);
                        return new Transforms120.TF_Scale(scale, scale, scale);
                    }
                    return new Transforms120.TF_Scale(Float.parseFloat(args[1]), Float.parseFloat(args[2]), Float.parseFloat(args[3]));
                }
                case "gl_rescale_normal": 
                case "rescale_normal": {
                    return Transforms120.TF_RESCALE_NORMAL;
                }
            }
            return null;
        };
        DefaultPrograms20.init();
        ConditionalPrograms.init();
    }

    @Override
    public void initModels() {
        ArrayList<String> tt = new ArrayList<String>();
        for (ItemDisplayContext value : ItemDisplayContext.values()) {
            tt.add(value.name());
        }
        TransformMap.TYPES = tt.toArray(new String[0]);
        super.initModels();
    }

    @Override
    public InputStream getAssetInputStream(IDL loc, boolean log) {
        try {
            return ((Resource)Minecraft.m_91087_().m_91098_().m_213713_((ResourceLocation)loc).get()).m_215507_();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean isModPresent(String s) {
        return false;
    }

    @Override
    public IDL getExternalTexture(String custom) {
        return ExternalTextures.get((String)"fvtm", (String)custom);
    }

    @Override
    public void registerFvtmBlocks() {
        for (int idx = 0; idx < ASPHALT.length; ++idx) {
            int index = idx;
            Resources20.ASPHALT[idx] = FVTM4.BLOCK_REGISTRY.get("fvtm").register("asphalt_" + idx, () -> new Asphalt(index));
        }
        LIFT_BLOCK = FVTM4.BLOCK_REGISTRY.get("fvtm").register("vehicle_lift", () -> new VehicleLiftBlock());
        CONST_BLOCK = FVTM4.BLOCK_REGISTRY.get("fvtm").register("constructor", () -> new ConstructorBlock());
        FUELFILLER_BLOCK = FVTM4.BLOCK_REGISTRY.get("fvtm").register("fuel_filler", () -> new FuelFillerBlock());
    }

    @Override
    public void registerFvtmItems() {
        ROAD_TOOL_ITEM = FVTM4.ITEM_REGISTRY.get("fvtm").register("road_tool", () -> new RoadToolItem());
        for (ToolboxType val : ToolboxType.values()) {
            Resources20.TOOLBOX[val.idx] = FVTM4.ITEM_REGISTRY.get("fvtm").register("toolbox_" + val.idx, () -> new ToolboxItem(val.idx));
        }
        JUNCTION_TOOl = FVTM4.ITEM_REGISTRY.get("fvtm").register("junction_tool", () -> new JunctionTool());
        for (int idx = 0; idx < ASPHALT.length; ++idx) {
            int index = idx;
            Resources20.ASPHALT_ITEM[idx] = FVTM4.ITEM_REGISTRY.get("fvtm").register("asphalt_" + idx, () -> new BlockItem((Block)ASPHALT[index].get(), new Item.Properties()));
        }
        LIFT_BLOCK_ITEM = FVTM4.ITEM_REGISTRY.get("fvtm").register("vehicle_lift", () -> new BlockItem((Block)LIFT_BLOCK.get(), new Item.Properties()));
        CONST_BLOCK_ITEM = FVTM4.ITEM_REGISTRY.get("fvtm").register("constructor", () -> new BlockItem((Block)CONST_BLOCK.get(), new Item.Properties()));
        FUELFILLER_ITEM = FVTM4.ITEM_REGISTRY.get("fvtm").register("fuel_filler", () -> new BlockItem((Block)FUELFILLER_BLOCK.get(), new Item.Properties()));
    }

    @Override
    public double getMouseSensitivity() {
        return 0.0;
    }

    @Override
    public Object getBlockMaterial(String key, boolean allownull) {
        return null;
    }

    @Override
    public void spawnRoadMarker(WorldW world, QV3D vector, UUID nid) {
        RoadMarker marker = (RoadMarker)((EntityType)FVTM4.ROAD_MARKER_ENTITY.get()).m_20615_((Level)world.local());
        marker.queueid = nid;
        marker.position = vector;
        marker.m_6034_(vector.vec.x, vector.vec.y + 1.0, vector.vec.z);
        ((Level)world.direct()).m_7967_((Entity)marker);
    }

    @Override
    public void spawnRailMarker(WorldW world, QV3D vector, UUID nid) {
        RailMarker marker = (RailMarker)((EntityType)FVTM4.RAIL_MARKER_ENTITY.get()).m_20615_((Level)world.local());
        marker.queueid = nid;
        marker.position = vector;
        marker.m_6034_(vector.vec.x, vector.vec.y, vector.vec.z);
        ((Level)world.direct()).m_7967_((Entity)marker);
    }

    @Override
    public void linkItemContainer(ItemWrapper item) {
    }

    static {
        TOOLBOX = new Supplier[ToolboxType.values().length];
        ASPHALT = new Supplier[16];
        ASPHALT_ITEM = new Supplier[16];
    }
}

