/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.util;

import net.fexcraft.lib.common.math.V3D;

public class VecUtil {
    public static V3D rotByRad(double rad, V3D vec) {
        double co = Math.cos(rad);
        double si = Math.sin(rad);
        return new V3D(co * vec.x - si * vec.z, vec.y, si * vec.x + co * vec.z);
    }

    public static V3D rotByDeg(double deg, V3D vec) {
        double co = Math.cos(Math.toRadians(deg));
        double si = Math.sin(Math.toRadians(deg));
        return new V3D(co * vec.x - si * vec.z, vec.y, si * vec.x + co * vec.z);
    }

    public static V3D rotByRad(double rad, double x, double y, double z) {
        double co = Math.cos(rad);
        double si = Math.sin(rad);
        return new V3D(co * x - si * z, y, si * x + co * z);
    }

    public static V3D rotate(V3D vec, double r, double p, double y) {
        double[] arr = new double[]{vec.x, vec.y, vec.z};
        VecUtil.rotate(arr, r, 1, 0, 0);
        VecUtil.rotate(arr, p, 0, 0, 1);
        VecUtil.rotate(arr, y, 0, 1, 0);
        return new V3D(arr[0], arr[1], arr[2]);
    }

    public static double[] rotate(double[] vec, double angle, int ax, int ay, int az) {
        if (angle == 0.0) {
            return vec;
        }
        double c = Math.cos(angle);
        double s = Math.sin(angle);
        double oc = 1.0 - c;
        double xy = ax * ay;
        double yz = ay * az;
        double xz = ax * az;
        double xs = (double)ax * s;
        double ys = (double)ay * s;
        double zs = (double)az * s;
        double f0 = (double)(ax * ax) * oc + c;
        double f1 = xy * oc + zs;
        double f2 = xz * oc - ys;
        double f3 = xy * oc - zs;
        double f4 = (double)(ay * ay) * oc + c;
        double f5 = yz * oc + xs;
        double f6 = xz * oc + ys;
        double f7 = yz * oc - xs;
        double f8 = (double)(az * az) * oc + c;
        double f9 = vec[0] * f0 + vec[1] * f1 + vec[2] * f2;
        double ff = vec[0] * f3 + vec[1] * f4 + vec[2] * f5;
        vec[2] = vec[0] * f6 + vec[1] * f7 + vec[2] * f8;
        vec[1] = ff;
        vec[0] = f9;
        return vec;
    }

    public static double[] rotate(double[] vec, double r, double p, double y) {
        VecUtil.rotate(vec, r, 0, 0, 1);
        VecUtil.rotate(vec, p, 1, 0, 0);
        VecUtil.rotate(vec, y, 0, 1, 0);
        return vec;
    }
}

