/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.attribute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fexcraft.app.json.JsonArray;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.app.json.JsonValue;
import net.fexcraft.lib.common.math.Vec3f;
import net.fexcraft.mod.fvtm.FvtmLogger;
import net.fexcraft.mod.fvtm.FvtmRegistry;
import net.fexcraft.mod.fvtm.FvtmResources;
import net.fexcraft.mod.fvtm.data.attribute.AttrBox;
import net.fexcraft.mod.fvtm.data.attribute.AttrValueType;
import net.fexcraft.mod.fvtm.sys.uni.KeyPress;
import net.fexcraft.mod.uni.IDL;
import net.fexcraft.mod.uni.IDLManager;
import net.fexcraft.mod.uni.tag.TagCW;

public abstract class Attribute<V> {
    public static final IDL DEF_ICON = IDLManager.getIDLCached((String)"fvtm:textures/gui/icons/attr_other.png");
    public ArrayList<String> access = new ArrayList();
    public LinkedHashMap<String, AttrBox> actboxes;
    public HashMap<String, IDL> icons = new HashMap();
    public HashMap<KeyPress, Float> keys;
    public final AttrValueType valuetype;
    public boolean editable;
    public boolean external;
    public boolean sync;
    public String origin;
    public String target;
    public String group;
    public String perm;
    public float min = -2.1474836E9f;
    public float max = 2.1474836E9f;
    public V initial;
    public V value;
    public final String id;

    public Attribute(String aid, AttrValueType type, V val) {
        this.value = val;
        this.initial = this.value;
        this.valuetype = type;
        this.id = aid;
    }

    public <T> T initial() {
        return (T)this.initial;
    }

    public <T> T value() {
        return (T)this.value;
    }

    public void setI(Object val) {
        this.initial = this.validate(val);
    }

    public void set(Object val) {
        this.value = this.validate(val);
    }

    public abstract V validate(Object var1);

    public abstract V parse(String var1);

    public void reset() {
        this.value = this.initial;
    }

    public abstract void increase(float var1);

    public abstract void decrease(float var1);

    public Attribute<?> limit(float min, float max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public Attribute<?> editable(boolean bool) {
        this.editable = bool;
        return this;
    }

    public Attribute<?> group(String string) {
        this.group = string;
        return this;
    }

    public Attribute<?> perm(String string) {
        this.perm = string;
        return this;
    }

    public Attribute<?> sync(boolean bool) {
        this.sync = bool;
        return this;
    }

    public abstract String type();

    public boolean hasPerm() {
        return this.perm != null;
    }

    public abstract int asInteger();

    public abstract long asLong();

    public abstract float asFloat();

    public abstract String asString();

    public abstract boolean asBoolean();

    public Boolean asTristate() {
        if (this.valuetype.isNumber()) {
            return this.asFloat() == 0.0f ? null : Boolean.valueOf(this.asFloat() > 0.0f);
        }
        return this.asBoolean();
    }

    public Vec3f asVector() {
        return new Vec3f(this.asFloat(), 0.0f, 0.0f);
    }

    public <R> R tristate(R n, R t, R f) {
        return this.asTristate() == null ? n : (this.asTristate() != false ? t : f);
    }

    public <R> R bool(R t, R f) {
        return this.asBoolean() ? t : f;
    }

    public boolean toggle() {
        if (this.valuetype.isBoolean()) {
            this.set(!this.asBoolean());
            return this.asBoolean();
        }
        return false;
    }

    public Attribute<?> addAccess(String str) {
        if (!this.access.contains(str)) {
            this.access.add(str);
        }
        this.external = false;
        for (String acc : this.access) {
            if (!acc.contains("external")) continue;
            this.external = true;
        }
        return this;
    }

    public void remAccess(String str) {
        if (this.access.contains(str)) {
            this.access.remove(str);
        }
    }

    public void copyAccessFrom(Attribute<?> other) {
        for (String acc : other.access) {
            this.addAccess(acc);
        }
    }

    public boolean hasBoxes() {
        return this.actboxes != null && this.actboxes.size() > 0;
    }

    public AttrBox getBox(String id) {
        if (!this.hasBoxes()) {
            return null;
        }
        if (!this.actboxes.containsKey(id)) {
            if (id.startsWith("external-")) {
                return this.getBox("external");
            }
            return this.actboxes.get("default");
        }
        return this.actboxes.get(id);
    }

    public void addBox(String id, String point, float ... data) {
        if (this.actboxes == null) {
            this.actboxes = new LinkedHashMap();
        }
        this.actboxes.put(id, new AttrBox(id, point, data));
    }

    public void copyBoxesFrom(Attribute<?> other) {
        if (!other.hasBoxes()) {
            return;
        }
        if (this.actboxes == null) {
            this.actboxes = new LinkedHashMap();
        }
        for (Map.Entry<String, AttrBox> box : other.actboxes.entrySet()) {
            if (this.actboxes.containsKey(box.getKey())) {
                this.actboxes.get(box.getKey()).copy(box.getValue());
                continue;
            }
            this.actboxes.put(box.getKey(), box.getValue().copy());
        }
    }

    public boolean hasKeyPress() {
        return this.keys != null && this.keys.size() > 0;
    }

    public void copyKeysFrom(Attribute<?> other) {
        if (!other.hasKeyPress()) {
            return;
        }
        if (this.keys == null) {
            this.keys = new HashMap();
        }
        this.keys.putAll(other.keys);
    }

    public Float getKeyValue(KeyPress key) {
        return this.keys == null ? null : this.keys.get((Object)key);
    }

    public boolean hasIcons() {
        return this.icons.size() > 0;
    }

    public void copyIconsFrom(Attribute<?> other, boolean override) {
        if (override) {
            this.icons.putAll(other.icons);
            return;
        }
        for (String key : other.icons.keySet()) {
            if (this.icons.containsKey(key)) continue;
            this.icons.put(key, other.icons.get(key));
        }
    }

    public Attribute<?> addIcons(String ... strings) {
        for (int i = 0; i < strings.length; i += 2) {
            this.icons.put(strings[i], IDLManager.getIDLCached((String)strings[i + 1]));
        }
        return this;
    }

    public IDL getCurrentIcon() {
        if (this.icons.size() == 0) {
            return DEF_ICON;
        }
        if (this.icons.containsKey(this.asString())) {
            return this.icons.get(this.asString());
        }
        return this.icons.containsKey("default") ? this.icons.get("default") : DEF_ICON;
    }

    public void genDefaultIcons() {
        if (this.valuetype.isBoolean()) {
            if (!this.icons.containsKey("true")) {
                this.icons.put("true", IDLManager.getIDLCached((String)"fvtm:textures/gui/icons/attr_bool_true.png"));
            }
            if (!this.icons.containsKey("false")) {
                this.icons.put("false", IDLManager.getIDLCached((String)"fvtm:textures/gui/icons/attr_bool_false.png"));
            }
        }
        if (this.valuetype == AttrValueType.TRISTATE) {
            if (!this.icons.containsKey("true")) {
                this.icons.put("true", IDLManager.getIDLCached((String)"fvtm:textures/gui/icons/attr_tristate_true.png"));
            }
            if (!this.icons.containsKey("false")) {
                this.icons.put("false", IDLManager.getIDLCached((String)"fvtm:textures/gui/icons/attr_tristate_false.png"));
            }
            if (!this.icons.containsKey("null")) {
                this.icons.put("null", IDLManager.getIDLCached((String)"fvtm:textures/gui/icons/attr_tristate_null.png"));
            }
        }
    }

    public TagCW save(TagCW com) {
        com.set("type", this.type());
        if (this.origin != null) {
            com.set("origin", this.origin);
        }
        this.saveValue(com);
        return com;
    }

    public abstract void saveValue(TagCW var1);

    public Attribute<V> load(TagCW com) {
        if (com.has("origin")) {
            this.origin = com.getString("origin");
        }
        this.loadValue(com);
        return this;
    }

    public abstract void loadValue(TagCW var1);

    public abstract Attribute<V> newInstance();

    public Attribute<V> createCopy(String origin) {
        Attribute<V> attr = this.newInstance();
        attr.limit(this.min, this.max);
        attr.initial = this.initial;
        attr.value = this.value;
        attr.group = this.group;
        attr.origin = origin;
        attr.target = this.target;
        attr.editable = this.editable;
        attr.external = this.external;
        attr.perm = this.perm;
        attr.sync = this.sync;
        attr.copyIconsFrom(this, true);
        attr.copyAccessFrom(this);
        attr.copyBoxesFrom(this);
        attr.copyKeysFrom(this);
        return attr;
    }

    public static Attribute<?> parse(String id, TagCW com) {
        Class<Attribute<?>> clazz = FvtmRegistry.ATTRIBUTES.get(com.getString("type"));
        if (clazz == null) {
            FvtmLogger.log((Object)("Attribute of type '" + com.getString("type") + "' not found."));
            FvtmLogger.log((Object)("AttrInfo: " + id + " " + com.toString()));
            return null;
        }
        Attribute<?> attr = null;
        try {
            attr = clazz.getConstructor(String.class, JsonMap.class).newInstance(id, new JsonMap());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        return attr.load(com);
    }

    public static Attribute<?> parse(String id, JsonMap map) {
        if (map.has("mod-dep")) {
            JsonValue value = map.get("mod-dep");
            if (value.isArray()) {
                for (JsonValue val : (List)value.asArray().value) {
                    if (FvtmResources.INSTANCE.isModPresent(val.string_value())) continue;
                    return null;
                }
            } else if (!FvtmResources.INSTANCE.isModPresent(value.string_value())) {
                return null;
            }
        }
        String type = map.getString("type", "float");
        Class<Attribute<?>> clazz = FvtmRegistry.ATTRIBUTES.get(type);
        if (type == null) {
            FvtmLogger.log((Object)("Attribute of type '" + type + "' not found."));
            FvtmLogger.log((Object)("AttrInfo: " + id + " " + map.toString()));
            return null;
        }
        Attribute<?> attr = null;
        try {
            attr = clazz.getConstructor(String.class, JsonMap.class).newInstance(id, map);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        if (map.has("min") || map.has("max")) {
            attr.limit(map.getFloat("min", attr.min), map.getFloat("max", attr.max));
        }
        attr.editable = map.getBoolean("editable", true);
        if (map.has("interact")) {
            JsonMap ine = map.getMap("interact");
            for (Map.Entry entry : ine.entries()) {
                JsonArray array = ((JsonValue)entry.getValue()).asArray();
                float[] arr = new float[attr.valuetype.isNumber() && !attr.valuetype.isTristate() ? 7 : 4];
                String point = array.size() > arr.length ? array.get(arr.length).string_value() : null;
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = array.get(i).float_value();
                }
                attr.addBox((String)entry.getKey(), point, arr);
            }
        }
        if (map.has("access")) {
            if (map.get("access").isArray()) {
                for (JsonValue val : (List)map.get((String)"access").asArray().value) {
                    attr.addAccess(val.string_value());
                }
            } else {
                attr.addAccess(map.get("access").string_value());
            }
        }
        attr.target = map.getString("target", "vehicle");
        attr.group = map.getString("group", null);
        attr.perm = map.getString("perm", null);
        attr.sync = map.getBoolean("sync", false);
        if (map.has("icons")) {
            for (Map.Entry entry : map.getMap("icons").entries()) {
                attr.addIcons((String)entry.getKey(), ((JsonValue)entry.getValue()).string_value());
            }
        }
        if (map.has("keys")) {
            if (attr.keys == null) {
                attr.keys = new HashMap();
            }
            for (Map.Entry entry : map.getMap("keys").entries()) {
                try {
                    KeyPress press = KeyPress.valueOf(((String)entry.getKey()).toUpperCase());
                    float val = ((JsonValue)entry.getValue()).string_value().equals("toggle") ? 0.0f : ((JsonValue)entry.getValue()).float_value();
                    attr.keys.put(press, Float.valueOf(val));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return attr;
    }

    public String toString() {
        return String.format("Attr{ %s, %s }", this.id, this.value);
    }
}

