/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.data.block;

import java.util.LinkedHashMap;
import java.util.Map;
import net.fexcraft.app.json.JsonMap;
import net.fexcraft.mod.fvtm.data.ContentData;
import net.fexcraft.mod.fvtm.data.block.MultiBlock;
import net.fexcraft.mod.fvtm.data.inv.InvHandler;
import net.fexcraft.mod.uni.tag.TagCW;

public class MultiBlockData
extends ContentData<MultiBlock, MultiBlockData> {
    private LinkedHashMap<String, InvHandler> inventories = new LinkedHashMap();
    private Object script;

    public MultiBlockData(MultiBlock mblock) {
        super(mblock);
        for (Map.Entry<String, InvHandler> entry : ((MultiBlock)this.type).getDefInventories().entrySet()) {
            this.inventories.put(entry.getKey(), entry.getValue().gen(6));
        }
    }

    @Override
    public TagCW write(TagCW compound) {
        if (compound == null) {
            compound = TagCW.create();
        }
        for (Map.Entry<String, InvHandler> entry : this.inventories.entrySet()) {
            String pre = entry.getValue().getSavePrefix();
            entry.getValue().save(compound, pre + entry.getKey());
        }
        if (this.script != null) {
            // empty if block
        }
        compound.set("type", ((MultiBlock)this.type).getIDS());
        return compound;
    }

    @Override
    public MultiBlockData read(TagCW compound) {
        for (Map.Entry<String, InvHandler> entry : this.inventories.entrySet()) {
            String pre = entry.getValue().getSavePrefix();
            if (!compound.has(pre + entry.getKey())) continue;
            entry.getValue().load(compound, pre + entry.getKey());
        }
        if (this.script != null) {
            // empty if block
        }
        return this;
    }

    @Override
    public MultiBlockData parse(JsonMap obj) {
        return null;
    }

    @Override
    public JsonMap toJson() {
        return null;
    }

    public LinkedHashMap<String, InvHandler> getInventories() {
        return this.inventories;
    }

    public InvHandler getInventory(String invid) {
        return this.inventories.get(invid);
    }
}

