/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.entity;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import net.fexcraft.lib.common.math.V3D;
import net.fexcraft.mod.fvtm.FVTM4;
import net.fexcraft.mod.fvtm.entity.RootVehicle;
import net.fexcraft.mod.fvtm.sys.uni.UniWheel;
import net.fexcraft.mod.fvtm.sys.uni.WheelTireData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class WheelEntity
extends LivingEntity
implements IEntityAdditionalSpawnData,
UniWheel {
    public RootVehicle root;
    private boolean found;
    private int vehid;
    public WheelTireData wheel;
    public String wheelid;
    private float stepheight = 1.125f;
    public double motionX;
    public double motionY;
    public double motionZ;
    private int remtimer;
    protected V3D prev = new V3D();
    protected V3D pos = new V3D();

    public WheelEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public WheelEntity(RootVehicle veh, String wid) {
        super((EntityType)FVTM4.WHEEL_ENTITY.get(), veh.m_9236_());
        this.root = veh;
        this.vehid = this.root.m_19879_();
        this.wheelid = wid;
        this.wheel = this.root.vehicle.wheeldata.get(wid);
        this.setStepHeight();
        if (this.root.vehicle.wheeldata.isEmpty()) {
            if (!this.root.m_213877_()) {
                this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), this.m_20182_().f_82479_, this.m_20182_().f_82480_, this.m_20182_().f_82481_, (ItemStack)this.root.vehicle.data.newItemStack().local()));
                this.root.m_6074_();
            }
            return;
        }
        if (!this.root.vehicle.wheeldata.containsKey(this.wheelid)) {
            this.m_6074_();
            return;
        }
        V3D vec = this.root.vehicle.pivot().get_vector(this.wheel.pos);
        this.m_6034_(this.root.m_20182_().f_82479_ + vec.x, this.root.m_20182_().f_82480_ + vec.y, this.root.m_20182_().f_82481_ + vec.z);
        this.m_146867_();
    }

    private void setStepHeight() {
        WheelTireData wtd = this.root.vehicle.wheeldata.get(this.wheelid);
        this.stepheight = wtd == null ? (this.root.vehicle.spdata == null ? 1.0f : this.root.vehicle.spdata.wheel_step_height) : wtd.function.step_height;
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7378_(CompoundTag tag) {
        this.remtimer = 40;
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.EMPTY_LIST;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack itemStack) {
    }

    public boolean m_6469_(DamageSource src, float am) {
        if (src == this.m_269291_().m_287172_()) {
            this.m_142467_(Entity.RemovalReason.KILLED);
        }
        return false;
    }

    public void m_7380_(CompoundTag tag) {
    }

    public boolean m_6087_() {
        return false;
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_5829_() {
        return false;
    }

    public float getStepHeight() {
        return this.stepheight;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        if (this.wheelid == null) {
            buffer.writeInt(0);
            buffer.writeInt(0);
            return;
        }
        buffer.writeInt(this.vehid);
        buffer.writeInt(this.wheelid.length());
        buffer.writeCharSequence((CharSequence)this.wheelid, StandardCharsets.UTF_8);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.vehid = buffer.readInt();
        this.wheelid = buffer.readCharSequence(buffer.readInt(), StandardCharsets.UTF_8).toString();
        this.root = (RootVehicle)this.m_9236_().m_6815_(this.vehid);
        if (this.root == null) {
            return;
        }
        this.m_146884_(this.root.m_20182_());
        if (this.root.vehicle.data == null) {
            return;
        }
        this.wheel = this.root.vehicle.wheeldata.get(this.wheelid);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        if (this.remtimer > 0) {
            if (this.remtimer == 1) {
                this.m_6074_();
            }
            --this.remtimer;
            return;
        }
        if (!this.found) {
            this.root = (RootVehicle)this.m_9236_().m_6815_(this.vehid);
            if (this.root == null) {
                return;
            }
            this.found = true;
            this.root.vehicle.wheels.put(this.wheelid, this);
        }
    }

    public Vec3 motion() {
        return new Vec3(this.motionX, this.motionY, this.motionZ);
    }

    @Override
    public void updatePrevPos() {
        this.m_146867_();
        this.prev.x = this.f_19790_;
        this.prev.y = this.f_19791_;
        this.prev.z = this.f_19792_;
        this.pos.x = this.m_20182_().f_82479_;
        this.pos.y = this.m_20182_().f_82480_;
        this.pos.z = this.m_20182_().f_82481_;
    }

    @Override
    public void remove() {
        this.m_6074_();
    }

    @Override
    public boolean isAdded() {
        return this.isAddedToWorld();
    }

    @Override
    public V3D prev() {
        return this.prev;
    }

    @Override
    public V3D pos() {
        return this.pos;
    }

    @Override
    public void pos(double x, double y, double z) {
        this.m_6034_(x, y, z);
    }

    @Override
    public void yaw(float yaw) {
        this.m_146922_(yaw);
    }

    @Override
    public void prepare() {
        this.m_6853_(true);
    }

    @Override
    public void move() {
        this.m_6478_(MoverType.SELF, this.motion());
    }

    @Override
    public WheelTireData wtd() {
        return this.wheel;
    }

    @Override
    public void addMotion(double x, double y, double z) {
        this.motionX += x;
        this.motionY += y;
        this.motionZ += z;
    }

    @Override
    public void setMotion(double x, double y, double z) {
        this.motionX = x;
        this.motionY = y;
        this.motionZ = z;
    }

    @Override
    public void mulMotion(double by) {
        this.motionX *= by;
        this.motionY *= by;
        this.motionZ *= by;
    }

    @Override
    public void fillMotion(V3D vec) {
        vec.x = this.motionX;
        vec.y = this.motionY;
        vec.z = this.motionZ;
    }

    public void m_6453_(double x, double y, double z, float yr, float xr, int s, boolean b) {
    }
}

