/*
 * Decompiled with CFR 0.152.
 */
package net.fexcraft.mod.fvtm.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fexcraft.mod.fvtm.block.generated.PlainBase;
import net.fexcraft.mod.fvtm.data.ContentItem;
import net.fexcraft.mod.fvtm.data.ContentType;
import net.fexcraft.mod.fvtm.data.block.Block;
import net.fexcraft.mod.fvtm.data.block.BlockData;
import net.fexcraft.mod.fvtm.data.block.BlockFunction;
import net.fexcraft.mod.fvtm.data.root.ItemTextureable;
import net.fexcraft.mod.fvtm.util.GenericUtils;
import net.fexcraft.mod.uni.inv.StackWrapper;
import net.fexcraft.mod.uni.inv.UniStack;
import net.fexcraft.mod.uni.tag.TagCW;
import net.fexcraft.mod.uni.world.WrapperHolder;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BlockItem20
extends BlockItem
implements ContentItem.ContentDataItem<Block, BlockData>,
ItemTextureable.TextureableItem<Block> {
    public final int var;
    private Block type;

    public BlockItem20(net.minecraft.world.level.block.Block block, int v) {
        super(block, BlockItem20.genProps(((PlainBase)block).type));
        this.type = ((PlainBase)block).type;
        this.var = v;
    }

    private static Item.Properties genProps(Block type) {
        return new Item.Properties().m_41487_(type.getMaxStackSize());
    }

    public boolean m_40610_(BlockPlaceContext context, BlockState state) {
        Block blk;
        if (!super.m_40610_(context, state)) {
            return false;
        }
        return !this.type.getBlockType().isRoadLayer() || !((state = context.m_43725_().m_8055_(context.m_8083_().m_7495_())).m_60734_() instanceof PlainBase) || !(blk = ((PlainBase)state.m_60734_()).type).getBlockType().isRoadLayer();
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        for (String s : this.type.getDescription()) {
            tooltip.add(GenericUtils.format(I18n.m_118938_((String)s, (Object[])new Object[0])));
        }
        if (this.type.getBlockType().isGenericRoad()) {
            tooltip.add(GenericUtils.format("&9Height: &7" + (this.var == 0 ? 16 : this.var)));
        } else if (this.type.getBlockType().getMetaVariants() > 0) {
            tooltip.add(GenericUtils.format("&9Variant: &7" + stack.m_41773_()));
        }
        UniStack uni = UniStack.get((Object)stack);
        if (uni == null) {
            return;
        }
        BlockData data = (BlockData)uni.stack.getContent(ContentType.BLOCK.item_type);
        if (data == null) {
            return;
        }
        if (!((Block)data.getType()).hasPlainModel()) {
            tooltip.add(GenericUtils.format("&9Texture: &7" + this.getTexTitle(data)));
        }
        if (!data.getFunctions().isEmpty()) {
            ArrayList<String> tips = new ArrayList<String>();
            for (BlockFunction func : data.getFunctions()) {
                func.addInformation(uni.stack, WrapperHolder.getWorld((Object)world), data, tips, flag.m_7050_());
            }
            for (String str : tips) {
                tooltip.add(GenericUtils.format(str));
            }
            tooltip.add(GenericUtils.format("&9- - - - - - &7-"));
        }
        if (this.type.getModel() == null) {
            return;
        }
        if (this.type.getModel().getCreators().size() > 0) {
            tooltip.add(GenericUtils.format("&9Model by:"));
            for (String str : this.type.getModel().getCreators()) {
                tooltip.add(GenericUtils.format("&7- " + str));
            }
        }
    }

    private String getTexTitle(BlockData data) {
        if (data.getSelectedTexture() >= 0) {
            return "[" + data.getSelectedTexture() + "] " + ((Block)data.getType()).getDefaultTextures().get(data.getSelectedTexture()).name();
        }
        return data.isTextureExternal() ? "external" : "internal";
    }

    @Override
    public BlockData getData(StackWrapper stack) {
        return this.getData(stack.directTag());
    }

    @Override
    public BlockData getData(TagCW compound) {
        return new BlockData(this.type).read(compound);
    }

    @Override
    public Block getContent() {
        return this.type;
    }

    @Override
    public ContentType getType() {
        return ContentType.BLOCK;
    }
}

